/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.capability.CapabilityReference;
import org.sonatype.nexus.capability.CapabilityRegistry;
import org.sonatype.nexus.common.app.FeatureFlag;

@Named
@Singleton
@FeatureFlag(name="nexus.replication.v1.enabled")
public class ReplicationUtil {
    private final CapabilityRegistry capabilityRegistry;

    @Inject
    public ReplicationUtil(CapabilityRegistry capabilityRegistry) {
        this.capabilityRegistry = (CapabilityRegistry)Preconditions.checkNotNull((Object)capabilityRegistry);
    }

    public boolean isReplicationEnabled() {
        Optional<CapabilityReference> replicationCapability = this.capabilityRegistry.getAll().stream().filter(capability -> "replication".equals(capability.context().type().toString())).findAny();
        if (replicationCapability.isPresent()) {
            return replicationCapability.get().context().isEnabled();
        }
        return false;
    }
}

