/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.replication.ReplicationEnableException;
import com.sonatype.nexus.replication.ReplicationTargetService;
import com.sonatype.nexus.replication.internal.TaskValidationUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.RepositoryEvent;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.config.WritePolicy;
import org.sonatype.nexus.repository.manager.RepositoryManager;

@Named
@Singleton
@FeatureFlag(name="nexus.replication.v1.enabled")
public class ReplicationTargetServiceImpl
extends ComponentSupport
implements ReplicationTargetService,
EventAware {
    public static final String REPLICATION_KEY = "replication";
    public static final String ENABLED_KEY = "enabled";
    public static final String ORIGINAL_WRITE_POLICY = "originalWritePolicy";
    public static final String CONNECTION_NAME_KEY = "connectionName";
    public static final String SOURCE_REPOSITORY_KEY = "sourceRepoName";
    private static final String REPOSITORY_WITH_SPACE = "repository ";
    private final List<Repository> cachedTargetRepositories = new ArrayList<Repository>();
    private final RepositoryManager repositoryManager;
    private final BlobStoreManager blobStoreManager;
    private final TaskValidationUtil taskValidationUtil;

    @Inject
    public ReplicationTargetServiceImpl(RepositoryManager repositoryManager, TaskValidationUtil taskValidationUtil, BlobStoreManager blobStoreManager) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.taskValidationUtil = (TaskValidationUtil)((Object)Preconditions.checkNotNull((Object)((Object)taskValidationUtil)));
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
    }

    @Override
    public void enable(String targetRepositoryName, String connectionName, String sourceRepositoryName) throws ReplicationEnableException {
        Repository repository = this.getRepository(targetRepositoryName);
        Configuration configuration = repository.getConfiguration();
        boolean repositoryAlreadyReplicating = (Boolean)configuration.attributes(REPLICATION_KEY).get(ENABLED_KEY, Boolean.class, (Object)false);
        if (repositoryAlreadyReplicating) {
            throw new ReplicationEnableException(REPOSITORY_WITH_SPACE + targetRepositoryName + " already has replication enabled");
        }
        String blobStoreName = (String)configuration.attributes("storage").get("blobStoreName", String.class);
        if (this.blobStoreManager.get(blobStoreName).getBlobStoreConfiguration().getType().equals("Group")) {
            throw new ReplicationEnableException(REPOSITORY_WITH_SPACE + targetRepositoryName + " is part of a Group Blob Store and it's not currently supported.");
        }
        this.taskValidationUtil.ensureNoConflictingTasks(repository.getName());
        configuration.attributes(REPLICATION_KEY).set(ENABLED_KEY, (Object)true);
        configuration.attributes(REPLICATION_KEY).set(ORIGINAL_WRITE_POLICY, configuration.attributes("storage").require("writePolicy"));
        configuration.attributes("storage").set("writePolicy", (Object)WritePolicy.REPLICATION_ONLY);
        configuration.attributes(REPLICATION_KEY).set(CONNECTION_NAME_KEY, (Object)connectionName);
        configuration.attributes(REPLICATION_KEY).set(SOURCE_REPOSITORY_KEY, (Object)sourceRepositoryName);
        this.updateRepositoryConfiguration(configuration);
    }

    @Override
    public void disable(String targetRepositoryName) throws ReplicationEnableException {
        Repository repository = this.getRepository(targetRepositoryName);
        Configuration configuration = repository.getConfiguration();
        boolean repositoryAlreadyReplicating = (Boolean)configuration.attributes(REPLICATION_KEY).get(ENABLED_KEY, Boolean.class, (Object)false);
        if (!repositoryAlreadyReplicating) {
            throw new ReplicationEnableException(REPOSITORY_WITH_SPACE + targetRepositoryName + " does not have replication enabled");
        }
        configuration.attributes(REPLICATION_KEY).set(ENABLED_KEY, (Object)false);
        Object originalWritePolicy = configuration.attributes(REPLICATION_KEY).get(ORIGINAL_WRITE_POLICY);
        configuration.attributes(REPLICATION_KEY).set(CONNECTION_NAME_KEY, (Object)"");
        configuration.attributes(REPLICATION_KEY).set(SOURCE_REPOSITORY_KEY, (Object)"");
        if (originalWritePolicy != null) {
            configuration.attributes("storage").set("writePolicy", (Object)originalWritePolicy.toString());
            configuration.attributes(REPLICATION_KEY).remove(ORIGINAL_WRITE_POLICY);
        }
        this.updateRepositoryConfiguration(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    @VisibleForTesting
    void on(RepositoryEvent event) {
        List<Repository> list = this.cachedTargetRepositories;
        synchronized (list) {
            if (!this.cachedTargetRepositories.isEmpty()) {
                this.log.debug("RepositoryEvent has occurred, clearing the replication sync log cache.");
                this.cachedTargetRepositories.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Repository> getEnabledTargetRepositories() {
        List<Repository> list = this.cachedTargetRepositories;
        synchronized (list) {
            if (this.cachedTargetRepositories.isEmpty()) {
                this.log.debug("Populating target repository cache from database.");
                this.cachedTargetRepositories.addAll(StreamSupport.stream(this.repositoryManager.browse().spliterator(), false).filter(repository -> (Boolean)repository.getConfiguration().attributes(REPLICATION_KEY).get(ENABLED_KEY, Boolean.class, (Object)false)).collect(Collectors.toList()));
            }
            return new ArrayList<Repository>(this.cachedTargetRepositories);
        }
    }

    private Repository getRepository(String repositoryName) throws ReplicationEnableException {
        Repository repository = this.repositoryManager.get(repositoryName);
        if (repository == null) {
            throw new ReplicationEnableException("source repository for the replication connection not found");
        }
        if (!repository.getType().getValue().equals("hosted")) {
            throw new ReplicationEnableException(REPOSITORY_WITH_SPACE + repository.getName() + " must be a hosted type repository");
        }
        return repository;
    }

    private void updateRepositoryConfiguration(Configuration repositoryConfiguration) throws ReplicationEnableException {
        try {
            this.repositoryManager.update(repositoryConfiguration);
        }
        catch (Exception exception) {
            this.log.error("unable to update configuration for repository {}", (Object)repositoryConfiguration.getRepositoryName());
            throw new ReplicationEnableException("unable to update configuration for repository " + repositoryConfiguration.getRepositoryName());
        }
    }
}

