/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.replication.internal.ReplicationCapability;
import java.util.Date;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.capability.CapabilityEvent;
import org.sonatype.nexus.capability.CapabilityRegistry;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.schedule.Cron;
import org.sonatype.nexus.scheduling.schedule.Schedule;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
@Singleton
@FeatureFlag(name="nexus.replication.v1.enabled")
public class ReplicationSyncLogTaskManager
extends StateGuardLifecycleSupport
implements EventAware {
    private final TaskScheduler taskScheduler;
    private final CapabilityRegistry capabilityRegistry;
    private final String ingestCron;

    @Inject
    public ReplicationSyncLogTaskManager(TaskScheduler taskScheduler, CapabilityRegistry capabilityRegistry, @Named(value="${nexus.replication.ingest.cron:-0/10 * * * * ?}") @Named(value="${nexus.replication.ingest.cron:-0/10 * * * * ?}") String ingestCron) {
        this.taskScheduler = Objects.requireNonNull(taskScheduler);
        this.capabilityRegistry = Objects.requireNonNull(capabilityRegistry);
        this.ingestCron = Objects.requireNonNull(ingestCron);
    }

    @AllowConcurrentEvents
    @Subscribe
    void on(CapabilityEvent.AfterActivated event) {
        if (ReplicationCapability.TYPE.equals((Object)event.getReference().context().type())) {
            this.maybeScheduleTask();
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    void on(CapabilityEvent.BeforePassivated event) {
        if (ReplicationCapability.TYPE.equals((Object)event.getReference().context().type())) {
            this.taskScheduler.listsTasks().stream().filter(info -> "replication.ingest".equals(info.getConfiguration().getTypeId())).findFirst().map(t -> this.taskScheduler.getTaskById(t.getId())).ifPresent(TaskInfo::remove);
        }
    }

    private void maybeScheduleTask() {
        if (this.taskScheduler.listsTasks().stream().noneMatch(info -> "replication.ingest".equals(info.getConfiguration().getTypeId()))) {
            TaskConfiguration configuration = this.taskScheduler.createTaskConfigurationInstance("replication.ingest");
            Cron schedule = this.taskScheduler.getScheduleFactory().cron(new Date(), this.ingestCron);
            this.taskScheduler.scheduleTask(configuration, (Schedule)schedule);
        }
    }
}

