/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal;

import com.sonatype.nexus.replication.ReplicationConnectionManager;
import com.sonatype.nexus.replication.TargetInstanceConnector;
import com.sonatype.nexus.replication.db.model.ReplicationConnection;
import com.sonatype.nexus.replication.internal.ReplicationConnectionException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.api.RawObjectAccess;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;

@Named
@FeatureFlag(name="nexus.replication.v1.enabled")
public class ReplicationService
extends ComponentSupport {
    private final String SYNC_LOG_PATH = "replication/sync_logs/";
    private Path LOCK_FILE_PATH = Paths.get("replicator-running.lock", new String[0]);
    private Path FILE_LISTING_PATH = Paths.get("replication", "filelisting.txt");
    private final TargetInstanceConnector targetInstanceConnector;
    private final ReplicationConnectionManager replicationConnectionManager;
    private final RepositoryManager repositoryManager;
    private final BlobStoreManager blobStoreManager;

    @Inject
    public ReplicationService(TargetInstanceConnector targetInstanceConnector, ReplicationConnectionManager replicationConnectionManager, RepositoryManager repositoryManager, BlobStoreManager blobStoreManager) {
        this.targetInstanceConnector = Objects.requireNonNull(targetInstanceConnector);
        this.replicationConnectionManager = Objects.requireNonNull(replicationConnectionManager);
        this.repositoryManager = Objects.requireNonNull(repositoryManager);
        this.blobStoreManager = Objects.requireNonNull(blobStoreManager);
    }

    public boolean deleteConnection(ReplicationConnection replicationConnection) {
        try {
            this.targetInstanceConnector.disableReplication(replicationConnection);
        }
        catch (ReplicationConnectionException e) {
            if (this.log.isDebugEnabled() && e.getCause() != null) {
                this.log.error(e.getMessage(), e.getCause());
            }
            this.log.error(e.getMessage());
        }
        return this.replicationConnectionManager.delete(replicationConnection.getId());
    }

    public Set<BlobStore> getSourceBlobStores(Collection<ReplicationConnection> connections) {
        return connections.stream().map(ReplicationConnection::getSourceRepositoryName).map(arg_0 -> ((RepositoryManager)this.repositoryManager).get(arg_0)).filter(Objects::nonNull).map(this::getBlobStore).collect(Collectors.toSet());
    }

    public List<Repository> getTargetRepositories() {
        return StreamSupport.stream(this.repositoryManager.browse().spliterator(), false).filter(this::isTargetRepository).collect(Collectors.toList());
    }

    public void deleteFileListing(BlobStore blobStore) {
        RawObjectAccess rawObjectAccess = blobStore.getRawObjectAccess();
        if (rawObjectAccess.hasRawObject(this.FILE_LISTING_PATH)) {
            rawObjectAccess.deleteRawObject(this.FILE_LISTING_PATH);
        }
    }

    public void deleteLockFile(BlobStore blobStore) {
        RawObjectAccess rawObjectAccess = blobStore.getRawObjectAccess();
        if (rawObjectAccess.hasRawObject(this.LOCK_FILE_PATH)) {
            rawObjectAccess.deleteRawObject(this.LOCK_FILE_PATH);
        }
    }

    public void deleteSourceSyncLogs(ReplicationConnection connection) {
        this.log.info("delete sync_logs for {}", (Object)connection.getName());
        Repository sourceRepository = this.repositoryManager.get(connection.getSourceRepositoryName());
        BlobStore blobStore = this.getBlobStore(sourceRepository);
        RawObjectAccess rawObjectAccess = blobStore.getRawObjectAccess();
        rawObjectAccess.deleteRawObjectsInPath(Paths.get("replication/sync_logs/", connection.getDestinationRepositoryName(), "raw"));
        rawObjectAccess.deleteRawObjectsInPath(Paths.get("replication/sync_logs/", connection.getDestinationRepositoryName()));
    }

    public void deleteTargetSyncLogs(Repository targetRepository) {
        this.log.info("delete sync_logs for {}", (Object)targetRepository.getName());
        BlobStore blobStore = this.getBlobStore(targetRepository);
        RawObjectAccess rawObjectAccess = blobStore.getRawObjectAccess();
        rawObjectAccess.deleteRawObjectsInPath(Paths.get("replication/sync_logs/", targetRepository.getName(), "raw"));
        rawObjectAccess.deleteRawObjectsInPath(Paths.get("replication/sync_logs/", targetRepository.getName()));
    }

    public BlobStore getBlobStore(Repository repository) {
        String name = (String)repository.getConfiguration().attributes("storage").get("blobStoreName");
        return this.blobStoreManager.get(name);
    }

    private boolean isTargetRepository(Repository repository) {
        return repository.getConfiguration().attributes("replication").get("enabled") != null;
    }
}

