/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.replication.events.ReplicationQueueItemAddedEvent;
import com.sonatype.nexus.replication.internal.FileListingGenerator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.event.EventAware;

@Named
@Singleton
@FeatureFlag(name="nexus.replication.v1.enabled")
public class ReplicationQueueWatcher
extends ComponentSupport
implements EventAware,
EventAware.Asynchronous {
    private final ConcurrentMap<String, AtomicBoolean> replicationConnectionIdMap = new ConcurrentHashMap<String, AtomicBoolean>();
    private final FileListingGenerator fileListingGenerator;

    @Inject
    public ReplicationQueueWatcher(FileListingGenerator fileListingGenerator) {
        this.fileListingGenerator = (FileListingGenerator)((Object)Preconditions.checkNotNull((Object)((Object)fileListingGenerator)));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(ReplicationQueueItemAddedEvent event) {
        String replicationConnectionId = event.getReplicationConnectionId();
        AtomicBoolean ab = this.replicationConnectionIdMap.putIfAbsent(replicationConnectionId, new AtomicBoolean(false));
        if (ab == null) {
            ab = (AtomicBoolean)this.replicationConnectionIdMap.get(replicationConnectionId);
        }
        if (!ab.getAndSet(true)) {
            try {
                try {
                    this.log.debug("Received ReplicationQueueItemAddedEvent for replicationConnectionId {}, will start generating the file listing.", (Object)replicationConnectionId);
                    this.fileListingGenerator.writeFile(replicationConnectionId);
                }
                catch (Exception e) {
                    this.log.error("Unexpected exception writing file listing", (Throwable)e);
                    ab.set(false);
                }
            }
            finally {
                ab.set(false);
            }
        }
    }
}

