/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.replication.FileListingWatcher;
import com.sonatype.nexus.replication.ReplicationQueueManager;
import com.sonatype.nexus.replication.events.ReplicationQueueItemAddedEvent;
import com.sonatype.nexus.replication.internal.QueueManagerSupport;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.jmx.reflect.ManagedAttribute;
import org.sonatype.nexus.jmx.reflect.ManagedObject;

@Named(value="replicate")
@ManagedObject
@Singleton
@FeatureFlag(name="nexus.replication.v1.enabled")
public class ReplicationQueueManagerImpl
extends QueueManagerSupport
implements ReplicationQueueManager {
    public static final String QUEUE_TYPE = "replicate";
    public static final String REPLICATION_QUEUE_DIR = "blobs/_replication";
    private final FileListingWatcher fileListingWatcher;
    private final int maxBatchSize;

    @Inject
    public ReplicationQueueManagerImpl(ApplicationDirectories applicationDirectories, EventManager eventManager, FileListingWatcher fileListingWatcher, @Named(value="${nexus.replication.outputqueue.batchsize:-100}") @Named(value="${nexus.replication.outputqueue.batchsize:-100}") int maxBatchSize) {
        super(applicationDirectories, eventManager, ReplicationQueueItemAddedEvent::new, true);
        this.fileListingWatcher = (FileListingWatcher)Preconditions.checkNotNull((Object)fileListingWatcher);
        this.maxBatchSize = maxBatchSize;
    }

    @Override
    protected String getQueuePath() {
        return REPLICATION_QUEUE_DIR;
    }

    @Override
    protected int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    @Override
    protected void inUseRemoved(String identifier) {
        this.fileListingWatcher.addReplicationConnection(identifier, this.getConsumer(identifier));
    }

    @Override
    public void maybeStartWatching(String identifier) {
        this.fileListingWatcher.addReplicationConnection(identifier, this.getConsumer(identifier));
    }

    @Override
    @ManagedAttribute
    public Map<String, Integer> getQueueSizes() {
        return super.getQueueSizes();
    }

    private Consumer<Path> getConsumer(String identifier) {
        return path -> {
            this.log.debug("filelisting has been removed for replicationConnection {}, will generate new one if content available.", (Object)identifier);
            this.getQueue(identifier).maybeNotify();
        };
    }
}

