/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.replication.events.ReplicationIngestQueueItemAddedEvent;
import com.sonatype.nexus.replication.internal.BlobStoreIngester;
import com.sonatype.nexus.replication.internal.ExecutorServiceUtil;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;

@Named(value="replicationIngestQueueWatcher")
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
@FeatureFlag(name="nexus.replication.v1.enabled")
public class ReplicationIngestQueueWatcherImpl
extends StateGuardLifecycleSupport
implements EventAware.Asynchronous {
    private final BlobStoreIngester blobStoreIngester;
    private final ConcurrentMap<String, AtomicBoolean> repositoryMap = new ConcurrentHashMap<String, AtomicBoolean>();
    private final ExecutorServiceUtil executorServiceUtil;
    private final EventManager eventManager;

    @Inject
    public ReplicationIngestQueueWatcherImpl(BlobStoreIngester blobStoreIngester, ExecutorServiceUtil executorServiceUtil, EventManager eventManager) {
        this.blobStoreIngester = Objects.requireNonNull(blobStoreIngester);
        this.executorServiceUtil = Objects.requireNonNull(executorServiceUtil);
        this.eventManager = Objects.requireNonNull(eventManager);
    }

    protected void doStart() {
        this.eventManager.register((Object)this);
    }

    protected void doStop() {
        this.eventManager.unregister((Object)this);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(ReplicationIngestQueueItemAddedEvent event) {
        String blobstore = event.getBlobstore();
        AtomicBoolean ab = this.getStatusBoolean(blobstore);
        if (!ab.getAndSet(true)) {
            this.log.debug("Received ReplicationIngestQueueItemAddedEvent for blobstore {}, will start ingesting", (Object)blobstore);
            this.executorServiceUtil.getIngesterExecutorService().submit(() -> this.blobStoreIngester.execute(blobstore, ab));
        }
    }

    private AtomicBoolean getStatusBoolean(String blobstore) {
        AtomicBoolean ab = this.repositoryMap.putIfAbsent(blobstore, new AtomicBoolean(false));
        if (ab == null) {
            ab = (AtomicBoolean)this.repositoryMap.get(blobstore);
        }
        return ab;
    }
}

