/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal;

import com.sonatype.nexus.replication.ReplicationConnectionManager;
import com.sonatype.nexus.replication.ReplicationConnectionStore;
import com.sonatype.nexus.replication.ReplicationDuplicateException;
import com.sonatype.nexus.replication.db.model.ReplicationConnection;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
@FeatureFlag(name="nexus.replication.v1.enabled")
public class ReplicationConnectionManagerImpl
extends StateGuardLifecycleSupport
implements ReplicationConnectionManager {
    private final ReplicationConnectionStore replicationConnectionStore;
    private final Map<String, ReplicationConnection> byName = new ConcurrentHashMap<String, ReplicationConnection>();
    private final Map<String, ReplicationConnection> byId = new ConcurrentHashMap<String, ReplicationConnection>();

    @Inject
    public ReplicationConnectionManagerImpl(ReplicationConnectionStore replicationConnectionStore) {
        this.replicationConnectionStore = Objects.requireNonNull(replicationConnectionStore);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.replicationConnectionStore.list().forEach(con -> {
            this.byName.put(con.getName(), (ReplicationConnection)con);
            this.byId.put(con.getId(), (ReplicationConnection)con);
        });
    }

    @Override
    @Guarded(by={"STARTED"})
    public Collection<ReplicationConnection> list() {
        return this.byName.values();
    }

    @Override
    @Guarded(by={"STARTED"})
    public Collection<ReplicationConnection> listBySourceRepository(String source) {
        Objects.requireNonNull(source);
        return this.byName.values().stream().filter(connection -> source.equals(connection.getSourceRepositoryName())).collect(Collectors.toList());
    }

    @Override
    @Guarded(by={"STARTED"})
    public void create(ReplicationConnection connection) throws ReplicationDuplicateException {
        Objects.requireNonNull(connection);
        Objects.requireNonNull(connection.getName());
        Objects.requireNonNull(connection.getId());
        this.replicationConnectionStore.create(connection);
        this.replicationConnectionStore.detach(connection);
        this.byName.put(connection.getName(), connection);
        this.byId.put(connection.getId(), connection);
    }

    @Override
    @Guarded(by={"STARTED"})
    public void update(ReplicationConnection update) {
        Objects.requireNonNull(update);
        this.replicationConnectionStore.update(update);
        this.replicationConnectionStore.detach(update);
        this.byName.put(update.getName(), update);
        this.byId.put(update.getId(), update);
    }

    @Override
    @Guarded(by={"STARTED"})
    public boolean delete(String connectionId) {
        Objects.requireNonNull(connectionId);
        if (this.replicationConnectionStore.delete(connectionId)) {
            ReplicationConnection removed = this.byId.remove(connectionId);
            if (removed != null) {
                this.byName.remove(removed.getName());
            }
            return true;
        }
        return false;
    }

    @Override
    public ReplicationConnection newReplicationConnection() {
        return this.replicationConnectionStore.newReplicationConnection();
    }

    @Override
    public Optional<ReplicationConnection> getById(String id) {
        return Optional.ofNullable(this.byId.get(id));
    }

    @Override
    public Optional<ReplicationConnection> getByName(String name) {
        return Optional.ofNullable(this.byName.get(name));
    }

    @Override
    public List<String> getSourceRepositories() {
        return this.byName.values().stream().map(ReplicationConnection::getSourceRepositoryName).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }
}

