/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal;

import com.sonatype.nexus.replication.QueueManager;
import com.sonatype.nexus.replication.ReplicationConnectionManager;
import com.sonatype.nexus.replication.db.model.ReplicationConnection;
import com.sonatype.nexus.replication.internal.ReplicationService;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.repository.Repository;

@Named
@FeatureFlag(name="nexus.replication.v1.enabled")
public class ReplicationCleanup
extends ComponentSupport {
    private final ReplicationService replicationService;
    private final ReplicationConnectionManager replicationConnectionManager;
    private final QueueManager replicationQueueManager;
    private final QueueManager ingestQueueManager;

    @Inject
    public ReplicationCleanup(ReplicationService replicationService, ReplicationConnectionManager replicationConnectionManager, @Named(value="replicate") @Named(value="replicate") QueueManager replicationQueueManager, @Named(value="ingest") @Named(value="ingest") QueueManager ingestQueueManager) {
        this.replicationService = Objects.requireNonNull(replicationService);
        this.replicationConnectionManager = Objects.requireNonNull(replicationConnectionManager);
        this.replicationQueueManager = Objects.requireNonNull(replicationQueueManager);
        this.ingestQueueManager = Objects.requireNonNull(ingestQueueManager);
    }

    public void run() {
        this.log.info("Replication disabled - cleaning up replication artifacts");
        Collection<ReplicationConnection> connections = this.replicationConnectionManager.list();
        List<Repository> targetRepositories = this.replicationService.getTargetRepositories();
        Set<BlobStore> sourceBlobStores = this.replicationService.getSourceBlobStores(connections);
        this.cleanupFileListings(sourceBlobStores);
        this.cleanupLockFiles(sourceBlobStores);
        this.cleanupSourceSyncLogs(connections);
        this.cleanupTargetSyncLogs(targetRepositories);
        this.cleanupConnections(connections);
        this.cleanupQueues();
        this.log.info("Finished cleaning up replication artifacts");
    }

    private void cleanupConnections(Collection<ReplicationConnection> connections) {
        this.log.info("Cleaning up replication connections");
        connections.forEach(this.replicationService::deleteConnection);
    }

    private void cleanupFileListings(Set<BlobStore> sourceBlobStores) {
        this.log.info("Cleaning up replication file listings");
        sourceBlobStores.forEach(this.replicationService::deleteFileListing);
    }

    private void cleanupLockFiles(Set<BlobStore> sourceBlobStores) {
        this.log.info("Cleaning up replication lock files");
        sourceBlobStores.forEach(this.replicationService::deleteLockFile);
    }

    private void cleanupSourceSyncLogs(Collection<ReplicationConnection> connections) {
        this.log.info("Cleaning up sync_logs");
        connections.forEach(this.replicationService::deleteSourceSyncLogs);
    }

    private void cleanupTargetSyncLogs(List<Repository> targetRepositories) {
        this.log.info("Cleaning up sync_logs");
        targetRepositories.forEach(this.replicationService::deleteTargetSyncLogs);
    }

    private void cleanupQueues() {
        this.log.info("Cleaning up replication queues");
        this.replicationQueueManager.deleteQueues();
        this.ingestQueueManager.deleteQueues();
    }
}

