/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.sonatype.nexus.replication.internal.ReplicationFeature;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.licensing.feature.Feature;
import org.sonatype.licensing.feature.LicenseFeatureVerifier;
import org.sonatype.nexus.common.db.DatabaseCheck;
import org.sonatype.nexus.common.property.SystemPropertiesHelper;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Recipe;

@Named
@Singleton
public class ReplicationChecks
extends ComponentSupport {
    private final DatabaseCheck databaseCheck;
    private final boolean httpReplicationEnabled;
    private final boolean downstreamReplicationEnabled;
    private final LicenseFeatureVerifier licenseFeatureVerifier;
    private final ReplicationFeature replicationFeature;
    private final Map<String, Boolean> supportedFormats = new ConcurrentHashMap<String, Boolean>();

    @Inject
    public ReplicationChecks(DatabaseCheck databaseCheck, Map<String, Recipe> recipeMap, LicenseFeatureVerifier licenseFeatureVerifier, ReplicationFeature replicationFeature, @Named(value="${nexus.replication.http.enabled:-true}") @Named(value="${nexus.replication.http.enabled:-true}") boolean httpReplicationEnabled, @Named(value="${nexus.replication.http.downstream.enabled:-true}") @Named(value="${nexus.replication.http.downstream.enabled:-true}") boolean downstreamReplicationEnabled) {
        this.databaseCheck = Objects.requireNonNull(databaseCheck);
        this.licenseFeatureVerifier = Objects.requireNonNull(licenseFeatureVerifier);
        this.replicationFeature = Objects.requireNonNull(replicationFeature);
        this.httpReplicationEnabled = httpReplicationEnabled;
        this.downstreamReplicationEnabled = downstreamReplicationEnabled;
        if (this.isTargetFeatureEnabled()) {
            this.getDefaultFormatNames().forEach(name -> {
                this.log.info("Added Replication default supported format: {}", name);
                this.supportedFormats.put((String)name, this.queryFormatProperty((String)name, true));
            });
            if (recipeMap != null) {
                recipeMap.values().stream().map(Recipe::getFormat).filter(Objects::nonNull).map(Format::getValue).filter(Objects::nonNull).forEach(name -> {
                    boolean supported = this.queryFormatProperty((String)name, false);
                    if (!this.supportedFormats.containsKey(name)) {
                        this.supportedFormats.put((String)name, supported);
                        this.log.debug("Added Replication format: {}, supported={}", name, (Object)supported);
                    }
                });
            }
        }
    }

    @VisibleForTesting
    Set<String> getDefaultFormatNames() {
        return ImmutableSet.builder().add((Object)"apt").add((Object)"docker").add((Object)"helm").add((Object)"maven2").add((Object)"npm").add((Object)"nuget").add((Object)"r").add((Object)"raw").add((Object)"rubygems").build();
    }

    public boolean isProVersion() {
        return this.licenseFeatureVerifier.verify((Feature)this.replicationFeature);
    }

    public boolean isHttpReplicationEnabled() {
        return this.httpReplicationEnabled;
    }

    public boolean isPostgresql() {
        return this.databaseCheck.isPostgresql();
    }

    public boolean isTargetFeatureEnabled() {
        return this.isProVersion() && this.isPostgresql() && this.isHttpReplicationEnabled();
    }

    public boolean isDownstreamReplicationEnabled() {
        return this.downstreamReplicationEnabled;
    }

    public boolean isSourceFeatureEnabled() {
        return this.isProVersion() && this.isPostgresql() && this.isHttpReplicationEnabled() && this.isDownstreamReplicationEnabled();
    }

    public boolean isFormatSupported(String formatName) {
        return this.supportedFormats.computeIfAbsent(formatName, f -> this.queryFormatProperty(formatName, false));
    }

    private boolean queryFormatProperty(String formatName, boolean defaultValue) {
        if (!this.isTargetFeatureEnabled()) {
            return false;
        }
        return SystemPropertiesHelper.getBoolean((String)String.format("nexus.%s.replication.supported", formatName), (boolean)defaultValue);
    }

    public Set<String> getSupportedFormatNames() {
        return (Set)this.supportedFormats.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(ImmutableSet.toImmutableSet());
    }
}

