/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.replication.QueueManager;
import com.sonatype.nexus.replication.internal.FileReplicationQueueImpl;
import com.sonatype.nexus.replication.internal.ReplicationQueue;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.repository.replication.BlobEvent;

@FeatureFlag(name="nexus.replication.v1.enabled")
public abstract class QueueManagerSupport
extends StateGuardLifecycleSupport
implements QueueManager {
    @Nullable
    final Function<String, Object> eventFactory;
    private final ConcurrentMap<String, ReplicationQueue> replicationQueues = new ConcurrentHashMap<String, ReplicationQueue>();
    private final ApplicationDirectories applicationDirectories;
    private final EventManager eventManager;
    private final boolean isOutbound;

    public QueueManagerSupport(ApplicationDirectories applicationDirectories, EventManager eventManager, @Nullable Function<String, Object> eventFactory, boolean isOutbound) {
        this.applicationDirectories = (ApplicationDirectories)Preconditions.checkNotNull((Object)applicationDirectories);
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.eventFactory = eventFactory;
        this.isOutbound = isOutbound;
    }

    protected void doStart() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Stream<Path> files = Files.walk(this.applicationDirectories.getWorkDirectory(this.getQueuePath()).toPath(), new FileVisitOption[0]);){
            files.filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(path -> !path.getFileName().toString().endsWith(".in_use")).forEach(path -> {
                String identifier = path.getFileName().toString();
                ReplicationQueue replicationQueue = this.createQueue(identifier, this.isOutbound);
                this.replicationQueues.put(identifier, replicationQueue);
                this.log.info("Loaded replication queue {} containing {} entries.", (Object)identifier, (Object)replicationQueue.size());
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void doStop() {
        for (ReplicationQueue replicationQueue : this.replicationQueues.values()) {
            replicationQueue.close();
        }
        this.replicationQueues.clear();
    }

    @Override
    public void addToQueue(String identifier, BlobEvent blobEvent) {
        this.replicationQueues.computeIfAbsent(identifier, i -> this.createQueue((String)i, this.isOutbound)).push(blobEvent);
    }

    @Override
    public List<BlobEvent> takeNextBatch(String identifier) {
        return ((ReplicationQueue)this.replicationQueues.get(identifier)).takeNextBatch();
    }

    @Override
    public void removeInUse(String identifier) {
        ReplicationQueue replicationQueue = (ReplicationQueue)this.replicationQueues.get(identifier);
        if (replicationQueue != null) {
            replicationQueue.removeInUse();
            this.inUseRemoved(identifier);
        } else {
            this.log.debug("Replication queue {} not found, nothing to remove.", (Object)identifier);
        }
    }

    @Override
    public void clearInUse(String identifier) {
        ReplicationQueue replicationQueue = (ReplicationQueue)this.replicationQueues.get(identifier);
        if (replicationQueue != null) {
            replicationQueue.clearInUse();
        } else {
            this.log.debug("Replication queue {} not found, nothing to remove.", (Object)identifier);
        }
    }

    @Override
    public void maybeNotify(String identifier) {
        ReplicationQueue replicationQueue = (ReplicationQueue)this.replicationQueues.get(identifier);
        if (replicationQueue != null) {
            replicationQueue.maybeNotify();
        } else {
            this.log.debug("Replication queue {} not found, nothing to notify.", (Object)identifier);
        }
    }

    @Override
    @VisibleForTesting
    public void clearQueues() {
        for (ReplicationQueue replicationQueue : this.replicationQueues.values()) {
            replicationQueue.removeAll();
        }
        this.replicationQueues.clear();
    }

    @Override
    public void deleteQueues() {
        for (ReplicationQueue replicationQueue : this.replicationQueues.values()) {
            replicationQueue.close();
        }
        this.replicationQueues.clear();
        try {
            FileUtils.deleteDirectory((File)this.applicationDirectories.getWorkDirectory(this.getQueuePath()));
        }
        catch (IOException e) {
            this.log.warn("Unable to delete replication queue directory", (Throwable)e);
        }
    }

    @Override
    public int size(String identifier) {
        ReplicationQueue queue = (ReplicationQueue)this.replicationQueues.get(identifier);
        if (queue != null) {
            return queue.size();
        }
        return 0;
    }

    @Override
    public Map<String, Integer> getQueueSizes() {
        return this.replicationQueues.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ReplicationQueue)e.getValue()).size()));
    }

    protected abstract String getQueuePath();

    protected abstract int getMaxBatchSize();

    protected void inUseRemoved(String blobstore) {
    }

    protected ReplicationQueue getQueue(String identifier) {
        return (ReplicationQueue)this.replicationQueues.get(identifier);
    }

    private ReplicationQueue createQueue(String identifier, boolean isOutbound) {
        return new FileReplicationQueueImpl(this.applicationDirectories, this.eventManager, identifier, this.getMaxBatchSize(), this.getQueuePath(), this.eventFactory, isOutbound);
    }
}

