/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.replication.events.ReplicationQueueBlobReplicatedEvent;
import com.sonatype.nexus.replication.events.ReplicationQueueSizeChangeEvent;
import com.sonatype.nexus.replication.internal.ReplicationQueue;
import com.squareup.tape.FileObjectQueue;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.repository.replication.BlobEvent;
import org.sonatype.nexus.repository.replication.BlobEventType;

@FeatureFlag(name="nexus.replication.v1.enabled")
public class FileReplicationQueueImpl
extends ComponentSupport
implements ReplicationQueue {
    public static final String IN_USE_SUFFIX = ".in_use";
    private final EventManager eventManager;
    private final String identifier;
    private final int maxBatchSize;
    private final FileObjectQueue<BlobEvent> queue;
    private final FileObjectQueue<BlobEvent> inUse;
    @Nullable
    private final Function<String, Object> eventFactory;
    private final boolean isOutbound;

    public FileReplicationQueueImpl(ApplicationDirectories applicationDirectories, EventManager eventManager, String identifier, int maxBatchSize, String queuePath, @Nullable Function<String, Object> eventFactory, boolean isOutbound) {
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.identifier = (String)Preconditions.checkNotNull((Object)identifier);
        this.maxBatchSize = maxBatchSize;
        this.eventFactory = eventFactory;
        this.isOutbound = isOutbound;
        try {
            File replicationQueueDirectory = applicationDirectories.getWorkDirectory((String)Preconditions.checkNotNull((Object)queuePath));
            this.queue = new FileObjectQueue(new File(replicationQueueDirectory, identifier), (FileObjectQueue.Converter)new BlobEventConverter());
            this.inUse = new FileObjectQueue(new File(replicationQueueDirectory, String.valueOf(identifier) + IN_USE_SUFFIX), (FileObjectQueue.Converter)new BlobEventConverter());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public synchronized void push(BlobEvent blobEvent) {
        if (blobEvent.isInUse()) {
            this.inUse.add((Object)blobEvent);
        } else {
            this.queue.add((Object)blobEvent);
        }
        if (this.eventFactory != null) {
            this.eventManager.post(this.eventFactory.apply(this.identifier));
        }
        this.eventManager.post((Object)new ReplicationQueueSizeChangeEvent(this.isOutbound, this.size()));
    }

    @Override
    public void maybeNotify() {
        if (this.eventFactory != null && this.queue.size() > 0) {
            this.eventManager.post(this.eventFactory.apply(this.identifier));
        }
    }

    @Override
    @Nullable
    public synchronized BlobEvent takeNext() {
        BlobEvent blobEvent = (BlobEvent)this.queue.peek();
        if (blobEvent != null) {
            this.inUse.add((Object)blobEvent.withInUse(true));
            this.queue.remove();
            return blobEvent;
        }
        return null;
    }

    @Override
    public synchronized List<BlobEvent> takeNextBatch() {
        ArrayList<BlobEvent> batch = new ArrayList<BlobEvent>(this.maxBatchSize);
        int i = 0;
        while (i < this.maxBatchSize) {
            BlobEvent e = this.takeNext();
            if (e == null) break;
            batch.add(e);
            ++i;
        }
        return batch;
    }

    @Override
    public synchronized void clearInUse() {
        while (this.inUse.size() > 0) {
            BlobEvent blobEvent = (BlobEvent)this.inUse.peek();
            this.inUse.remove();
            this.queue.add((Object)blobEvent.withInUse(false));
        }
    }

    @Override
    public synchronized void removeInUse() {
        int replicatedCount = this.inUse.size();
        while (this.inUse.size() > 0) {
            this.inUse.remove();
        }
        if (this.isOutbound) {
            this.eventManager.post((Object)new ReplicationQueueBlobReplicatedEvent(replicatedCount));
        }
    }

    @Override
    public int size() {
        return this.queue.size() + this.inUse.size();
    }

    @Override
    public void close() {
        this.queue.close();
        this.inUse.close();
    }

    @Override
    public synchronized void removeAll() {
        while (this.queue.size() > 0) {
            this.queue.remove();
        }
        while (this.inUse.size() > 0) {
            this.inUse.remove();
        }
    }

    private static class BlobEventConverter
    implements FileObjectQueue.Converter<BlobEvent> {
        private BlobEventConverter() {
        }

        public BlobEvent from(byte[] bytes) throws IOException {
            Throwable throwable = null;
            Object var3_4 = null;
            try (DataInputStream input = new DataInputStream(new ByteArrayInputStream(bytes));){
                return new BlobEvent().withBlobId(input.readUTF()).withAssetPath(this.handleReadMaybeNull(input.readUTF())).withBlobEventType(BlobEventType.values()[input.readInt()]).withInUse(input.readBoolean()).withRetryCount(input.readInt()).withReplicationConnectionId(this.handleReadMaybeNull(input.readUTF())).withRepositoryName(input.readBoolean() ? input.readUTF() : null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        public void toStream(BlobEvent blobEvent, OutputStream outputStream) throws IOException {
            Throwable throwable = null;
            Object var4_5 = null;
            try (DataOutputStream output = new DataOutputStream(outputStream);){
                output.writeUTF(blobEvent.getBlobId());
                output.writeUTF(this.handleWriteMaybeNull(blobEvent.getAssetPath()));
                output.writeInt(blobEvent.getBlobEventType().ordinal());
                output.writeBoolean(blobEvent.isInUse());
                output.writeInt(blobEvent.getRetryCount());
                output.writeUTF(this.handleWriteMaybeNull(blobEvent.getReplicationConnectionId()));
                output.writeBoolean(blobEvent.getRepositoryName() != null);
                if (blobEvent.getRepositoryName() != null) {
                    output.writeUTF(blobEvent.getRepositoryName());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        private String handleWriteMaybeNull(String data) {
            if (data == null || data.isEmpty()) {
                return "";
            }
            return data;
        }

        private String handleReadMaybeNull(String data) {
            if (data == null || data.isEmpty()) {
                return null;
            }
            return data;
        }
    }
}

