/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.replication.FileListingWatcher;
import com.sonatype.nexus.replication.ReplicationConnectionManager;
import com.sonatype.nexus.replication.ReplicationQueueManager;
import com.sonatype.nexus.replication.db.model.ReplicationConnection;
import com.sonatype.nexus.replication.internal.FileListingFilter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.BlobIdLocationResolver;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.replication.BlobEvent;

@Singleton
@Named
@FeatureFlag(name="nexus.replication.v1.enabled")
public class FileListingGenerator
extends ComponentSupport {
    private final BlobIdLocationResolver blobIdLocationResolver;
    private final BlobStoreManager blobStoreManager;
    private final ReplicationQueueManager replicationQueueManager;
    private final ReplicationConnectionManager replicationConnectionManager;
    private final RepositoryManager repositoryManager;
    private final FileListingFilter fileListingFilter;

    @Inject
    public FileListingGenerator(BlobIdLocationResolver blobIdLocationResolver, BlobStoreManager blobStoreManager, ReplicationQueueManager replicationQueueManager, ReplicationConnectionManager replicationConnectionManager, RepositoryManager repositoryManager, FileListingFilter fileListingFilter) {
        this.blobIdLocationResolver = (BlobIdLocationResolver)Preconditions.checkNotNull((Object)blobIdLocationResolver);
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.replicationQueueManager = (ReplicationQueueManager)Preconditions.checkNotNull((Object)replicationQueueManager);
        this.replicationConnectionManager = (ReplicationConnectionManager)Preconditions.checkNotNull((Object)replicationConnectionManager);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.fileListingFilter = (FileListingFilter)Preconditions.checkNotNull((Object)fileListingFilter);
    }

    public void writeFile(String replicationConnectionId) {
        ReplicationConnection replicationConnection = this.replicationConnectionManager.getById(replicationConnectionId).orElse(null);
        if (replicationConnection == null) {
            this.log.warn("replicationConnectionId {} not found, so not generating file listing", (Object)replicationConnectionId);
            return;
        }
        Repository repository = this.repositoryManager.get(replicationConnection.getSourceRepositoryName());
        if (repository == null) {
            this.log.debug("Source repository {} not found, so not generating file listing", (Object)replicationConnection.getSourceRepositoryName());
            return;
        }
        String blobStoreName = (String)repository.getConfiguration().attributes("storage").get("blobStoreName");
        BlobStore blobStore = this.blobStoreManager.get(blobStoreName);
        if (blobStore == null) {
            this.log.debug("blobstore {} not found, so not generating file listing", (Object)blobStoreName);
            return;
        }
        if (blobStore.getRawObjectAccess().hasRawObject(FileListingWatcher.getFileListingPath(replicationConnection.getName(), replicationConnection.getDestinationRepositoryName()))) {
            this.log.trace("File listing already exists for replicationConnection {}, skipping processing.", (Object)replicationConnection.getName());
            this.replicationQueueManager.maybeStartWatching(replicationConnectionId);
            return;
        }
        this.maybeGenerate(replicationConnection, blobStore);
    }

    private void maybeGenerate(ReplicationConnection replicationConnection, BlobStore blobStore) {
        List<BlobEvent> blobEvents;
        if (this.log.isDebugEnabled()) {
            this.log.debug("connection {} queue size: {}", (Object)replicationConnection.getId(), (Object)this.replicationQueueManager.size(replicationConnection.getId()));
        }
        if (!(blobEvents = this.replicationQueueManager.takeNextBatch(replicationConnection.getId()).stream().filter(this.fileListingFilter).collect(Collectors.toList())).isEmpty()) {
            this.log.debug("Generating filelisting for replicationConnection {}", (Object)replicationConnection.getName());
            if (this.doGenerate(replicationConnection, blobStore, blobEvents)) {
                this.replicationQueueManager.removeInUse(replicationConnection.getId());
            } else {
                this.replicationQueueManager.clearInUse(replicationConnection.getId());
            }
        } else {
            this.log.debug("No events queued for replicationConnection {} not generating file listing.", (Object)replicationConnection.getName());
        }
    }

    private boolean doGenerate(ReplicationConnection replicationConnection, BlobStore blobStore, List<BlobEvent> events) {
        StringBuilder filelisting = new StringBuilder();
        for (BlobEvent event : events) {
            Path path = Paths.get(this.blobIdLocationResolver.getLocation(new BlobId(event.getBlobId())), new String[0]);
            String basePath = path.toString().replace("\\", "/");
            filelisting.append(event.getBlobEventType()).append(" ").append(basePath).append(".bytes").append(System.lineSeparator());
            filelisting.append(event.getBlobEventType()).append(" ").append(basePath).append(".properties").append(System.lineSeparator());
        }
        Path fileListingPath = FileListingWatcher.getFileListingPath(replicationConnection.getName(), replicationConnection.getDestinationRepositoryName());
        try {
            blobStore.getRawObjectAccess().putRawObject(fileListingPath, (InputStream)new ByteArrayInputStream(filelisting.toString().getBytes(StandardCharsets.UTF_8)));
            this.log.debug("Successfully stored generated filelisting {} for replicationConnection {}", (Object)fileListingPath, (Object)replicationConnection.getName());
            return true;
        }
        catch (Exception e) {
            this.log.debug("Failed to store generated filelisting for replicationConnection {}, will remove any partial file content.", (Object)replicationConnection.getName(), (Object)e);
            try {
                blobStore.getRawObjectAccess().deleteRawObject(fileListingPath);
            }
            catch (Exception e1) {
                this.log.warn("Failed to delete filelisting for replicationConnection {}", (Object)replicationConnection.getName(), (Object)e1);
            }
            return false;
        }
    }
}

