/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.replication.ReplicationConnectionManager;
import com.sonatype.nexus.replication.db.model.ReplicationConnection;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.cache.Cache;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.AccessedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.cache.CacheHelper;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.repository.replication.BlobEvent;

@Named
@Singleton
@FeatureFlag(name="nexus.replication.v1.enabled")
public class FileListingFilter
implements Predicate<BlobEvent> {
    public static final String CACHE_NAME = "REPLICATION_FILE_LISTING_PATTERN_CACHE";
    private final ReplicationConnectionManager replicationConnectionManager;
    private final CacheHelper cacheHelper;
    private Cache<String, Pattern> patternCache;

    @Inject
    public FileListingFilter(ReplicationConnectionManager replicationConnectionManager, CacheHelper cacheHelper) {
        this.replicationConnectionManager = (ReplicationConnectionManager)Preconditions.checkNotNull((Object)replicationConnectionManager);
        this.cacheHelper = (CacheHelper)Preconditions.checkNotNull((Object)cacheHelper);
    }

    @Override
    public boolean test(BlobEvent blobEvent) {
        ReplicationConnection replicationConnection = this.replicationConnectionManager.getById(blobEvent.getReplicationConnectionId()).orElse(null);
        if (replicationConnection == null) {
            return false;
        }
        List<String> regexes = replicationConnection.getContentRegexes();
        if (regexes == null || regexes.isEmpty()) {
            return true;
        }
        this.maybeCreatePatternCache();
        return regexes.stream().anyMatch(regex -> this.filterBlobEventWithRegex(blobEvent, (String)regex));
    }

    private boolean filterBlobEventWithRegex(BlobEvent blobEvent, String regex) {
        Pattern pattern = (Pattern)this.patternCache.get((Object)regex);
        if (pattern != null) {
            return pattern.matcher(blobEvent.getAssetPath()).matches();
        }
        pattern = Pattern.compile(regex);
        this.patternCache.put((Object)regex, (Object)pattern);
        return pattern.matcher(blobEvent.getAssetPath()).matches();
    }

    private void maybeCreatePatternCache() {
        if (this.patternCache == null) {
            MutableConfiguration config = new MutableConfiguration().setStoreByValue(false).setExpiryPolicyFactory(AccessedExpiryPolicy.factoryOf((Duration)Duration.FIVE_MINUTES)).setManagementEnabled(true).setStatisticsEnabled(true);
            this.patternCache = this.cacheHelper.maybeCreateCache(CACHE_NAME, config);
        }
    }
}

