/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.db.orient.upgrade;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.upgrade.DependsOn;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;
import org.sonatype.nexus.orient.OClassNameBuilder;

@Named
@Singleton
@DependsOn(model="config", version="1.9", checkpoint=true)
@Upgrades(model="replication_connection", from="1.0", to="1.1")
public class ReplicationDatabaseUpgrade_1_1
extends DatabaseUpgradeSupport {
    private static final String P_USE_TRUST_STORE = "use_trust_store";
    private static final String REPLICATION_CONNECTION = new OClassNameBuilder().type("replication_connection").build();
    private Provider<DatabaseInstance> componentDatabaseInstance;

    @Inject
    public ReplicationDatabaseUpgrade_1_1(@Named(value="config") @Named(value="config") Provider<DatabaseInstance> componentDatabaseInstance) {
        this.componentDatabaseInstance = (Provider)Preconditions.checkNotNull(componentDatabaseInstance);
    }

    public void apply() throws Exception {
        ReplicationDatabaseUpgrade_1_1.withDatabaseAndClass(this.componentDatabaseInstance, (String)REPLICATION_CONNECTION, (db, table) -> {
            if (!table.existsProperty(P_USE_TRUST_STORE)) {
                table.createProperty(P_USE_TRUST_STORE, OType.BOOLEAN);
                db.command((OCommandRequest)new OCommandSQL("UPDATE replication_connection SET use_trust_store = false")).execute(new Object[0]);
            }
        });
    }
}

