/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.db.datastore.upgrade;

import java.sql.Connection;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.upgrade.datastore.RepeatableDatabaseMigrationStep;

@Named
@Singleton
@FeatureFlag(name="nexus.replication.v1.enabled")
public class ReplicationUseTrustStoreDatabaseMigrationStep
extends RepeatableDatabaseMigrationStep {
    private static String REPLICATION = "replication_connection";

    public void migrate(Connection connection) throws Exception {
        if (!this.tableExists(connection, REPLICATION)) {
            this.log.warn("Table replication_connection doesn't exist, upgrade step {} will be skipped", (Object)((Object)((Object)this)).getClass().getSimpleName());
            return;
        }
        this.log.info("Adding use_trust_store column to replication_connection table");
        this.runStatement(connection, "ALTER TABLE replication_connection ADD COLUMN IF NOT EXISTS use_trust_store BOOLEAN NOT NULL DEFAULT FALSE");
    }

    public Integer getChecksum() {
        return 1;
    }
}

