/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.replication.ReplicationEnableException;
import com.sonatype.nexus.replication.TargetInstanceConnector;
import com.sonatype.nexus.replication.db.model.ReplicationConnection;
import com.sonatype.nexus.replication.internal.TaskValidationUtil;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.api.BlobStoreLocator;
import org.sonatype.nexus.blobstore.api.RepositoryDoesNotExistException;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.replication.ReplicationBlobStoreStatusManager;
import org.sonatype.nexus.rest.ValidationErrorsException;
import org.sonatype.nexus.rest.WebApplicationMessageException;

@Named
@Singleton
public class ReplicationConnectionValidator
extends ComponentSupport {
    public static final String REPOSITORY_FORMAT_PATH = "service/rest/internal/ui/replication/repository-format";
    private static final String SOURCE_REPOSITORY_FIELD = "sourceRepositoryName";
    private final RepositoryManager repositoryManager;
    private final BlobStoreLocator blobStoreLocator;
    private final ReplicationBlobStoreStatusManager replicationBlobStoreStatusManager;
    private final TaskValidationUtil taskValidationUtil;
    private final TargetInstanceConnector targetInstanceConnector;

    @Inject
    public ReplicationConnectionValidator(RepositoryManager repositoryManager, BlobStoreLocator blobStoreLocator, ReplicationBlobStoreStatusManager replicationBlobStoreStatusManager, TaskValidationUtil taskValidationUtil, TargetInstanceConnector targetInstanceConnector) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.blobStoreLocator = (BlobStoreLocator)Preconditions.checkNotNull((Object)blobStoreLocator);
        this.replicationBlobStoreStatusManager = (ReplicationBlobStoreStatusManager)Preconditions.checkNotNull((Object)replicationBlobStoreStatusManager);
        this.taskValidationUtil = (TaskValidationUtil)((Object)Preconditions.checkNotNull((Object)((Object)taskValidationUtil)));
        this.targetInstanceConnector = (TargetInstanceConnector)Preconditions.checkNotNull((Object)targetInstanceConnector);
    }

    public void validate(ReplicationConnection replicationConnection) {
        BlobStore blobStore = this.getSourceBlobStore(replicationConnection);
        this.ensureNotPartOfAGroupBlobStore(blobStore);
        this.ensureBlobStoreNotUpdatingAttributes(replicationConnection, blobStore);
        this.ensureRepositoriesShareFormat(replicationConnection);
        try {
            this.taskValidationUtil.ensureNoConflictingTasks(replicationConnection.getSourceRepositoryName());
        }
        catch (ReplicationEnableException e) {
            throw new ValidationErrorsException().withError(SOURCE_REPOSITORY_FIELD, e.getMessage());
        }
    }

    private BlobStore getSourceBlobStore(ReplicationConnection replicationConnection) {
        String sourceRepositoryName = replicationConnection.getSourceRepositoryName();
        try {
            return this.blobStoreLocator.getBlobStore(sourceRepositoryName);
        }
        catch (RepositoryDoesNotExistException repositoryDoesNotExistException) {
            throw new ValidationErrorsException().withError(SOURCE_REPOSITORY_FIELD, "repository " + sourceRepositoryName + " does not exist");
        }
    }

    private void ensureBlobStoreNotUpdatingAttributes(ReplicationConnection replicationConnection, BlobStore sourceBlobStore) {
        String sourceRepositoryName = replicationConnection.getSourceRepositoryName();
        BlobStoreConfiguration blobStoreConfiguration = sourceBlobStore.getBlobStoreConfiguration();
        if (this.replicationBlobStoreStatusManager.getReplicationStatus(blobStoreConfiguration) == ReplicationBlobStoreStatusManager.BlobStoreReplicationStatus.ATTRIBUTES_UPGRADING) {
            throw new ValidationErrorsException().withError(SOURCE_REPOSITORY_FIELD, "Replication cannot be enabled on repository " + sourceRepositoryName + " when blob store attributes are being backfilled");
        }
    }

    private void ensureNotPartOfAGroupBlobStore(BlobStore sourceBlobStore) {
        if (sourceBlobStore.getBlobStoreConfiguration().getType().equals("Group")) {
            throw new ValidationErrorsException().withError(SOURCE_REPOSITORY_FIELD, "You have selected a repository that is using a group blob store. Replication is not yet supported for repositories using group blob stores.");
        }
    }

    private void ensureRepositoriesShareFormat(ReplicationConnection replicationConnection) {
        String sourceRepositoryFormat = this.repositoryManager.get(replicationConnection.getSourceRepositoryName()).getFormat().toString();
        String targetRepositoryFormat = this.getTargetRepositoryFormat(replicationConnection);
        if (!targetRepositoryFormat.equals(sourceRepositoryFormat)) {
            throw new ValidationErrorsException().withError(String.format("Source Repository %s with format %s should have the same format as the target repository %s with format %s", replicationConnection.getSourceRepositoryName(), sourceRepositoryFormat, replicationConnection.getDestinationRepositoryName(), targetRepositoryFormat));
        }
    }

    private String getTargetRepositoryFormat(ReplicationConnection replicationConnection) {
        URI host;
        URI base = host.resolve((host = URI.create(replicationConnection.getDestinationInstanceUrl())).getPath().endsWith("/") ? host.getPath() : String.valueOf(host.getPath()) + "/");
        String requestEndpoint = base.toString();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (CloseableHttpClient client = this.targetInstanceConnector.createHttpClient(replicationConnection.getDestinationInstanceUsername(), replicationConnection.getDestinationInstancePassword(), replicationConnection.isUseTrustStore());){
                HttpGet repositoryFormatRequest = new HttpGet(base.resolve("service/rest/internal/ui/replication/repository-format/?repositoryName=" + replicationConnection.getDestinationRepositoryName()));
                requestEndpoint = repositoryFormatRequest.toString();
                CloseableHttpResponse repositoryFormatResponse = client.execute((HttpUriRequest)repositoryFormatRequest);
                int statusCode = repositoryFormatResponse.getStatusLine().getStatusCode();
                if (statusCode == 200) {
                    return IOUtils.toString((InputStream)repositoryFormatResponse.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
                }
                this.log.debug("Obtaining repository format from host=\"{}\" with user=\"{}\" and repository=\"{}\" failed with status={}", new Object[]{host, replicationConnection.getDestinationInstanceUsername(), replicationConnection.getDestinationRepositoryName(), statusCode});
                throw new WebApplicationMessageException(Response.Status.fromStatusCode((int)statusCode), repositoryFormatResponse.getStatusLine().getReasonPhrase());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.log.error("Unable to validate format on target repository: {}", (Object)requestEndpoint, (Object)e);
            throw new WebApplicationMessageException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }
}

