/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.replication.internal.ReplicationChecks;
import com.sonatype.nexus.replication.internal.pull.SourceConnection;
import com.sonatype.nexus.replication.internal.pull.SourceInstanceConnector;
import com.sonatype.nexus.replication.rest.model.HttpPullRepositoryInfoXO;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.ConstraintViolation;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ApplicationVersion;
import org.sonatype.nexus.repository.Recipe;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.manager.ConfigurationValidator;
import org.sonatype.nexus.validation.ConstraintViolationFactory;

@Named
public class ReplicationConfigurationValidator
extends ComponentSupport
implements ConfigurationValidator {
    private final ConstraintViolationFactory constraintViolationFactory;
    private final SourceInstanceConnector sourceInstanceConnector;
    private final Map<String, Recipe> recipeMap;
    private final String applicationVersion;
    private final ReplicationChecks replicationChecks;
    private static final String REPLICATION_FIELD_ID = "attributes.replication.preemptivePullEnabled";
    private static final String REPLICATION_REMOTE_FIELD_ID = "attributes.proxy.remoteUrl";

    @Inject
    public ReplicationConfigurationValidator(ConstraintViolationFactory constraintViolationFactory, SourceInstanceConnector sourceInstanceConnector, ReplicationChecks replicationChecks, Map<String, Recipe> recipeMap, ApplicationVersion applicationVersion) {
        this.constraintViolationFactory = (ConstraintViolationFactory)Preconditions.checkNotNull((Object)constraintViolationFactory);
        this.sourceInstanceConnector = (SourceInstanceConnector)((Object)Preconditions.checkNotNull((Object)((Object)sourceInstanceConnector)));
        this.replicationChecks = (ReplicationChecks)((Object)Preconditions.checkNotNull((Object)((Object)replicationChecks)));
        this.recipeMap = (Map)Preconditions.checkNotNull(recipeMap);
        this.applicationVersion = ((ApplicationVersion)Preconditions.checkNotNull((Object)applicationVersion)).getVersion();
    }

    @Nullable
    public ConstraintViolation<?> validate(Configuration configuration) {
        Map replicationAttributes;
        if (configuration == null) {
            return null;
        }
        Map attributes = configuration.getAttributes();
        if (attributes == null) {
            return null;
        }
        Map proxyAttributes = (Map)attributes.get("proxy");
        if (proxyAttributes != null && proxyAttributes.containsKey("remoteUrl") && (replicationAttributes = (Map)attributes.get("replication")) != null && Boolean.TRUE.equals(replicationAttributes.get("preemptivePullEnabled"))) {
            if (!this.replicationChecks.isHttpReplicationEnabled()) {
                return this.constraintViolationFactory.createViolation(REPLICATION_FIELD_ID, "Content Replication is not enabled");
            }
            if (!this.replicationChecks.isProVersion()) {
                return this.constraintViolationFactory.createViolation(REPLICATION_FIELD_ID, "Content Replication requires an appropriate license");
            }
            if (!this.replicationChecks.isPostgresql()) {
                return this.constraintViolationFactory.createViolation(REPLICATION_FIELD_ID, "Content Replication requires a PostgreSQL database");
            }
            String formatName = this.getFormatNameFromConfiguration(configuration);
            if (!this.replicationChecks.isFormatSupported(formatName)) {
                return this.constraintViolationFactory.createViolation(REPLICATION_FIELD_ID, String.format("Content Replication is not supported for %s", formatName));
            }
            return this.validateReplication(configuration, (String)proxyAttributes.get("remoteUrl"));
        }
        return null;
    }

    @VisibleForTesting
    ConstraintViolation<?> validateReplication(Configuration configuration, String remoteUrl) {
        Optional<SourceConnection> connection = SourceConnection.from(configuration);
        if (connection.isPresent()) {
            Optional<HttpPullRepositoryInfoXO> info = this.sourceInstanceConnector.validateSuitableRemote(connection.get());
            if (info.isPresent()) {
                return this.validateRemoteInformation(info.get(), configuration, remoteUrl);
            }
            this.log.debug("Remote endpoint for content replication did not respond with Nexus expectations: {}", (Object)remoteUrl);
        } else {
            this.log.debug("Configuration for content replication did not provide a valid source connection");
        }
        return this.constraintViolationFactory.createViolation(REPLICATION_REMOTE_FIELD_ID, String.format("The Remote endpoint %s does not appear to be a Nexus Repository", remoteUrl));
    }

    private ConstraintViolation<?> validateRemoteInformation(HttpPullRepositoryInfoXO repositoryInfo, Configuration configuration, String remoteUrl) {
        if (!repositoryInfo.getReplicationEnabled()) {
            return this.constraintViolationFactory.createViolation(REPLICATION_REMOTE_FIELD_ID, String.format("The Remote endpoint %s does not support content replication", remoteUrl));
        }
        if (!this.applicationVersion.equals(repositoryInfo.getApplicationVersion())) {
            return this.constraintViolationFactory.createViolation(REPLICATION_REMOTE_FIELD_ID, String.format("The Remote endpoint %s is using a different version. local: %s, remote: %s", remoteUrl, this.applicationVersion, repositoryInfo.getApplicationVersion()));
        }
        if (repositoryInfo.getFormatName() == null || !repositoryInfo.getFormatName().equals(this.getFormatNameFromConfiguration(configuration))) {
            return this.constraintViolationFactory.createViolation(REPLICATION_REMOTE_FIELD_ID, String.format("The Remote endpoint %s is a different format: %s", remoteUrl, repositoryInfo.getFormatName()));
        }
        if (!repositoryInfo.isHostedRepository()) {
            return this.constraintViolationFactory.createViolation(REPLICATION_REMOTE_FIELD_ID, String.format("The Remote endpoint %s is not a hosted repository", remoteUrl));
        }
        if (repositoryInfo.getFormatName().equals("docker") && repositoryInfo.isGroupWriteMember()) {
            return this.constraintViolationFactory.createViolation(REPLICATION_REMOTE_FIELD_ID, String.format("The Remote endpoint %s is a Docker Group Writable Repository, which is not supported", remoteUrl));
        }
        return null;
    }

    @VisibleForTesting
    String getFormatNameFromConfiguration(Configuration configuration) {
        String recipeName = configuration.getRecipeName();
        if (recipeName == null) {
            return null;
        }
        Recipe recipe = this.recipeMap.get(recipeName);
        if (recipe == null) {
            return null;
        }
        return recipe.getFormat().getValue();
    }
}

