/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.blobstore.group.GroupConvertValidator;
import com.sonatype.nexus.replication.ReplicationConnectionManager;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.api.BlobStoreException;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.repository.manager.RepositoryManager;

@Singleton
@Named
@FeatureFlag(name="nexus.replication.v1.enabled")
public class ConvertGroupReplicationValidator
extends ComponentSupport
implements GroupConvertValidator {
    public static final String REPLICATION_KEY = "replication";
    public static final String ENABLED_KEY = "enabled";
    private final ReplicationConnectionManager replicationConnectionManager;
    private final RepositoryManager repositoryManager;

    @Inject
    public ConvertGroupReplicationValidator(ReplicationConnectionManager replicationConnectionManager, RepositoryManager repositoryManager) {
        this.replicationConnectionManager = (ReplicationConnectionManager)Preconditions.checkNotNull((Object)replicationConnectionManager);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
    }

    public void validate(BlobStoreConfiguration blobStoreConfiguration) {
        List repositoryNames = StreamSupport.stream(this.repositoryManager.browseForBlobStore(blobStoreConfiguration.getName()).spliterator(), false).map(repo -> repo.getName()).collect(Collectors.toList());
        List reposAsReplicationSources = this.replicationConnectionManager.list().stream().filter(connection -> repositoryNames.contains(connection.getSourceRepositoryName())).map(repCon -> repCon.getSourceRepositoryName()).collect(Collectors.toList());
        List reposAsReplicationTargets = repositoryNames.stream().filter(repoName -> (Boolean)this.repositoryManager.get(repoName).getConfiguration().attributes(REPLICATION_KEY).get(ENABLED_KEY, Boolean.class, (Object)false)).collect(Collectors.toList());
        if (!reposAsReplicationSources.isEmpty()) {
            String validationError = "The blob store cannot be converted as it has repositories configured as sources in replication connections: " + String.join((CharSequence)",", reposAsReplicationSources);
            this.log.error(validationError);
            throw new BlobStoreException(validationError, null, null);
        }
        if (!reposAsReplicationTargets.isEmpty()) {
            String validationError = "The blob store cannot be converted as it has repositories configured as targets in replication connections: " + String.join((CharSequence)",", reposAsReplicationTargets);
            this.log.error(validationError);
            throw new BlobStoreException(validationError, null, null);
        }
    }
}

