/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.tasks;

import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.upgrade.AvailabilityVersion;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.formfields.NumberTextFormField;
import org.sonatype.nexus.formfields.RepositoryCombobox;
import org.sonatype.nexus.repository.docker.DockerGCFacet;
import org.sonatype.nexus.repository.docker.tasks.DockerGCCustomTask;
import org.sonatype.nexus.scheduling.TaskDescriptorSupport;

@AvailabilityVersion(from="1.0")
@Named
@Singleton
@FeatureFlag(name="nexus.docker.gc.custom.enabled")
public class DockerGCCustomTaskDescriptor
extends TaskDescriptorSupport {
    public static final String TYPE_ID = "repository.docker.gc.custom";
    public static final String DEPLOY_OFFSET = "deployOffset";
    public static final Number DEPLOY_OFFSET_INIT_VALUE = 24;
    public static final Number DEPLOY_OFFSET_MIN_VALUE = 0;
    private static final Messages messages = (Messages)I18N.create(Messages.class);

    public DockerGCCustomTaskDescriptor() {
        super(TYPE_ID, DockerGCCustomTask.class, messages.name(), true, true, new FormField[]{new RepositoryCombobox("repositoryName", messages.repositoryLabel(), messages.repositoryHelpText(), true).includingAnyOfFacets(new Class[]{DockerGCFacet.class}).includeAnEntryForAllRepositories(), new NumberTextFormField(DEPLOY_OFFSET, "Deploy offset in hours", "Manifests and images deployed within this period before the task starts will not be deleted", true).withInitialValue(DEPLOY_OFFSET_INIT_VALUE).withMinimumValue(DEPLOY_OFFSET_MIN_VALUE)});
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Docker - Delete unused manifests and images (Skip cross-layers repository usage check)")
        public String name();

        @MessageBundle.DefaultMessage(value="Repository")
        public String repositoryLabel();

        @MessageBundle.DefaultMessage(value="Select the Docker repository to clean up (Potential data loss if used incorrectly. Please contact support for any queries/concerns before to run)")
        public String repositoryHelpText();
    }
}

