/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.tasks;

import javax.inject.Named;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.RepositoryTaskSupport;
import org.sonatype.nexus.repository.docker.DockerGCFacet;
import org.sonatype.nexus.repository.docker.tasks.DockerGCCustomTaskDescriptor;
import org.sonatype.nexus.scheduling.Cancelable;

@Named
public class DockerGCCustomTask
extends RepositoryTaskSupport
implements Cancelable {
    public static final String TASK_DESCRIPTION = "Docker - Delete unused manifests and images (Skip cross-layers repository usage check)";
    private static final Messages messages = (Messages)I18N.create(Messages.class);

    public String getMessage() {
        return messages.message();
    }

    protected void execute(Repository repository) {
        ((DockerGCFacet)repository.facet(DockerGCFacet.class)).deleteUnusedManifestsAndImages(this.getConfiguration().getInteger("deployOffset", DockerGCCustomTaskDescriptor.DEPLOY_OFFSET_INIT_VALUE.intValue()), true);
    }

    protected boolean appliesTo(Repository repository) {
        return repository.optionalFacet(DockerGCFacet.class).isPresent();
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Docker - Delete unused manifests and images (Skip cross-layers repository usage check)")
        public String message();
    }
}

