/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.orient.repair;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.docker.internal.AssetKind;
import org.sonatype.nexus.repository.docker.internal.DockerDigest;
import org.sonatype.nexus.repository.docker.internal.DockerFacetUtils;
import org.sonatype.nexus.repository.docker.internal.orient.DockerFacetDatabaseUtils;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.repair.RepairMetadataComponent;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetEntityAdapter;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreMetadata;
import org.sonatype.nexus.repository.view.matchers.token.TokenParser;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Singleton
public class DockerRepairComponent
extends RepairMetadataComponent {
    private static final TokenParser tagParser = new TokenParser("v1/repositories/{id:.+}/tags/{tag}");
    private static final String ID = "id";
    private static final String TAG = "tag";

    @Inject
    public DockerRepairComponent(RepositoryManager repositoryManager, AssetEntityAdapter assetEntityAdapter, @Named(value="hosted") @Named(value="hosted") Type type, @Named(value="docker") @Named(value="docker") Format format) {
        super(repositoryManager, assetEntityAdapter, type, format);
    }

    protected void updateAsset(Repository repository, StorageTx tx, Asset asset) {
        if (this.type.equals((Object)repository.getType()) && this.isRootLayer(asset)) {
            this.repairLayerMetadata(repository, asset, new ArrayList<String>());
        }
    }

    private boolean isRootLayer(Asset asset) {
        String assetKind = (String)asset.formatAttributes().get("asset_kind", String.class);
        return AssetKind.LAYER_METADATA.name().equals(assetKind) && asset.formatAttributes().get("parent", String.class) == null;
    }

    @TransactionalStoreMetadata
    protected void repairLayerMetadata(Repository repository, Asset asset, List<String> children) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        children.add(0, (String)asset.formatAttributes().get("layerId", String.class));
        asset.formatAttributes().set("ancestry", children);
        Map<String, Object> layerMetadata = this.doReadLayerMetadata(repository, asset);
        asset.formatAttributes().set("arch", layerMetadata.get("os"));
        asset.formatAttributes().set("os", layerMetadata.get("architecture"));
        this.populateXDockerAttributes(tx, asset, repository);
        tx.saveAsset(asset);
        this.findAssetsWithParentLayer(repository, children.get(0)).forEach(childAsset -> this.repairLayerMetadata(repository, (Asset)childAsset, (List<String>)new ArrayList<String>(children)));
    }

    private void populateXDockerAttributes(StorageTx tx, Asset metadataAsset, Repository repository) {
        String layerName = metadataAsset.name().replace("json", "layer");
        Asset layerAsset = DockerFacetDatabaseUtils.findAsset(tx, tx.findBucket(repository), layerName);
        if (layerAsset != null) {
            try {
                DockerDigest dockerDigest = DockerFacetDatabaseUtils.calculateChecksum(tx, metadataAsset, layerAsset);
                metadataAsset.formatAttributes().set("X-Docker-Size", (Object)layerAsset.size());
                metadataAsset.formatAttributes().set("X-Docker-Checksum-Payload", (Object)dockerDigest.toString());
            }
            catch (IOException e) {
                this.log.warn("Unable to calculate checksum for {} in {} repository", new Object[]{metadataAsset.name(), repository.getName(), e});
            }
        } else {
            this.log.warn("Unable to find layer asset that corresponds to {}", (Object)metadataAsset.name());
        }
    }

    private Iterable<Asset> findAssetsWithParentLayer(Repository repository, String layerId) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Query query = Query.builder().where("attributes.docker.parent").eq((Object)layerId).build();
        return tx.browseAssets(query, tx.findBucket(repository));
    }

    private Map<String, Object> doReadLayerMetadata(Repository repository, Asset asset) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        try {
            return DockerFacetUtils.readLayerMetadata(() -> ((Blob)tx.getBlob(asset.blobRef())).getInputStream());
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Unable to read layer metadata for %s in repository %s", asset.name(), repository.getName()), e);
        }
    }

    protected void afterRepair(Repository repository) {
        this.doRepairRepositoryWith(repository, this::updateTagComponents);
    }

    @Nullable
    private String updateTagComponents(Repository repository, Iterable<Asset> assets) {
        String lastId = null;
        for (Asset asset : assets) {
            lastId = this.assetEntityAdapter.recordIdentity((Entity)asset).toString();
            this.maybeUpdateTag(repository, asset);
        }
        return lastId;
    }

    private void maybeUpdateTag(Repository repository, Asset asset) {
        if (this.type.equals((Object)repository.getType()) && this.isTagAsset(asset)) {
            this.repairComponentTag(repository, asset);
        }
    }

    private boolean isTagAsset(Asset asset) {
        String assetKind = (String)asset.formatAttributes().get("asset_kind", String.class);
        return AssetKind.TAG.name().equals(assetKind);
    }

    @TransactionalStoreMetadata
    protected void repairComponentTag(Repository repository, Asset asset) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        String layerId = (String)asset.formatAttributes().get("layerId", String.class);
        Asset metadataAsset = DockerFacetDatabaseUtils.findAsset(tx, tx.findBucket(repository), DockerFacetUtils.v1layerMetadataName(layerId));
        if (metadataAsset == null) {
            this.log.warn("Unable to find asset {}", (Object)DockerFacetUtils.v1layerMetadataName(layerId));
            return;
        }
        Map tokens = tagParser.parse(asset.name());
        if (tokens != null && tokens.containsKey(ID) && tokens.containsKey(TAG)) {
            String tag;
            String name = (String)tokens.get(ID);
            Component tagComponent = DockerFacetDatabaseUtils.findComponent(tx, repository, name, tag = (String)tokens.get(TAG));
            if (tagComponent == null) {
                this.log.error("Unable to find tag component {}:{}", (Object)name, (Object)tag);
                return;
            }
            tagComponent.formatAttributes().set("layerAncestry", metadataAsset.formatAttributes().get("ancestry"));
            tx.saveComponent(tagComponent);
        }
    }
}

