/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal.security;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.collections.CollectionUtils;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.sonatype.nexus.security.SecurityHelper;
import org.sonatype.nexus.security.anonymous.AnonymousHelper;
import org.sonatype.nexus.security.authc.apikey.ApiKeyStore;
import org.sonatype.nexus.security.token.BearerTokenManager;

@Named
@Singleton
public class DockerTokenManager
extends BearerTokenManager {
    private static final Set<String> SUPPORTED_REALMS = ImmutableSet.of((Object)"NexusAuthorizingRealm", (Object)"NexusAuthenticatingRealm", (Object)"Crowd", (Object)"LdapRealm", (Object)"SamlRealm");

    @Inject
    public DockerTokenManager(ApiKeyStore apiKeyStore, SecurityHelper securityHelper) {
        super(apiKeyStore, securityHelper, "DockerToken");
    }

    private String createAnonymousToken(PrincipalCollection principals) {
        if (!CollectionUtils.intersection((Collection)principals.getRealmNames(), SUPPORTED_REALMS).isEmpty()) {
            return super.createToken(principals);
        }
        return null;
    }

    @Nullable
    public String authenticate() {
        boolean authenticated;
        Subject subject = this.securityHelper.subject();
        boolean bl = authenticated = subject.getPrincipal() != null && subject.isAuthenticated();
        if (authenticated) {
            PrincipalCollection principals = subject.getPrincipals();
            return super.createToken(principals);
        }
        if (AnonymousHelper.isAnonymous((Subject)subject)) {
            PrincipalCollection principals = subject.getPrincipals();
            return this.createAnonymousToken(principals);
        }
        return null;
    }
}

