/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal.search.sql;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.Stream;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.search.sql.SearchCustomFieldContributor;
import org.sonatype.nexus.repository.search.sql.SearchRecord;

@Named(value="docker")
@Singleton
public class DockerSearchCustomFieldContributor
extends ComponentSupport
implements SearchCustomFieldContributor {
    public void populateSearchCustomFields(SearchRecord searchTableData, Asset asset) {
        this.log.debug("Populating search fields for {}", (Object)asset.path());
        asset.component().ifPresent(component -> this.getAttribute(component.attributes(), "layerAncestry", asset.path()).forEach(arg_0 -> ((SearchRecord)searchTableData).addFormatFieldValue1(arg_0)));
        this.getAttribute(asset.attributes(), "content_digest", asset.path()).forEach(arg_0 -> ((SearchRecord)searchTableData).addFormatFieldValue2(arg_0));
    }

    private Stream<String> getAttribute(NestedAttributesMap attr, String key, String path) {
        Object obj = attr.child("docker").get(key);
        if (obj instanceof String) {
            return Collections.singleton((String)obj).stream();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).stream().map(Object::toString);
        }
        this.log.debug("Unexpected type for docker.{}={} for path {}", new Object[]{key, obj, path});
        return Collections.emptyList().stream();
    }
}

