/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal.search.elasticsearch;

import java.util.function.Consumer;
import javax.inject.Named;
import javax.inject.Singleton;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.sonatype.nexus.repository.search.query.DefaultElasticSearchContribution;

@Named(value="attributes.docker.imageName")
@Singleton
public class DockerImageNameElasticSearchContribution
extends DefaultElasticSearchContribution {
    public void contribute(Consumer<QueryBuilder> query, String type, String value) {
        if (value != null) {
            if (value.contains("/")) {
                super.contribute(query, type, value);
                return;
            }
            QueryStringQueryBuilder exact = QueryBuilders.queryStringQuery((String)this.escape(value)).field(type).lowercaseExpandedTerms(false);
            QueryStringQueryBuilder libraryPrefix = QueryBuilders.queryStringQuery((String)this.escape("library/" + value)).field(type).lowercaseExpandedTerms(false);
            query.accept((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)exact).should((QueryBuilder)libraryPrefix));
        }
    }
}

