/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal.orient.upgrade;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.upgrade.Dependencies;
import org.sonatype.nexus.common.upgrade.DependsOn;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;
import org.sonatype.nexus.orient.OIndexNameBuilder;

@Named
@Singleton
@Upgrades(model="docker", from="1.0", to="1.1")
@Dependencies(value={@DependsOn(model="component", version="1.15", checkpoint=true), @DependsOn(model="config", version="1.9")})
public class DockerUpgrade_1_1
extends DatabaseUpgradeSupport {
    private Provider<DatabaseInstance> configDatabaseInstance;
    private final Provider<DatabaseInstance> componentDatabaseInstance;
    private static final String P_REPOSITORY_NAME = "repository_name";
    private static final String I_REPOSITORY_NAME = new OIndexNameBuilder().type("bucket").property("repository_name").build();
    private static final String SELECT_DOCKER_HOSTED_REPOSITORIES = "select from repository where recipe_name in ['docker-hosted']";
    private static final String UPDATE_ASSET_KIND = "update asset set attributes.docker.asset_kind='BLOB' where bucket=?  and name like '%blobs/sha256:a3ed95caeb02ffe68cdd9fd84406680ae93d633cb16422d00e8a7c22955b46d4' and attributes.docker.asset_kind='MANIFEST'";

    @Inject
    public DockerUpgrade_1_1(@Named(value="config") @Named(value="config") Provider<DatabaseInstance> configDatabaseInstance, @Named(value="component") @Named(value="component") Provider<DatabaseInstance> componentDatabaseInstance) {
        this.configDatabaseInstance = configDatabaseInstance;
        this.componentDatabaseInstance = (Provider)Preconditions.checkNotNull(componentDatabaseInstance);
    }

    public void apply() throws Exception {
        List<String> dockerRepositoryNames = this.getDockerHostedRepositoryNames();
        if (!dockerRepositoryNames.isEmpty()) {
            OCommandSQL updateAssetCommand = new OCommandSQL(UPDATE_ASSET_KIND);
            Throwable throwable = null;
            Object var4_5 = null;
            try (ODatabaseDocumentTx db = ((DatabaseInstance)this.componentDatabaseInstance.get()).connect();){
                OIndex bucketIdx = db.getMetadata().getIndexManager().getIndex(I_REPOSITORY_NAME);
                dockerRepositoryNames.forEach(repositoryName -> {
                    this.log.info("Scanning docker repository, {}, for misconfigured assets", repositoryName);
                    OIdentifiable bucket = (OIdentifiable)bucketIdx.get(repositoryName);
                    if (bucket == null) {
                        this.log.warn("Unable to find bucket for {}", repositoryName);
                    } else {
                        int updates = (Integer)db.command((OCommandRequest)updateAssetCommand).execute(new Object[]{bucket.getIdentity()});
                        if (updates > 0) {
                            this.log.info("Updated {} misconfigured docker asset(s) in repository {}: set attributes.docker.asset_kind='BLOB'", (Object)updates, repositoryName);
                        }
                    }
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private List<String> getDockerHostedRepositoryNames() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.configDatabaseInstance.get()).connect();){
            return db.query((OQuery)new OSQLSynchQuery(SELECT_DOCKER_HOSTED_REPOSITORIES), new Object[0]).stream().map(d -> (String)d.field(P_REPOSITORY_NAME)).collect(Collectors.toList());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

