/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal.orient;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Preconditions;
import com.google.common.io.CharStreams;
import groovy.json.JsonOutput;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.SoftReference;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.http.ParseException;
import org.apache.http.entity.ContentType;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.joda.time.DateTime;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.docker.internal.AssetKind;
import org.sonatype.nexus.repository.docker.internal.DockerDigest;
import org.sonatype.nexus.repository.docker.internal.DockerFacetUtils;
import org.sonatype.nexus.repository.docker.internal.MediaType;
import org.sonatype.nexus.repository.docker.internal.V2ContentTypes;
import org.sonatype.nexus.repository.docker.internal.V2Error;
import org.sonatype.nexus.repository.docker.internal.V2Exception;
import org.sonatype.nexus.repository.docker.internal.V2Manifest;
import org.sonatype.nexus.repository.docker.internal.V2ManifestConfig;
import org.sonatype.nexus.repository.docker.internal.V2ManifestConfigDowngrader;
import org.sonatype.nexus.repository.docker.internal.V2ManifestSchema1;
import org.sonatype.nexus.repository.docker.internal.V2ManifestSchema2;
import org.sonatype.nexus.repository.docker.internal.V2ManifestUtil;
import org.sonatype.nexus.repository.docker.internal.orient.DockerAssetSearch;
import org.sonatype.nexus.repository.docker.internal.orient.DockerFacetDatabaseUtils;
import org.sonatype.nexus.repository.http.HttpStatus;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetEntityAdapter;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.ContentTypes;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class V2ManifestUtilImpl
extends ComponentSupport
implements V2ManifestUtil,
GroovyObject {
    private static final byte[] EMPTY_BLOB_BYTES;
    private static final String SIGNATURE_BLOCK = "(?s),\\s*\"signatures\".*]";
    private static final ObjectMapper MAPPER;
    @Inject
    private V2ManifestConfigDowngrader v2ManifestConfigDowngrader;
    @Inject
    private DockerAssetSearch dockerAssetSearch;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public V2ManifestUtilImpl() {
        MetaClass metaClass;
        CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    static {
        byte[] byArray = (byte[])ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{31, 139, 8, 0, 0, 9, 110, 136, 0, 255, 98, 24, 5, 163, 96, 20, 140, 88, 0, 8, 0, 0, 255, 255, 46, 175, 181, 239, 0, 4, 0, 0}), byte[].class);
        EMPTY_BLOB_BYTES = byArray;
        Object object = V2ManifestUtilImpl.$getCallSiteArray()[0].callConstructor(ObjectMapper.class);
        MAPPER = (ObjectMapper)ScriptBytecodeAdapter.castToType((Object)object, ObjectMapper.class);
        V2ManifestUtilImpl.$getCallSiteArray()[1].call((Object)MAPPER, V2ManifestUtilImpl.$getCallSiteArray()[2].callGetProperty(SerializationFeature.class));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public V2Manifest readManifest(InputStreamSupplier manifestContent, String name, @Nullable String contentType) throws IOException {
        block11: {
            block9: {
                block10: {
                    var4_4 = V2ManifestUtilImpl.$getCallSiteArray();
                    var4_4[3].callStatic(Preconditions.class, (Object)manifestContent);
                    var4_4[4].callStatic(Preconditions.class, (Object)name);
                    var5_5 = contentType;
                    var4_4[5].call(var4_4[6].callGroovyObjectGetProperty((Object)this), (Object)"Parsing manifest {} of type {}", (Object)name, (Object)(DefaultTypeTransformation.booleanUnbox((Object)var5_5) != false ? var5_5 : "unspecified"));
                    manifest = (Map)ScriptBytecodeAdapter.castToType((Object)var4_4[7].call(var4_4[8].call((Object)manifestContent), (Object)new _readManifest_closure1(this, this)), Map.class);
                    schemaVersion = var4_4[9].call((Object)manifest, (Object)"schemaVersion");
                    v2Manifest = null;
                    if (!ScriptBytecodeAdapter.compareEqual((Object)var4_4[10].callGetProperty(V2Manifest.class), (Object)schemaVersion)) break block10;
                    if (DefaultTypeTransformation.booleanUnbox((Object)var4_4[11].call((Object)manifest, (Object)"signatures"))) {
                        var9_9 = var4_4[12].callConstructor(V2Manifest.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"schemaVersion", var4_4[13].callGetProperty(V2Manifest.SchemaVersion.class), "mediaType", var4_4[14].callGetProperty(V2ContentTypes.class), "manifest", manifest}));
                        v2Manifest = (V2Manifest)ScriptBytecodeAdapter.castToType((Object)var9_9, V2Manifest.class);
                    } else {
                        var10_10 = var4_4[15].callConstructor(V2Manifest.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"schemaVersion", var4_4[16].callGetProperty(V2Manifest.SchemaVersion.class), "mediaType", var4_4[17].callGetProperty(V2ContentTypes.class), "manifest", manifest}));
                        v2Manifest = (V2Manifest)ScriptBytecodeAdapter.castToType((Object)var10_10, V2Manifest.class);
                    }
                    ** GOTO lbl49
                }
                if (!ScriptBytecodeAdapter.compareEqual((Object)var4_4[18].callGetProperty(V2Manifest.class), (Object)schemaVersion)) ** GOTO lbl48
                if (!(DefaultTypeTransformation.booleanUnbox((Object)var4_4[19].call((Object)manifest, (Object)"mediaType")) != false && DefaultTypeTransformation.booleanUnbox((Object)var4_4[20].call(var4_4[21].callGetProperty(MediaType.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)var4_4[22].call((Object)manifest, (Object)"mediaType"), String.class)), String.class))) != false)) break block9;
                mediaType = ShortTypeHandling.castToString((Object)var4_4[23].callCurrent((GroovyObject)this, (Object)contentType, (Object)manifest, var4_4[24].callGetProperty(MediaType.class)));
                var12_12 = var4_4[25].callConstructor(V2Manifest.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"schemaVersion", var4_4[26].callGetProperty(V2Manifest.SchemaVersion.class), "mediaType", mediaType, "manifest", manifest, "layers", ScriptBytecodeAdapter.createList((Object[])new Object[0])}));
                v2Manifest = (V2Manifest)ScriptBytecodeAdapter.castToType((Object)var12_12, V2Manifest.class);
                var13_13 = v2Manifest;
                return var13_13;
            }
            mediaType = ShortTypeHandling.castToString((Object)var4_4[27].callCurrent((GroovyObject)this, (Object)contentType, (Object)manifest, var4_4[28].callGetProperty(MediaType.class)));
            var15_15 = var4_4[29].callConstructor(V2Manifest.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"schemaVersion", var4_4[30].callGetProperty(V2Manifest.SchemaVersion.class), "mediaType", mediaType, "manifest", manifest}));
            v2Manifest = (V2Manifest)ScriptBytecodeAdapter.castToType((Object)var15_15, V2Manifest.class);
            break block11;
lbl48:
            // 1 sources

            throw (Throwable)var4_4[31].callConstructor(V2Exception.ManifestInvalid.class, (Object)new GStringImpl(new Object[]{name, schemaVersion}, new String[]{"Invalid manifest ", ": unknown 'schemaVersion' ", ""}));
        }
        var16_16 = var4_4[32].call((Object)V2ManifestUtilImpl.MAPPER, var4_4[33].call((Object)V2ManifestUtilImpl.MAPPER, var4_4[34].call((Object)manifest, (Object)(ScriptBytecodeAdapter.compareEqual((Object)var4_4[35].callGetProperty(V2Manifest.class), (Object)schemaVersion) != false ? "fsLayers" : "layers"))), var4_4[36].callGetProperty(DockerFacetUtils.class));
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)var16_16, V2ManifestUtilImpl.class, (GroovyObject)v2Manifest, (String)"layers");
        var17_17 = v2Manifest;
        try {
            return var17_17;
        }
        catch (JsonProcessingException e) {
            var4_4[37].call(var4_4[38].callGroovyObjectGetProperty((Object)this), (Object)"Parsing manifest {} failed, due to processing exception", (Object)name, (Object)e);
            throw (Throwable)var4_4[39].callConstructor(V2Exception.ManifestInvalid.class, (Object)new GStringImpl(new Object[]{name, var4_4[40].call((Object)e)}, new String[]{"Corrupt manifest ", ": ", ""}));
        }
    }

    private String resolveMediaType(String contentType, Map<String, Object> manifest, MediaType mediaType) {
        String type;
        block6: {
            CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
            type = contentType;
            try {
                ContentType parsedType = (ContentType)ScriptBytecodeAdapter.castToType((Object)callSiteArray[41].call(ContentType.class, (Object)contentType), ContentType.class);
                if (!ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[42].callGetProperty((Object)parsedType), (Object)callSiteArray[43].callGetProperty(ContentTypes.class))) break block6;
                Object object = callSiteArray[44].callGetPropertySafe(manifest);
                String manifestMediaType = ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : callSiteArray[45].callGetPropertySafe(callSiteArray[46].callGetProperty(manifest))));
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[47].callSafe((Object)manifestMediaType, (Object)"application/vnd.docker"))) {
                    Object object2 = callSiteArray[48].callGetProperty((Object)mediaType);
                    type = ShortTypeHandling.castToString((Object)object2);
                    break block6;
                }
                Object object3 = callSiteArray[49].callGetProperty((Object)mediaType);
                type = ShortTypeHandling.castToString((Object)object3);
            }
            catch (ParseException e) {
                callSiteArray[50].call(callSiteArray[51].callGroovyObjectGetProperty((Object)this), (Object)"Invalid contentType {}", (Object)contentType);
            }
            catch (UnsupportedCharsetException e) {
                callSiteArray[52].call(callSiteArray[53].callGroovyObjectGetProperty((Object)this), (Object)"Invalid contentType {}", (Object)contentType);
            }
        }
        return type;
    }

    @Override
    @Transactional
    public Content mayDowngrade(Content manifestContent, String name, String tag, V2Manifest.SchemaVersion clientPreference, Repository repository) throws IOException {
        CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
        callSiteArray[54].call(callSiteArray[55].callGroovyObjectGetProperty((Object)this), (Object)"Downgrade manifest check on {}:{}", (Object)name, (Object)tag);
        V2Manifest manifest = (V2Manifest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[56].callCurrent((GroovyObject)this, (Object)manifestContent, (Object)name), V2Manifest.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[57].callStatic(V2ManifestUtilImpl.class, (Object)clientPreference, (Object)manifest))) {
            StorageTx tx = (StorageTx)ScriptBytecodeAdapter.castToType((Object)callSiteArray[58].call(UnitOfWork.class), StorageTx.class);
            callSiteArray[59].call(callSiteArray[60].callGroovyObjectGetProperty((Object)this), (Object)"Downgrading manifest on {}:{} based on client preference", (Object)name, (Object)tag);
            V2ManifestSchema2 schemaV2 = (V2ManifestSchema2)ScriptBytecodeAdapter.castToType((Object)callSiteArray[61].callConstructor(V2ManifestSchema2.class, callSiteArray[62].callGroovyObjectGetProperty((Object)manifest)), V2ManifestSchema2.class);
            Bucket bucket = (Bucket)ScriptBytecodeAdapter.castToType((Object)callSiteArray[63].call((Object)tx, (Object)repository), Bucket.class);
            V2ManifestConfig config = (V2ManifestConfig)ScriptBytecodeAdapter.castToType((Object)callSiteArray[64].callStatic(V2ManifestUtilImpl.class, (Object)tx, (Object)bucket, (Object)schemaV2), V2ManifestConfig.class);
            callSiteArray[65].callCurrent((GroovyObject)this, (Object)config, (Object)tx, (Object)bucket, callSiteArray[66].callGetProperty((Object)repository));
            V2ManifestSchema1 downgradedManifest = (V2ManifestSchema1)ScriptBytecodeAdapter.castToType((Object)callSiteArray[67].call((Object)this.v2ManifestConfigDowngrader, (Object)config, (Object)schemaV2, (Object)name, (Object)tag), V2ManifestSchema1.class);
            callSiteArray[68].call(callSiteArray[69].callGroovyObjectGetProperty((Object)this), (Object)"Downgraded manifest = {}", callSiteArray[70].call(JsonOutput.class, callSiteArray[71].call(JsonOutput.class, (Object)downgradedManifest)));
            Content content = (Content)ScriptBytecodeAdapter.castToType((Object)callSiteArray[72].callConstructor(Content.class, callSiteArray[73].callConstructor(BytesPayload.class, callSiteArray[74].call((Object)MAPPER, (Object)downgradedManifest), callSiteArray[75].callGetProperty(V2ContentTypes.class))), Content.class);
            callSiteArray[76].call(callSiteArray[77].callGetProperty((Object)content), CacheInfo.class, callSiteArray[78].callConstructor(CacheInfo.class, callSiteArray[79].call(DateTime.class), null));
            return content;
        }
        callSiteArray[80].call(callSiteArray[81].callGroovyObjectGetProperty((Object)this), (Object)"Downgrade not needed on {}:{}", (Object)name, (Object)tag);
        return manifestContent;
    }

    @Override
    public DockerDigest manifestDigest(InputStreamSupplier manifestContent) throws IOException {
        CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
        public final class _manifestDigest_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _manifestDigest_closure2(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _manifestDigest_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(InputStream inputStream) {
                CallSite[] callSiteArray = _manifestDigest_closure2.$getCallSiteArray();
                String manifest = ShortTypeHandling.castToString((Object)callSiteArray[0].call(CharStreams.class, callSiteArray[1].callConstructor(InputStreamReader.class, (Object)inputStream, callSiteArray[2].callGetProperty(StandardCharsets.class))));
                Object object = callSiteArray[3].call(callSiteArray[4].call((Object)manifest, callSiteArray[5].call(ScriptBytecodeAdapter.getField(_manifestDigest_closure2.class, V2ManifestUtilImpl.class, (String)"SIGNATURE_BLOCK"), (Object)"\n\n"), (Object)"\n"), ScriptBytecodeAdapter.getField(_manifestDigest_closure2.class, V2ManifestUtilImpl.class, (String)"SIGNATURE_BLOCK"), (Object)"");
                manifest = ShortTypeHandling.castToString((Object)object);
                return callSiteArray[6].callConstructor(DockerDigest.class, callSiteArray[7].call(callSiteArray[8].callGetProperty(DockerFacetUtils.class)), callSiteArray[9].call(callSiteArray[10].call(callSiteArray[11].call(callSiteArray[12].callGetProperty(DockerFacetUtils.class)), (Object)manifest, callSiteArray[13].callGetProperty(StandardCharsets.class))));
            }

            @Generated
            public Object call(InputStream inputStream) {
                CallSite[] callSiteArray = _manifestDigest_closure2.$getCallSiteArray();
                return callSiteArray[14].callCurrent((GroovyObject)this, (Object)inputStream);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _manifestDigest_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "toString";
                stringArray[1] = "<$constructor$>";
                stringArray[2] = "UTF_8";
                stringArray[3] = "replaceAll";
                stringArray[4] = "replaceAll";
                stringArray[5] = "plus";
                stringArray[6] = "<$constructor$>";
                stringArray[7] = "name";
                stringArray[8] = "DOCKER_DIGEST_ALGORITHM";
                stringArray[9] = "toString";
                stringArray[10] = "hashString";
                stringArray[11] = "function";
                stringArray[12] = "DOCKER_DIGEST_ALGORITHM";
                stringArray[13] = "UTF_8";
                stringArray[14] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[15];
                _manifestDigest_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_manifestDigest_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _manifestDigest_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (DockerDigest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[82].call(callSiteArray[83].call((Object)manifestContent), (Object)new _manifestDigest_closure2(this, this)), DockerDigest.class);
    }

    @Override
    public Map<String, DockerDigest> multipleManifestDigest(InputStreamSupplier manifestContent) throws IOException {
        Reference manifestContent2 = new Reference((Object)manifestContent);
        CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
        public final class _multipleManifestDigest_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference manifestContent;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _multipleManifestDigest_closure3(Object _outerInstance, Object _thisObject, Reference manifestContent) {
                Reference reference;
                CallSite[] callSiteArray = _multipleManifestDigest_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.manifestContent = reference = manifestContent;
            }

            public Object doCall(InputStream inputStream) {
                CallSite[] callSiteArray = _multipleManifestDigest_closure3.$getCallSiteArray();
                String manifest = ShortTypeHandling.castToString((Object)callSiteArray[0].call(CharStreams.class, callSiteArray[1].callConstructor(InputStreamReader.class, (Object)inputStream, callSiteArray[2].callGetProperty(StandardCharsets.class))));
                Map dockerDigests = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].callConstructor(HashMap.class), Map.class);
                callSiteArray[4].call((Object)dockerDigests, callSiteArray[5].callGroovyObjectGetProperty((Object)this), callSiteArray[6].callConstructor(DockerDigest.class, callSiteArray[7].call(callSiteArray[8].callGetProperty(DockerFacetUtils.class)), callSiteArray[9].call(callSiteArray[10].call(callSiteArray[11].call(callSiteArray[12].callGetProperty(DockerFacetUtils.class)), (Object)manifest, callSiteArray[13].callGetProperty(StandardCharsets.class)))));
                callSiteArray[14].call((Object)dockerDigests, callSiteArray[15].callGroovyObjectGetProperty((Object)this), callSiteArray[16].callCurrent((GroovyObject)this, this.manifestContent.get()));
                return dockerDigests;
            }

            @Generated
            public Object call(InputStream inputStream) {
                CallSite[] callSiteArray = _multipleManifestDigest_closure3.$getCallSiteArray();
                return callSiteArray[17].callCurrent((GroovyObject)this, (Object)inputStream);
            }

            @Generated
            public InputStreamSupplier getManifestContent() {
                CallSite[] callSiteArray = _multipleManifestDigest_closure3.$getCallSiteArray();
                return (InputStreamSupplier)ScriptBytecodeAdapter.castToType((Object)this.manifestContent.get(), InputStreamSupplier.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _multipleManifestDigest_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "toString";
                stringArray[1] = "<$constructor$>";
                stringArray[2] = "UTF_8";
                stringArray[3] = "<$constructor$>";
                stringArray[4] = "put";
                stringArray[5] = "DEFAULT_DIGEST";
                stringArray[6] = "<$constructor$>";
                stringArray[7] = "name";
                stringArray[8] = "DOCKER_DIGEST_ALGORITHM";
                stringArray[9] = "toString";
                stringArray[10] = "hashString";
                stringArray[11] = "function";
                stringArray[12] = "DOCKER_DIGEST_ALGORITHM";
                stringArray[13] = "UTF_8";
                stringArray[14] = "put";
                stringArray[15] = "SIGNATURE_REPLACED_DIGEST";
                stringArray[16] = "manifestDigest";
                stringArray[17] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[18];
                _multipleManifestDigest_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_multipleManifestDigest_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _multipleManifestDigest_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[84].call(callSiteArray[85].call((Object)((InputStreamSupplier)manifestContent2.get())), (Object)new _multipleManifestDigest_closure3(this, this, manifestContent2)), Map.class);
    }

    @Override
    public boolean shouldDowngrade(Content manifestContent, String name, V2Manifest.SchemaVersion clientPreference) throws IOException {
        Reference manifestContent2 = new Reference((Object)manifestContent);
        CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
        public final class _shouldDowngrade_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference manifestContent;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _shouldDowngrade_closure4(Object _outerInstance, Object _thisObject, Reference manifestContent) {
                Reference reference;
                CallSite[] callSiteArray = _shouldDowngrade_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.manifestContent = reference = manifestContent;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _shouldDowngrade_closure4.$getCallSiteArray();
                return callSiteArray[0].call(this.manifestContent.get());
            }

            @Generated
            public Content getManifestContent() {
                CallSite[] callSiteArray = _shouldDowngrade_closure4.$getCallSiteArray();
                return (Content)ScriptBytecodeAdapter.castToType((Object)this.manifestContent.get(), Content.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _shouldDowngrade_closure4.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _shouldDowngrade_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "openInputStream";
                return new CallSiteArray(_shouldDowngrade_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _shouldDowngrade_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        InputStreamSupplier inputStreamSupplier = (InputStreamSupplier)ScriptBytecodeAdapter.castToType((Object)((Object)new _shouldDowngrade_closure4(this, this, manifestContent2)), InputStreamSupplier.class);
        V2Manifest manifest = (V2Manifest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[86].callCurrent((GroovyObject)this, (Object)inputStreamSupplier, (Object)name, callSiteArray[87].callGetProperty((Object)((Content)manifestContent2.get()))), V2Manifest.class);
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[88].callStatic(V2ManifestUtilImpl.class, (Object)clientPreference, (Object)manifest));
    }

    @Override
    public DockerDigest findConfigDigest(Content manifestContent, String name) {
        CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
        V2Manifest manifest = (V2Manifest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[89].callCurrent((GroovyObject)this, (Object)manifestContent, (Object)name), V2Manifest.class);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[90].callGroovyObjectGetProperty((Object)manifest), (Object)callSiteArray[91].callGetProperty(V2Manifest.SchemaVersion.class))) {
            throw (Throwable)callSiteArray[92].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{callSiteArray[93].callGroovyObjectGetProperty((Object)manifest)}, new String[]{"Config file is not specified in schemaVersion: ", ""}));
        }
        V2ManifestSchema2 schemaV2 = (V2ManifestSchema2)ScriptBytecodeAdapter.castToType((Object)callSiteArray[94].callConstructor(V2ManifestSchema2.class, callSiteArray[95].callGroovyObjectGetProperty((Object)manifest)), V2ManifestSchema2.class);
        return (DockerDigest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[96].call(DockerDigest.class, callSiteArray[97].callGetProperty(callSiteArray[98].callGroovyObjectGetProperty((Object)schemaV2))), DockerDigest.class);
    }

    @Override
    @Transactional
    public void validateManifest(Repository repository, String name, @Nullable String tag, V2Manifest v2Manifest) {
        CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
        List validationErrors = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[99].callConstructor(ArrayList.class), List.class);
        callSiteArray[100].call((Object)v2Manifest, (Object)validationErrors, (Object)name, (Object)tag);
        List digests = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[101].call((Object)v2Manifest), List.class);
        StorageTx tx = (StorageTx)ScriptBytecodeAdapter.castToType((Object)callSiteArray[102].call(UnitOfWork.class), StorageTx.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[103].call((Object)digests))) {
            DockerDigest digest = null;
            Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[104].call((Object)digests), Iterator.class);
            while (iterator.hasNext()) {
                digest = (DockerDigest)ScriptBytecodeAdapter.castToType(iterator.next(), DockerDigest.class);
                Asset layerAsset = (Asset)ScriptBytecodeAdapter.castToType((Object)callSiteArray[105].callStatic(DockerFacetDatabaseUtils.class, (Object)tx, (Object)repository, callSiteArray[106].callStatic(DockerFacetUtils.class, (Object)digest)), Asset.class);
                Asset manifestAsset = (Asset)ScriptBytecodeAdapter.castToType((Object)callSiteArray[107].callStatic(DockerFacetDatabaseUtils.class, (Object)tx, (Object)repository, callSiteArray[108].callStatic(DockerFacetUtils.class, (Object)name, (Object)digest)), Asset.class);
                if (!(ScriptBytecodeAdapter.compareEqual((Object)layerAsset, null) && ScriptBytecodeAdapter.compareEqual((Object)manifestAsset, null))) continue;
                callSiteArray[109].call(callSiteArray[110].callGroovyObjectGetProperty((Object)this), ArrayUtil.createArray((Object)"Manifest refers to missing layer: {} for: {}/{} in repository {}", (Object)digest, (Object)name, (Object)tag, (Object)repository));
                callSiteArray[111].call((Object)validationErrors, callSiteArray[112].call(callSiteArray[113].callGetProperty(V2Error.class), callSiteArray[114].call((Object)digest)));
            }
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[115].call((Object)validationErrors))) {
            throw (Throwable)callSiteArray[116].callConstructor(V2Exception.class, (Object)"Invalid Manifest", callSiteArray[117].callGetProperty(HttpStatus.class), (Object)validationErrors);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void insertEmptyLayerIfNeeded(V2ManifestConfig config, StorageTx tx, Bucket bucket, Format format) {
        void var3_3;
        Reference tx2 = new Reference((Object)tx);
        Reference bucket2 = new Reference((Object)var3_3);
        Reference format2 = new Reference((Object)format);
        CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
        public final class _insertEmptyLayerIfNeeded_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _insertEmptyLayerIfNeeded_closure5(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _insertEmptyLayerIfNeeded_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _insertEmptyLayerIfNeeded_closure5.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(it), (Object)"empty_layer");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _insertEmptyLayerIfNeeded_closure5.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _insertEmptyLayerIfNeeded_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "contains";
                stringArray[1] = "keySet";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _insertEmptyLayerIfNeeded_closure5.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_insertEmptyLayerIfNeeded_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _insertEmptyLayerIfNeeded_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[118].call(callSiteArray[119].callGroovyObjectGetProperty((Object)config), (Object)new _insertEmptyLayerIfNeeded_closure5(this, this)))) {
            Object emptyBlobDigest = callSiteArray[120].call(DockerDigest.class, callSiteArray[121].callGroovyObjectGetProperty((Object)this));
            public final class _insertEmptyLayerIfNeeded_closure6
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference tx;
                private /* synthetic */ Reference bucket;
                private /* synthetic */ Reference format;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _insertEmptyLayerIfNeeded_closure6(Object _outerInstance, Object _thisObject, Reference tx, Reference bucket, Reference format) {
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    CallSite[] callSiteArray = _insertEmptyLayerIfNeeded_closure6.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.tx = reference3 = tx;
                    this.bucket = reference2 = bucket;
                    this.format = reference = format;
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _insertEmptyLayerIfNeeded_closure6.$getCallSiteArray();
                    return callSiteArray[0].call(this.tx.get(), this.bucket.get(), this.format.get());
                }

                @Generated
                public StorageTx getTx() {
                    CallSite[] callSiteArray = _insertEmptyLayerIfNeeded_closure6.$getCallSiteArray();
                    return (StorageTx)ScriptBytecodeAdapter.castToType((Object)this.tx.get(), StorageTx.class);
                }

                @Generated
                public Bucket getBucket() {
                    CallSite[] callSiteArray = _insertEmptyLayerIfNeeded_closure6.$getCallSiteArray();
                    return (Bucket)ScriptBytecodeAdapter.castToType((Object)this.bucket.get(), Bucket.class);
                }

                @Generated
                public Format getFormat() {
                    CallSite[] callSiteArray = _insertEmptyLayerIfNeeded_closure6.$getCallSiteArray();
                    return (Format)ScriptBytecodeAdapter.castToType((Object)this.format.get(), Format.class);
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _insertEmptyLayerIfNeeded_closure6.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _insertEmptyLayerIfNeeded_closure6.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[1];
                    stringArray[0] = "createAsset";
                    return new CallSiteArray(_insertEmptyLayerIfNeeded_closure6.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _insertEmptyLayerIfNeeded_closure6.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            Asset asset = (Asset)ScriptBytecodeAdapter.castToType((Object)callSiteArray[122].call(DockerFacetDatabaseUtils.class, ArrayUtil.createArray((Object)((StorageTx)tx2.get()), (Object)((Bucket)bucket2.get()), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Supplier)ScriptBytecodeAdapter.asType((Object)((Object)new _insertEmptyLayerIfNeeded_closure6(this, this, tx2, bucket2, format2)), Supplier.class)), Supplier.class), (Object)callSiteArray[123].call(DockerFacetUtils.class, emptyBlobDigest), (Object)emptyBlobDigest)), Asset.class);
            public final class _insertEmptyLayerIfNeeded_closure7
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _insertEmptyLayerIfNeeded_closure7(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _insertEmptyLayerIfNeeded_closure7.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _insertEmptyLayerIfNeeded_closure7.$getCallSiteArray();
                    return callSiteArray[0].callConstructor(ByteArrayInputStream.class, ScriptBytecodeAdapter.getField(_insertEmptyLayerIfNeeded_closure7.class, V2ManifestUtilImpl.class, (String)"EMPTY_BLOB_BYTES"));
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _insertEmptyLayerIfNeeded_closure7.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _insertEmptyLayerIfNeeded_closure7.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[1];
                    stringArray[0] = "<$constructor$>";
                    return new CallSiteArray(_insertEmptyLayerIfNeeded_closure7.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _insertEmptyLayerIfNeeded_closure7.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            InputStreamSupplier inputStreamSupplier = (InputStreamSupplier)ScriptBytecodeAdapter.castToType((Object)((Object)new _insertEmptyLayerIfNeeded_closure7(this, this)), InputStreamSupplier.class);
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[124].call((Object)asset), null)) {
                Object formatAttributes = callSiteArray[125].call((Object)asset);
                callSiteArray[126].call(formatAttributes, callSiteArray[127].callGetProperty(AssetEntityAdapter.class), callSiteArray[128].call(callSiteArray[129].callGetProperty(AssetKind.class)));
                callSiteArray[130].call(DockerFacetDatabaseUtils.class, ArrayUtil.createArray((Object)((StorageTx)tx2.get()), (Object)asset, (Object)inputStreamSupplier, (Object)emptyBlobDigest, (Object)callSiteArray[131].callGetProperty(V2ContentTypes.class), null));
            }
        }
    }

    public static V2ManifestConfig loadConfigurationFile(StorageTx tx, Bucket bucket, V2ManifestSchema2 schemaV2) {
        CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
        DockerDigest digest = (DockerDigest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[132].call(DockerDigest.class, callSiteArray[133].callGetProperty(callSiteArray[134].callGroovyObjectGetProperty((Object)schemaV2))), DockerDigest.class);
        Asset configAsset = (Asset)ScriptBytecodeAdapter.castToType((Object)callSiteArray[135].call(DockerFacetDatabaseUtils.class, (Object)tx, (Object)bucket, (Object)digest), Asset.class);
        if (ScriptBytecodeAdapter.compareEqual((Object)configAsset, null)) {
            throw (Throwable)callSiteArray[136].callConstructor(V2Exception.BlobNotFound.class, (Object)digest);
        }
        return (V2ManifestConfig)ScriptBytecodeAdapter.castToType((Object)callSiteArray[137].call((Object)MAPPER, callSiteArray[138].callGetProperty(callSiteArray[139].call((Object)tx, callSiteArray[140].call((Object)configAsset))), V2ManifestConfig.class), V2ManifestConfig.class);
    }

    private V2Manifest readManifestContent(Content manifestContent, String name) {
        Reference manifestContent2 = new Reference((Object)manifestContent);
        CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
        public final class _readManifestContent_closure8
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference manifestContent;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _readManifestContent_closure8(Object _outerInstance, Object _thisObject, Reference manifestContent) {
                Reference reference;
                CallSite[] callSiteArray = _readManifestContent_closure8.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.manifestContent = reference = manifestContent;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _readManifestContent_closure8.$getCallSiteArray();
                return callSiteArray[0].call(this.manifestContent.get());
            }

            @Generated
            public Content getManifestContent() {
                CallSite[] callSiteArray = _readManifestContent_closure8.$getCallSiteArray();
                return (Content)ScriptBytecodeAdapter.castToType((Object)this.manifestContent.get(), Content.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _readManifestContent_closure8.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _readManifestContent_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "openInputStream";
                return new CallSiteArray(_readManifestContent_closure8.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _readManifestContent_closure8.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        InputStreamSupplier inputStreamSupplier = (InputStreamSupplier)ScriptBytecodeAdapter.castToType((Object)((Object)new _readManifestContent_closure8(this, this, manifestContent2)), InputStreamSupplier.class);
        return (V2Manifest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[141].callCurrent((GroovyObject)this, (Object)inputStreamSupplier, (Object)name, callSiteArray[142].callGetProperty((Object)((Content)manifestContent2.get()))), V2Manifest.class);
    }

    private static boolean downgradeRequired(V2Manifest.SchemaVersion clientPreference, V2Manifest manifest) {
        CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[143].callGetProperty(V2Manifest.SchemaVersion.class), (Object)((Object)clientPreference)) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[144].callGetProperty(V2Manifest.SchemaVersion.class), (Object)callSiteArray[145].callGroovyObjectGetProperty((Object)manifest)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[146].call(callSiteArray[147].callGetProperty(MediaType.class), callSiteArray[148].callGroovyObjectGetProperty((Object)manifest))) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[149].call(callSiteArray[150].callGetProperty(V2ContentTypes.class), callSiteArray[151].callGroovyObjectGetProperty((Object)manifest)));
        }
        return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[152].callGetProperty(V2Manifest.SchemaVersion.class), (Object)((Object)clientPreference)) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[153].callGetProperty(V2Manifest.SchemaVersion.class), (Object)callSiteArray[154].callGroovyObjectGetProperty((Object)manifest)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[155].call(callSiteArray[156].callGetProperty(MediaType.class), callSiteArray[157].callGroovyObjectGetProperty((Object)manifest))) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[158].call(callSiteArray[159].callGetProperty(V2ContentTypes.class), callSiteArray[160].callGroovyObjectGetProperty((Object)manifest)));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != V2ManifestUtilImpl.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public static ObjectMapper getMAPPER() {
        return MAPPER;
    }

    @Generated
    public V2ManifestConfigDowngrader getV2ManifestConfigDowngrader() {
        return this.v2ManifestConfigDowngrader;
    }

    @Generated
    public void setV2ManifestConfigDowngrader(V2ManifestConfigDowngrader v2ManifestConfigDowngrader) {
        this.v2ManifestConfigDowngrader = v2ManifestConfigDowngrader;
    }

    @Generated
    public DockerAssetSearch getDockerAssetSearch() {
        return this.dockerAssetSearch;
    }

    @Generated
    public void setDockerAssetSearch(DockerAssetSearch dockerAssetSearch) {
        this.dockerAssetSearch = dockerAssetSearch;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "enable";
        stringArray[2] = "INDENT_OUTPUT";
        stringArray[3] = "checkNotNull";
        stringArray[4] = "checkNotNull";
        stringArray[5] = "debug";
        stringArray[6] = "log";
        stringArray[7] = "withStream";
        stringArray[8] = "get";
        stringArray[9] = "getAt";
        stringArray[10] = "V2_MANIFEST_SCHEMA1_VERSION";
        stringArray[11] = "containsKey";
        stringArray[12] = "<$constructor$>";
        stringArray[13] = "Schema1";
        stringArray[14] = "V2_MANIFEST_SCHEMA_1_SIGNED";
        stringArray[15] = "<$constructor$>";
        stringArray[16] = "Schema1";
        stringArray[17] = "V2_MANIFEST_SCHEMA_1";
        stringArray[18] = "V2_MANIFEST_SCHEMA2_VERSION";
        stringArray[19] = "containsKey";
        stringArray[20] = "matches";
        stringArray[21] = "IMAGE_INDEX";
        stringArray[22] = "get";
        stringArray[23] = "resolveMediaType";
        stringArray[24] = "IMAGE_INDEX";
        stringArray[25] = "<$constructor$>";
        stringArray[26] = "Schema2";
        stringArray[27] = "resolveMediaType";
        stringArray[28] = "IMAGE_MANIFEST";
        stringArray[29] = "<$constructor$>";
        stringArray[30] = "Schema2";
        stringArray[31] = "<$constructor$>";
        stringArray[32] = "readValue";
        stringArray[33] = "writeValueAsString";
        stringArray[34] = "get";
        stringArray[35] = "V2_MANIFEST_SCHEMA1_VERSION";
        stringArray[36] = "DOCKER_LAYERS_TYPE_REF";
        stringArray[37] = "debug";
        stringArray[38] = "log";
        stringArray[39] = "<$constructor$>";
        stringArray[40] = "getMessage";
        stringArray[41] = "parse";
        stringArray[42] = "mimeType";
        stringArray[43] = "APPLICATION_JSON";
        stringArray[44] = "mediaType";
        stringArray[45] = "mediaType";
        stringArray[46] = "config";
        stringArray[47] = "startsWith";
        stringArray[48] = "dockerMediaType";
        stringArray[49] = "ociMediaType";
        stringArray[50] = "warn";
        stringArray[51] = "log";
        stringArray[52] = "warn";
        stringArray[53] = "log";
        stringArray[54] = "debug";
        stringArray[55] = "log";
        stringArray[56] = "readManifestContent";
        stringArray[57] = "downgradeRequired";
        stringArray[58] = "currentTx";
        stringArray[59] = "debug";
        stringArray[60] = "log";
        stringArray[61] = "<$constructor$>";
        stringArray[62] = "manifest";
        stringArray[63] = "findBucket";
        stringArray[64] = "loadConfigurationFile";
        stringArray[65] = "insertEmptyLayerIfNeeded";
        stringArray[66] = "format";
        stringArray[67] = "downgrade";
        stringArray[68] = "debug";
        stringArray[69] = "log";
        stringArray[70] = "prettyPrint";
        stringArray[71] = "toJson";
        stringArray[72] = "<$constructor$>";
        stringArray[73] = "<$constructor$>";
        stringArray[74] = "writeValueAsBytes";
        stringArray[75] = "V2_MANIFEST_SCHEMA_1";
        stringArray[76] = "set";
        stringArray[77] = "attributes";
        stringArray[78] = "<$constructor$>";
        stringArray[79] = "now";
        stringArray[80] = "debug";
        stringArray[81] = "log";
        stringArray[82] = "withCloseable";
        stringArray[83] = "get";
        stringArray[84] = "withCloseable";
        stringArray[85] = "get";
        stringArray[86] = "readManifest";
        stringArray[87] = "contentType";
        stringArray[88] = "downgradeRequired";
        stringArray[89] = "readManifestContent";
        stringArray[90] = "schemaVersion";
        stringArray[91] = "Schema2";
        stringArray[92] = "<$constructor$>";
        stringArray[93] = "schemaVersion";
        stringArray[94] = "<$constructor$>";
        stringArray[95] = "manifest";
        stringArray[96] = "parse";
        stringArray[97] = "digest";
        stringArray[98] = "config";
        stringArray[99] = "<$constructor$>";
        stringArray[100] = "validateManifest";
        stringArray[101] = "referencedDigests";
        stringArray[102] = "currentTx";
        stringArray[103] = "isEmpty";
        stringArray[104] = "iterator";
        stringArray[105] = "findAsset";
        stringArray[106] = "blobName";
        stringArray[107] = "findAsset";
        stringArray[108] = "manifestName";
        stringArray[109] = "error";
        stringArray[110] = "log";
        stringArray[111] = "add";
        stringArray[112] = "withDetail";
        stringArray[113] = "BLOB_UNKNOWN";
        stringArray[114] = "toString";
        stringArray[115] = "isEmpty";
        stringArray[116] = "<$constructor$>";
        stringArray[117] = "BAD_REQUEST";
        stringArray[118] = "any";
        stringArray[119] = "history";
        stringArray[120] = "parse";
        stringArray[121] = "EMPTY_BLOB_DIGEST";
        stringArray[122] = "getOrCreateAsset";
        stringArray[123] = "blobName";
        stringArray[124] = "blobRef";
        stringArray[125] = "formatAttributes";
        stringArray[126] = "set";
        stringArray[127] = "P_ASSET_KIND";
        stringArray[128] = "name";
        stringArray[129] = "BLOB";
        stringArray[130] = "saveAsset";
        stringArray[131] = "V2_BLOB_IMAGE_LAYER";
        stringArray[132] = "parse";
        stringArray[133] = "digest";
        stringArray[134] = "config";
        stringArray[135] = "findAssetByContentDigest";
        stringArray[136] = "<$constructor$>";
        stringArray[137] = "readValue";
        stringArray[138] = "inputStream";
        stringArray[139] = "requireBlob";
        stringArray[140] = "requireBlobRef";
        stringArray[141] = "readManifest";
        stringArray[142] = "contentType";
        stringArray[143] = "Schema1";
        stringArray[144] = "Schema2";
        stringArray[145] = "schemaVersion";
        stringArray[146] = "matches";
        stringArray[147] = "IMAGE_INDEX";
        stringArray[148] = "mediaType";
        stringArray[149] = "equals";
        stringArray[150] = "OCI_IMAGE_MANIFEST_V1";
        stringArray[151] = "mediaType";
        stringArray[152] = "Schema1";
        stringArray[153] = "Schema2";
        stringArray[154] = "schemaVersion";
        stringArray[155] = "matches";
        stringArray[156] = "IMAGE_INDEX";
        stringArray[157] = "mediaType";
        stringArray[158] = "equals";
        stringArray[159] = "OCI_IMAGE_MANIFEST_V1";
        stringArray[160] = "mediaType";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[161];
        V2ManifestUtilImpl.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(V2ManifestUtilImpl.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = V2ManifestUtilImpl.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

