/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal.orient;

import java.util.Collections;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.config.WritePolicy;
import org.sonatype.nexus.repository.docker.internal.MediaType;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.WritePolicySelector;

public class DockerWritePolicySelector
implements WritePolicySelector {
    private static final String STORAGE_ATTRIBUTE = "storage";
    private static final String LATEST_POLICY_STORAGE_ATTRIBUTE = "latestPolicy";
    private static final String LATEST = "/latest";
    private static final String MANIFEST_SHA256 = "manifests/sha256";
    private Configuration configuration;

    public DockerWritePolicySelector(Configuration configuration) {
        this.configuration = configuration;
    }

    public WritePolicy select(Asset asset, WritePolicy configured) {
        if (WritePolicy.ALLOW_ONCE == configured && this.configuration != null) {
            return this.getWritePolicy(asset, configured);
        }
        return configured;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    private WritePolicy getWritePolicy(Asset asset, WritePolicy configured) {
        if (this.isLatestPolicy() && asset.name().endsWith(LATEST) || this.isDockerV2AndSha256Manifest(asset)) {
            return WritePolicy.ALLOW;
        }
        return configured;
    }

    private boolean isLatestPolicy() {
        return this.configuration.getAttributes().getOrDefault(STORAGE_ATTRIBUTE, Collections.emptyMap()).getOrDefault(LATEST_POLICY_STORAGE_ATTRIBUTE, false);
    }

    private boolean isDockerV2AndSha256Manifest(Asset asset) {
        return (MediaType.IMAGE_MANIFEST.matches(asset.contentType()) || MediaType.IMAGE_INDEX.matches(asset.contentType())) && asset.name().contains(MANIFEST_SHA256);
    }
}

