/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal.orient;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Named;
import org.joda.time.DateTime;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.docker.DockerRestoreFacet;
import org.sonatype.nexus.repository.docker.internal.AssetKind;
import org.sonatype.nexus.repository.docker.internal.DockerDigest;
import org.sonatype.nexus.repository.docker.internal.DockerFacetUtils;
import org.sonatype.nexus.repository.docker.internal.V2ManifestUtil;
import org.sonatype.nexus.repository.docker.internal.orient.DockerFacetDatabaseUtils;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreMetadata;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class DockerRestoreFacetImpl
extends FacetSupport
implements DockerRestoreFacet {
    private final V2ManifestUtil v2ManifestUtil;

    @Inject
    public DockerRestoreFacetImpl(V2ManifestUtil v2ManifestUtil) {
        this.v2ManifestUtil = (V2ManifestUtil)Preconditions.checkNotNull((Object)v2ManifestUtil);
    }

    @Override
    public Asset findAsset(Repository repository, String name) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (StorageTx tx = (StorageTx)((StorageFacet)repository.facet(StorageFacet.class)).txSupplier().get();){
            tx.begin();
            return tx.findAssetWithProperty("name", (Object)name, tx.findBucket(repository));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void restoreV2Blob(String blobName, AssetBlob assetBlob) {
        this.doSaveAsset(blobName, assetBlob, AssetKind.BLOB);
    }

    @Override
    public void restoreV2Manifest(String blobName, AssetBlob assetBlob, String name) {
        this.doSaveManifestAsset(blobName, assetBlob, name);
    }

    @Override
    public void restoreV2Tag(AssetBlob assetBlob, String name, String tag) {
        this.doSaveTag(assetBlob, name, tag);
    }

    @Override
    public void restoreV2Catalog(String blobName, AssetBlob assetBlob) {
        this.doSaveAsset(blobName, assetBlob, AssetKind.CATALOG);
    }

    @Override
    public void restoreV2TagsList(String blobName, AssetBlob assetBlob) {
        this.doSaveAsset(blobName, assetBlob, AssetKind.TAG_LIST);
    }

    @Override
    public void restoreV1Image(String blobName, AssetBlob assetBlob) {
        this.doSaveAsset(blobName, assetBlob, AssetKind.IMAGES);
    }

    @Override
    public void restoreV1LayerMetadata(String blobName, AssetBlob assetBlob, String layerId, String type) {
        this.doRestoreV1Layer(blobName, assetBlob, layerId, asset -> {
            try {
                Map<String, Object> layerMetadata = DockerFacetUtils.readLayerMetadata(() -> ((Blob)assetBlob.getBlob()).getInputStream());
                asset.formatAttributes().set("asset_kind", (Object)AssetKind.LAYER_METADATA.name());
                asset.formatAttributes().set("parent", layerMetadata.get("parent"));
            }
            catch (IOException e) {
                this.log.error("Unable to restore v1 layer metadata id {} and type {}", new Object[]{layerId, type, e});
            }
        });
    }

    @Override
    public void restoreV1LayerContent(String blobName, AssetBlob assetBlob, String layerId, String type) {
        this.doRestoreV1Layer(blobName, assetBlob, layerId, asset -> {
            Object object = asset.formatAttributes().set("asset_kind", (Object)AssetKind.LAYER_CONTENT.name());
        });
    }

    @Override
    public void restoreV1LayerAncestry(String blobName, AssetBlob assetBlob, String layerId, String type) {
        this.doRestoreV1Layer(blobName, assetBlob, layerId, asset -> {
            Object object = asset.formatAttributes().set("asset_kind", (Object)AssetKind.LAYER_ANCESTRY.name());
        });
    }

    @Override
    public void restoreV1Tag(String blobName, AssetBlob assetBlob, String name, String tag) {
        try {
            this.doRestoreV1Tag(blobName, assetBlob, name, tag);
        }
        catch (IOException e) {
            this.log.error("Unable to restore v1 tag", (Throwable)e);
        }
    }

    @Override
    public void restoreV1Tags(String blobName, AssetBlob assetBlob) {
        this.doSaveAsset(blobName, assetBlob, AssetKind.TAG_LIST);
    }

    private void doRestoreV1Layer(String blobName, AssetBlob assetBlob, String layerId, Consumer<Asset> updateAsset) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        Optional blobCreated = assetBlob.getCreatedTime();
        Asset asset = DockerFacetDatabaseUtils.getOrCreateAsset(tx, bucket, DockerFacetDatabaseUtils.createAssetSupplier(tx, bucket, this.getRepository().getFormat()), blobName, this.getDigest(assetBlob));
        asset.formatAttributes().set("layerId", (Object)layerId);
        updateAsset.accept(asset);
        this.attachAndSave(assetBlob, tx, asset, blobCreated);
    }

    @TransactionalStoreMetadata
    protected void doRestoreV1Tag(String blobName, AssetBlob assetBlob, String name, String tag) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        Optional blobCreated = assetBlob.getCreatedTime();
        Component component = DockerFacetDatabaseUtils.getOrCreateTagComponent(tx, bucket, this.getRepository(), name, tag);
        String layerId = this.updateComponentWithLayerId(assetBlob, tx, component);
        Asset asset = DockerFacetDatabaseUtils.getOrCreateAsset(tx, bucket, DockerFacetDatabaseUtils.createAssetSupplier(tx, bucket, component), blobName, this.getDigest(assetBlob));
        asset.formatAttributes().set("layerId", (Object)layerId);
        asset.formatAttributes().set("asset_kind", (Object)AssetKind.TAG.name());
        this.attachAndSave(assetBlob, tx, asset, blobCreated);
    }

    private String updateComponentWithLayerId(AssetBlob assetBlob, StorageTx tx, Component component) throws IOException {
        InputStreamSupplier tagContent = () -> ((Blob)assetBlob.getBlob()).getInputStream();
        String layerId = DockerFacetUtils.readLayerId(tagContent);
        component.formatAttributes().set("layerId", (Object)layerId);
        tx.saveComponent(component);
        return layerId;
    }

    @TransactionalStoreMetadata
    protected void doSaveAsset(String blobName, AssetBlob assetBlob, AssetKind assetKind) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        Optional blobCreated = assetBlob.getCreatedTime();
        Asset asset = DockerFacetDatabaseUtils.getOrCreateAsset(tx, bucket, DockerFacetDatabaseUtils.createAssetSupplier(tx, bucket, this.getRepository().getFormat()), blobName, this.getDigest(assetBlob));
        asset.formatAttributes().set("asset_kind", (Object)assetKind.name());
        this.attachAndSave(assetBlob, tx, asset, blobCreated);
    }

    @TransactionalStoreMetadata
    protected void doSaveTag(AssetBlob assetBlob, String name, String tag) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        Optional blobCreated = assetBlob.getCreatedTime();
        Component component = DockerFacetDatabaseUtils.getOrCreateTagComponent(tx, bucket, this.getRepository(), name, tag);
        Asset asset = DockerFacetDatabaseUtils.getOrCreateTagAsset(tx, bucket, component, name, tag, this.getDigest(assetBlob));
        this.attachAndSave(assetBlob, tx, asset, blobCreated);
    }

    @TransactionalStoreMetadata
    protected void doSaveManifestAsset(String blobName, AssetBlob assetBlob, String name) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        Optional blobCreated = assetBlob.getCreatedTime();
        Asset asset = DockerFacetDatabaseUtils.getOrCreateManifestAsset(tx, bucket, this.getRepository().getFormat(), name, this.getManifestDigest(blobName, assetBlob));
        this.attachAndSave(assetBlob, tx, asset, blobCreated);
    }

    private void attachAndSave(AssetBlob assetBlob, StorageTx tx, Asset asset, Optional<DateTime> blobCreated) {
        boolean newAsset = asset.blobCreated() == null;
        tx.attachBlob(asset, assetBlob);
        Content.applyToAsset((Asset)asset, (AttributesMap)Content.maintainLastModified((Asset)asset, null));
        if (newAsset) {
            blobCreated.ifPresent(arg_0 -> ((Asset)asset).blobCreated(arg_0));
        }
        blobCreated.ifPresent(arg_0 -> ((Asset)asset).blobUpdated(arg_0));
        tx.saveAsset(asset);
    }

    private DockerDigest getDigest(AssetBlob assetBlob) {
        HashCode hashCode = (HashCode)assetBlob.getHashes().get(DockerFacetUtils.DOCKER_DIGEST_ALGORITHM);
        return new DockerDigest(DockerFacetUtils.DOCKER_DIGEST_ALGORITHM.name(), hashCode.toString());
    }

    private DockerDigest getManifestDigest(String name, AssetBlob assetBlob) {
        try {
            return this.v2ManifestUtil.manifestDigest(() -> ((Blob)assetBlob.getBlob()).getInputStream());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to generate digest for " + name, e);
        }
    }
}

