/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal.orient;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.docker.internal.AssetKind;
import org.sonatype.nexus.repository.docker.internal.DockerAttributes;
import org.sonatype.nexus.repository.docker.internal.DockerDigest;
import org.sonatype.nexus.repository.docker.internal.DockerFacetUtils;
import org.sonatype.nexus.repository.docker.internal.DockerForeignLayerSource;
import org.sonatype.nexus.repository.docker.internal.DockerProxyFacetSupport;
import org.sonatype.nexus.repository.docker.internal.V1Exception;
import org.sonatype.nexus.repository.docker.internal.V2Exception;
import org.sonatype.nexus.repository.docker.internal.V2Handlers;
import org.sonatype.nexus.repository.docker.internal.V2Manifest;
import org.sonatype.nexus.repository.docker.internal.V2ManifestUtil;
import org.sonatype.nexus.repository.docker.internal.orient.DockerFacetDatabaseUtils;
import org.sonatype.nexus.repository.docker.internal.orient.V1Handlers;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreMetadata;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchMetadata;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.StringPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.UnitOfWork;
import org.sonatype.nexus.validation.ConstraintViolationFactory;

@Named
public class DockerProxyFacetImpl
extends DockerProxyFacetSupport {
    private final DockerForeignLayerSource foreignLayerSource;

    @Inject
    public DockerProxyFacetImpl(V2ManifestUtil v2ManifestUtil, DockerForeignLayerSource foreignLayerSource, ConstraintViolationFactory constraintViolationFactory, @Named(value="${nexus.docker.proxy.verifyManifestDigest:-true}") @Named(value="${nexus.docker.proxy.verifyManifestDigest:-true}") boolean verifyManifestDigest) {
        super(v2ManifestUtil, constraintViolationFactory, verifyManifestDigest);
        this.foreignLayerSource = Objects.requireNonNull(foreignLayerSource);
    }

    protected Content getCachedContent(Context context) throws IOException {
        switch ((AssetKind)((Object)context.getAttributes().require(AssetKind.class))) {
            case IMAGES: {
                return this.getAsset(DockerFacetUtils.v1imagesIndexName(V1Handlers.name(V2Handlers.matcherState(context))));
            }
            case TAGS: {
                return this.getAsset(DockerFacetUtils.v1tagsName(V1Handlers.name(V2Handlers.matcherState(context))));
            }
            case TAG: {
                return this.getAsset(DockerFacetUtils.v1tagName(V1Handlers.name(V2Handlers.matcherState(context)), V1Handlers.tag(V2Handlers.matcherState(context))));
            }
            case LAYER_METADATA: {
                return this.getAsset(DockerFacetUtils.v1layerMetadataName(V1Handlers.layerId(V2Handlers.matcherState(context))));
            }
            case LAYER_CONTENT: {
                return this.getAsset(DockerFacetUtils.v1layerContentName(V1Handlers.layerId(V2Handlers.matcherState(context))));
            }
            case LAYER_ANCESTRY: {
                return this.getAsset(DockerFacetUtils.v1layerAncestryName(V1Handlers.layerId(V2Handlers.matcherState(context))));
            }
            case SEARCH: {
                return null;
            }
            case MANIFEST: {
                return this.getManifest(context);
            }
            case BLOB: {
                return this.getAsset(DockerFacetUtils.blobName(V2Handlers.requireDigest(V2Handlers.matcherState(context))));
            }
            case TAG_LIST: {
                return this.getAsset(DockerFacetUtils.tagListName(V2Handlers.requireName(V2Handlers.matcherState(context))));
            }
            case CATALOG: {
                return this.getAsset(DockerFacetUtils.catalogName());
            }
        }
        throw new IllegalStateException();
    }

    protected Content store(Context context, Content content) throws IOException {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        ImmutableMap baseAttributes = ImmutableMap.of((Object)"asset_kind", (Object)assetKind.name());
        try {
            return this.storeByAssetKind(context, content, assetKind, (Map<String, Object>)baseAttributes);
        }
        catch (V1Exception e) {
            String remoteUrl = this.getRemoteUrl().toString();
            throw new V1Exception.InvalidResponseFromRemote(e, remoteUrl, context.getRequest().getPath());
        }
    }

    private Content storeByAssetKind(Context context, Content content, AssetKind assetKind, Map<String, Object> baseAttributes) throws IOException {
        switch (assetKind) {
            case IMAGES: {
                return this.putAsset(DockerFacetUtils.v1imagesIndexName(V1Handlers.name(V2Handlers.matcherState(context))), content, baseAttributes);
            }
            case TAGS: {
                return this.putTags(V1Handlers.name(V2Handlers.matcherState(context)), content);
            }
            case TAG: {
                return this.putTag(V1Handlers.name(V2Handlers.matcherState(context)), V1Handlers.tag(V2Handlers.matcherState(context)), content);
            }
            case LAYER_METADATA: {
                return this.putLayerMetadata(V1Handlers.layerId(V2Handlers.matcherState(context)), content);
            }
            case LAYER_CONTENT: {
                String layerId = V1Handlers.layerId(V2Handlers.matcherState(context));
                return this.putAsset(DockerFacetUtils.v1layerContentName(layerId), content, (Map<String, Object>)ImmutableMap.builder().putAll(baseAttributes).put((Object)"layerId", (Object)layerId).build());
            }
            case LAYER_ANCESTRY: {
                return this.putAncestry(V1Handlers.name(V2Handlers.matcherState(context)), V1Handlers.layerId(V2Handlers.matcherState(context)), content);
            }
            case SEARCH: {
                return content;
            }
            case MANIFEST: {
                return this.putManifest(context, content);
            }
            case BLOB: {
                V2Handlers.requireName(V2Handlers.matcherState(context), false);
                return this.putAssetValidatedOnDigest(DockerFacetUtils.blobName(V2Handlers.requireDigest(V2Handlers.matcherState(context))), context, content, baseAttributes);
            }
            case TAG_LIST: {
                return this.putAsset(DockerFacetUtils.tagListName(V2Handlers.requireName(V2Handlers.matcherState(context))), content, baseAttributes);
            }
            case CATALOG: {
                return this.putAsset(DockerFacetUtils.catalogName(), content, baseAttributes);
            }
        }
        throw new IllegalStateException();
    }

    protected void indicateVerified(Context context, Content content, CacheInfo cacheInfo) throws IOException {
        this.setCacheInfo(content, cacheInfo);
    }

    @Override
    protected List<String> getForeignLayerUrls(String digest) {
        return this.foreignLayerSource.getForeignLayerUrls(digest);
    }

    @Override
    protected void updateForeignLayerUrls(String digest, List<String> urls) {
        this.foreignLayerSource.updateForeignLayerUrls(digest, urls);
    }

    @Override
    protected DockerDigest manifestDigestFromContent(Content contentByHash) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var4_5 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob((Payload)contentByHash, DockerFacetDatabaseUtils.HASH_ALGORITHMS);){
            return this.v2ManifestUtil.manifestDigest((InputStreamSupplier)tempBlob);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Nullable
    @TransactionalTouchBlob
    protected Content getAsset(String name) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = DockerFacetDatabaseUtils.findAsset(tx, tx.findBucket(this.getRepository()), name);
        if (asset == null) {
            return null;
        }
        return DockerFacetDatabaseUtils.toContent(asset, tx.requireBlob(asset.requireBlobRef()));
    }

    private Content putAsset(String name, Content content, Map<String, Object> attributes) throws IOException {
        return this.putAsset(name, content, attributes, tempBlob -> {});
    }

    private Content putAsset(String name, Content content, Map<String, Object> attributes, Consumer<TempBlob> beforePutAsset) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var7_8 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob((Payload)content, DockerFacetDatabaseUtils.HASH_ALGORITHMS);){
            beforePutAsset.accept(tempBlob);
            return this.doPutAsset(name, tempBlob, (Payload)content, attributes);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Content putAssetValidatedOnDigest(String name, Context context, Content content, Map<String, Object> attributes) throws IOException {
        return this.putAsset(name, content, attributes, tempBlob -> this.maybeValidateOnDigest(V2Handlers.matcherState(context), (TempBlob)tempBlob));
    }

    @TransactionalStoreBlob
    protected Content doPutAsset(String name, TempBlob blobContent, Payload payload, Map<String, Object> attributes) throws IOException {
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = DockerFacetDatabaseUtils.findAsset(tx, bucket = tx.findBucket(this.getRepository()), name);
        if (asset == null) {
            asset = tx.createAsset(bucket, this.getRepository().getFormat());
            asset.name(name);
        }
        if (attributes != null) {
            NestedAttributesMap formatAttributes = asset.formatAttributes();
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                formatAttributes.set(entry.getKey(), entry.getValue());
            }
        }
        return DockerFacetDatabaseUtils.saveAsset(tx, asset, blobContent, payload);
    }

    private Content putTags(String name, Content content) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob((Payload)content, DockerFacetDatabaseUtils.HASH_ALGORITHMS);){
            Map<String, String> tags = DockerFacetUtils.readTags((InputStreamSupplier)tempBlob);
            for (Map.Entry<String, String> entry : tags.entrySet()) {
                this.doPutLayerIdJson(name, entry);
            }
            return this.doPutAsset(DockerFacetUtils.v1tagsName(name), tempBlob, (Payload)content, (Map<String, Object>)ImmutableMap.of((Object)"asset_kind", (Object)AssetKind.TAG_LIST.name()));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void doPutLayerIdJson(String name, Map.Entry<String, String> entry) throws IOException {
        String layerIdJson = String.valueOf('\"') + entry.getValue() + '\"';
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var6_7 = null;
        try (ByteArrayInputStream in = new ByteArrayInputStream(layerIdJson.getBytes(StandardCharsets.UTF_8));){
            Throwable throwable2 = null;
            Object var9_12 = null;
            try (TempBlob tempBlob = storageFacet.createTempBlob((InputStream)in, DockerFacetDatabaseUtils.HASH_ALGORITHMS);){
                this.doPutTag(name, entry.getKey(), tempBlob, (Payload)new Content((Payload)new StringPayload(layerIdJson, "application/json")));
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private Content putTag(String name, String tag, Content content) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var6_7 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob((Payload)content, DockerFacetDatabaseUtils.HASH_ALGORITHMS);){
            return this.doPutTag(name, tag, tempBlob, (Payload)content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @TransactionalStoreBlob
    protected Content doPutTag(String name, String tag, TempBlob tagContent, Payload payload) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        String tagAssetName = DockerFacetUtils.v1tagName(name, tag);
        Component tagComponent = DockerFacetDatabaseUtils.getOrCreateTagComponent(tx, bucket, this.getRepository(), name, tag);
        String layerId = DockerFacetUtils.readLayerId((InputStreamSupplier)tagContent);
        tagComponent.formatAttributes().set("layerId", (Object)layerId);
        tx.saveComponent(tagComponent);
        Asset tagAsset = DockerFacetDatabaseUtils.findAsset(tx, bucket, tagAssetName);
        if (tagAsset == null) {
            tagAsset = tx.createAsset(bucket, tagComponent);
            tagAsset.name(tagAssetName);
            tagAsset.formatAttributes().set("asset_kind", (Object)AssetKind.TAG.name());
        }
        tagAsset.formatAttributes().set("layerId", (Object)layerId);
        return DockerFacetDatabaseUtils.saveAsset(tx, tagAsset, tagContent, payload);
    }

    @TransactionalTouchMetadata
    public void setCacheInfo(Content content, CacheInfo cacheInfo) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = Content.findAsset((StorageTx)tx, (Bucket)tx.findBucket(this.getRepository()), (Content)content);
        if (asset == null) {
            this.log.debug("Attempting to set cache info for non-existent docker asset {}", content.getAttributes().require(Asset.class));
            return;
        }
        this.log.debug("Updating cacheInfo of {} to {}", (Object)asset, (Object)cacheInfo);
        CacheInfo.applyToAsset((Asset)asset, (CacheInfo)cacheInfo);
        tx.saveAsset(asset);
    }

    private Content putAncestry(String name, String layerId, Content content) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var6_7 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob((Payload)content, DockerFacetDatabaseUtils.HASH_ALGORITHMS);){
            List<String> ancestry = DockerFacetUtils.readAncestry((InputStreamSupplier)tempBlob);
            this.doPutAncestry(name, layerId, ancestry);
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("layerId", layerId);
            attributes.put("asset_kind", AssetKind.LAYER_ANCESTRY.name());
            return this.doPutAsset(DockerFacetUtils.v1layerAncestryName(layerId), tempBlob, (Payload)content, attributes);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @TransactionalStoreMetadata
    protected void doPutAncestry(String name, String layerId, List<String> ancestry) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        String format = this.getRepository().getFormat().getValue();
        Iterable tagComponents = tx.findComponents(Query.builder().where("name").eq((Object)name).and("attributes." + format + "." + "layerId").eq((Object)layerId).build(), Collections.singletonList(this.getRepository()));
        for (Component tagComponent : tagComponents) {
            NestedAttributesMap formatAttributes = tagComponent.formatAttributes();
            List currentAncestry = (List)formatAttributes.get("layerAncestry", DockerAttributes.T_LAYER_ANCESTRY);
            if (currentAncestry != null && currentAncestry.equals(ancestry)) continue;
            formatAttributes.set("layerAncestry", ancestry);
            tx.saveComponent(tagComponent);
        }
    }

    private Content putLayerMetadata(String layerId, Content content) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob((Payload)content, DockerFacetDatabaseUtils.HASH_ALGORITHMS);){
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("layerId", layerId);
            Map<String, Object> layerMetadata = DockerFacetUtils.readLayerMetadata((InputStreamSupplier)tempBlob);
            attributes.put("parent", layerMetadata.get("parent"));
            attributes.put("asset_kind", AssetKind.LAYER_METADATA.name());
            return this.doPutAsset(DockerFacetUtils.v1layerMetadataName(layerId), tempBlob, (Payload)content, attributes);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Content getManifest(Context context) throws IOException {
        TokenMatcher.State state = V2Handlers.matcherState(context);
        String name = V2Handlers.requireName(state);
        String tag = V2Handlers.tag(state);
        V2Manifest.SchemaVersion schemaVersion = V2Handlers.detectClientSchemaVersionPreference(context);
        Content manifest = tag != null ? this.getAsset(DockerFacetUtils.tagName(name, tag)) : this.getAsset(DockerFacetUtils.manifestName(name, V2Handlers.requireDigest(state)));
        if (manifest != null && schemaVersion == V2Manifest.SchemaVersion.Schema2 && DockerFacetUtils.isTrue(this.config.cacheForeignLayers)) {
            this.identifyForeignLayers(manifest);
        }
        return manifest;
    }

    private Content putManifest(Context context, Content content) throws IOException {
        String tag = V2Handlers.tag(V2Handlers.matcherState(context));
        if (!Strings.isNullOrEmpty((String)tag)) {
            return this.putManifestByTag(V2Handlers.requireName(V2Handlers.matcherState(context)), tag, context, content);
        }
        return this.putManifestByDigest(V2Handlers.requireName(V2Handlers.matcherState(context)), V2Handlers.requireDigest(V2Handlers.matcherState(context)), content.getAttributes(), content);
    }

    private Content putManifestByTag(String name, String tag, Context context, Content content) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var7_8 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob((Payload)content, DockerFacetDatabaseUtils.HASH_ALGORITHMS);){
            DockerDigest manifestDigest = this.fetchTagDigestByContentDigest(context, tag, content.getAttributes(), tempBlob);
            this.doPutManifestByDigest(name, manifestDigest, content.getAttributes(), tempBlob, content.getContentType());
            return this.doPutManifestByTag(name, tag, content.getAttributes(), tempBlob, manifestDigest, content.getContentType());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @TransactionalStoreBlob
    protected Content doPutManifestByTag(String name, String tag, @Nullable AttributesMap contentAttributes, TempBlob manifestContent, DockerDigest manifestDigest, @Nullable String contentType) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        Component tagComponent = DockerFacetDatabaseUtils.getOrCreateTagComponent(tx, bucket, this.getRepository(), name, tag);
        Asset tagAsset = DockerFacetDatabaseUtils.getOrCreateTagAsset(tx, bucket, tagComponent, name, tag, manifestDigest);
        String contentTypeOrDefault = contentType != null ? contentType : "application/json";
        return DockerFacetDatabaseUtils.saveAsset(tx, tagAsset, manifestContent, manifestDigest, contentTypeOrDefault, contentAttributes);
    }

    private Content putManifestByDigest(String name, DockerDigest digest, @Nullable AttributesMap contentAttributes, Content content) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var7_8 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob((Payload)content, DockerFacetDatabaseUtils.HASH_ALGORITHMS);){
            return this.doPutManifestByDigest(name, digest, contentAttributes, tempBlob, content.getContentType());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @TransactionalStoreBlob
    protected Content doPutManifestByDigest(String name, DockerDigest digest, @Nullable AttributesMap contentAttributes, TempBlob manifestContent, @Nullable String contentType) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        Map<String, DockerDigest> dockerDigests = this.v2ManifestUtil.multipleManifestDigest((InputStreamSupplier)manifestContent);
        DockerDigest manifestDigest = null;
        for (DockerDigest existingDigest : dockerDigests.values()) {
            if (!digest.equals(existingDigest)) continue;
            manifestDigest = existingDigest;
            break;
        }
        if (this.verifyManifestDigest && manifestDigest == null) {
            throw new V2Exception.DigestInvalidByMismatch();
        }
        Asset manifestAsset = DockerFacetDatabaseUtils.getOrCreateManifestAsset(tx, bucket, this.getRepository().getFormat(), name, manifestDigest);
        if (manifestAsset.blobRef() != null) {
            Content.applyToAsset((Asset)manifestAsset, (AttributesMap)contentAttributes);
            return DockerFacetDatabaseUtils.toContent(manifestAsset, tx.requireBlob(manifestAsset.requireBlobRef()));
        }
        String contentTypeOrDefault = contentType != null ? contentType : "application/json";
        return DockerFacetDatabaseUtils.saveAsset(tx, manifestAsset, manifestContent, manifestDigest, contentTypeOrDefault, contentAttributes);
    }
}

