/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal.orient;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.common.app.BaseUrlHolder;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.hash.HashAlgorithmHelper;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.orient.entity.AttachedEntityHelper;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.docker.UploadManager;
import org.sonatype.nexus.repository.docker.internal.AssetKind;
import org.sonatype.nexus.repository.docker.internal.DockerAttributes;
import org.sonatype.nexus.repository.docker.internal.DockerDigest;
import org.sonatype.nexus.repository.docker.internal.DockerFacetUtils;
import org.sonatype.nexus.repository.docker.internal.DockerV1Utility;
import org.sonatype.nexus.repository.docker.internal.Upload;
import org.sonatype.nexus.repository.docker.internal.UploadCompletion;
import org.sonatype.nexus.repository.docker.internal.UploadManagerImpl;
import org.sonatype.nexus.repository.docker.internal.V1Exception;
import org.sonatype.nexus.repository.docker.internal.V2Exception;
import org.sonatype.nexus.repository.docker.internal.V2Manifest;
import org.sonatype.nexus.repository.docker.internal.V2ManifestUtil;
import org.sonatype.nexus.repository.docker.internal.V2TagListResult;
import org.sonatype.nexus.repository.docker.internal.datastore.recipe.DockerHostedFacetSupport;
import org.sonatype.nexus.repository.docker.internal.orient.DockerAssetSearch;
import org.sonatype.nexus.repository.docker.internal.orient.DockerFacetDatabaseUtils;
import org.sonatype.nexus.repository.docker.internal.orient.DockerWritePolicySelector;
import org.sonatype.nexus.repository.mime.ContentValidator;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.AssetManager;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ContentValidatorSelector;
import org.sonatype.nexus.repository.storage.OrientHardLinkHelper;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.storage.WritePolicySelector;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreMetadata;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchMetadata;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.StringPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class DockerHostedFacetImpl
extends DockerHostedFacetSupport {
    private final V2ManifestUtil v2ManifestUtil;
    private final DockerAssetSearch dockerAssetSearch;
    private final AssetManager assetManager;
    private final OrientHardLinkHelper hardLinkHelper;
    private final HashAlgorithmHelper hashAlgorithmHelper;
    private final ContentValidatorSelector contentValidatorSelector;
    private DockerWritePolicySelector dockerWritePolicySelector;

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        this.dockerWritePolicySelector = new DockerWritePolicySelector(configuration);
        ((StorageFacet)this.getRepository().facet(StorageFacet.class)).registerWritePolicySelector((WritePolicySelector)this.dockerWritePolicySelector);
    }

    @Inject
    public DockerHostedFacetImpl(V2ManifestUtil v2ManifestUtil, AssetManager assetManager, DockerAssetSearch dockerAssetSearch, OrientHardLinkHelper hardLinkHelper, HashAlgorithmHelper hashAlgorithmHelper, ContentValidatorSelector contentValidatorSelector, @Named(value="${nexus.docker.upload.lock.size:-64}") @Named(value="${nexus.docker.upload.lock.size:-64}") int uploadLockSize) {
        super(uploadLockSize);
        this.v2ManifestUtil = (V2ManifestUtil)Preconditions.checkNotNull((Object)v2ManifestUtil);
        this.assetManager = assetManager;
        this.dockerAssetSearch = (DockerAssetSearch)((Object)Preconditions.checkNotNull((Object)((Object)dockerAssetSearch)));
        this.hardLinkHelper = (OrientHardLinkHelper)Preconditions.checkNotNull((Object)hardLinkHelper);
        this.hashAlgorithmHelper = (HashAlgorithmHelper)Preconditions.checkNotNull((Object)hashAlgorithmHelper);
        this.contentValidatorSelector = (ContentValidatorSelector)Preconditions.checkNotNull((Object)contentValidatorSelector);
    }

    public DockerHostedFacetImpl(UploadManager uploadManager, V2ManifestUtil v2ManifestUtil, AssetManager assetManager, DockerAssetSearch dockerAssetSearch) {
        super((UploadManager)Preconditions.checkNotNull((Object)uploadManager));
        this.v2ManifestUtil = (V2ManifestUtil)Preconditions.checkNotNull((Object)v2ManifestUtil);
        this.assetManager = assetManager;
        this.dockerAssetSearch = (DockerAssetSearch)((Object)Preconditions.checkNotNull((Object)((Object)dockerAssetSearch)));
        this.hardLinkHelper = null;
        this.hashAlgorithmHelper = null;
        this.contentValidatorSelector = null;
    }

    @Override
    protected UploadManager createUploadManager(int uploadLockSize) {
        return new UploadManagerImpl((Provider<BlobStore>)((Provider)() -> ((StorageFacet)this.facet(StorageFacet.class)).blobStore()), uploadLockSize);
    }

    @Override
    @TransactionalTouchBlob
    public Content getImagesIndex(String name) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        String imagesIndexAssetName = DockerFacetUtils.v1imagesIndexName(name);
        Asset asset = DockerFacetDatabaseUtils.findAsset(tx, tx.findBucket(this.getRepository()), imagesIndexAssetName);
        if (asset == null) {
            throw new V1Exception.ImagesNotFound();
        }
        return DockerFacetDatabaseUtils.toContent(asset, tx.requireBlob(asset.requireBlobRef()));
    }

    @Override
    public void putImagesIndex(String name, Payload content) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(content, DockerFacetDatabaseUtils.HASH_ALGORITHMS);){
            DockerFacetUtils.readImagesIndex((InputStreamSupplier)tempBlob);
            this.doPutImagesIndex(name, tempBlob, content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @TransactionalStoreBlob
    protected void doPutImagesIndex(String name, TempBlob imagesIndexContent, Payload payload) throws IOException {
        String imagesIndexAssetName;
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset imagesIndexAsset = DockerFacetDatabaseUtils.findAsset(tx, bucket = tx.findBucket(this.getRepository()), imagesIndexAssetName = DockerFacetUtils.v1imagesIndexName(name));
        if (imagesIndexAsset == null) {
            imagesIndexAsset = tx.createAsset(bucket, this.getRepository().getFormat());
            imagesIndexAsset.name(imagesIndexAssetName);
            imagesIndexAsset.formatAttributes().set("asset_kind", (Object)AssetKind.IMAGES.name());
            DockerFacetDatabaseUtils.saveAsset(tx, imagesIndexAsset, imagesIndexContent, payload);
        } else {
            List<Map<String, Object>> mergedIndex = DockerV1Utility.mergeIndexes(DockerFacetUtils.readImagesIndex(this.blobStreamSupplier(tx, imagesIndexAsset)), DockerFacetUtils.readImagesIndex((InputStreamSupplier)imagesIndexContent));
            byte[] buf = DockerFacetUtils.mapper.writeValueAsBytes(mergedIndex);
            InputStreamSupplier indexStreamSupplier = () -> new ByteArrayInputStream(buf);
            DockerFacetDatabaseUtils.saveAsset(tx, imagesIndexAsset, indexStreamSupplier, payload);
        }
    }

    @Override
    @TransactionalTouchBlob
    public Content getLayerMetadata(String layerId) throws IOException {
        DockerFacetUtils.validateLayerId(layerId);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset metadataAsset = this.findMetadataAsset(tx, layerId);
        Content content = DockerFacetDatabaseUtils.toContent(metadataAsset, tx.requireBlob(metadataAsset.requireBlobRef()));
        NestedAttributesMap componentAttributes = metadataAsset.formatAttributes();
        content.getAttributes().set("X-Docker-Size", componentAttributes.get("X-Docker-Size"));
        content.getAttributes().set("X-Docker-Checksum-Payload", componentAttributes.get("X-Docker-Checksum-Payload"));
        return content;
    }

    @Override
    public void putLayerMetadata(String layerId, Payload content) throws IOException {
        DockerFacetUtils.validateLayerId(layerId);
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(content, DockerFacetDatabaseUtils.HASH_ALGORITHMS);){
            this.doPutLayerMetadata(layerId, tempBlob, content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @TransactionalStoreBlob
    protected void doPutLayerMetadata(String layerId, TempBlob layerMetadataContent, Payload payload) throws IOException {
        NestedAttributesMap metadataFormatAttributes;
        Map<String, Object> layerMetadata = DockerFacetUtils.readLayerMetadata((InputStreamSupplier)layerMetadataContent);
        if (!layerMetadata.containsKey("id")) {
            throw new V1Exception.InvalidLayerMetadata("Missing key 'id' in JSON");
        }
        if (!layerMetadata.get("id").equals(layerId)) {
            throw new V1Exception.InvalidLayerMetadata("JSON data contains invalid id");
        }
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        String metadataAssetName = DockerFacetUtils.v1layerMetadataName(layerId);
        String parentId = (String)layerMetadata.get("parent");
        Asset parentAsset = null;
        List ancestry = null;
        if (parentId != null && ((parentAsset = DockerFacetDatabaseUtils.findAsset(tx, bucket, DockerFacetUtils.v1layerMetadataName(parentId))) == null || Boolean.TRUE.equals(parentAsset.formatAttributes().get("inProgress")))) {
            throw new V1Exception.InvalidLayerMetadata("Image depends on a non existing parent");
        }
        if (parentAsset != null) {
            ancestry = (List)parentAsset.formatAttributes().get("ancestry", DockerAttributes.T_ANCESTRY);
        }
        if (ancestry == null) {
            ancestry = Lists.newArrayList();
        }
        ancestry.add(0, layerId);
        Asset metadataAsset = DockerFacetDatabaseUtils.findAsset(tx, bucket, metadataAssetName);
        if (metadataAsset == null) {
            metadataAsset = tx.createAsset(bucket, this.getRepository().getFormat());
            metadataAsset.name(metadataAssetName);
            metadataFormatAttributes = metadataAsset.formatAttributes();
            metadataFormatAttributes.set("layerId", (Object)layerId);
            metadataFormatAttributes.set("asset_kind", (Object)AssetKind.LAYER_METADATA.name());
            metadataFormatAttributes.set("inProgress", (Object)true);
        } else {
            metadataFormatAttributes = metadataAsset.formatAttributes();
            if (!Boolean.TRUE.equals(metadataFormatAttributes.get("inProgress"))) {
                throw new V1Exception.ImageAlreadyExists();
            }
            metadataFormatAttributes.remove("X-Docker-Checksum-Payload");
        }
        metadataFormatAttributes.set("parent", (Object)parentId);
        metadataFormatAttributes.set("ancestry", (Object)ancestry);
        metadataFormatAttributes.set("arch", layerMetadata.get("os"));
        metadataFormatAttributes.set("os", layerMetadata.get("architecture"));
        DockerFacetDatabaseUtils.saveAsset(tx, metadataAsset, layerMetadataContent, payload);
    }

    @Override
    @TransactionalTouchBlob
    public Content getLayerContent(String layerId) throws IOException {
        DockerFacetUtils.validateLayerId(layerId);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        String layerAssetName = DockerFacetUtils.v1layerContentName(layerId);
        this.findMetadataAsset(tx, layerId);
        Asset layerAsset = DockerFacetDatabaseUtils.findAsset(tx, tx.findBucket(this.getRepository()), layerAssetName);
        if (layerAsset == null) {
            throw new V1Exception.ImageNotFound();
        }
        return DockerFacetDatabaseUtils.toContent(layerAsset, tx.requireBlob(layerAsset.requireBlobRef()));
    }

    @Override
    public void putLayerContent(String layerId, Payload content) throws IOException {
        DockerFacetUtils.validateLayerId(layerId);
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(content, DockerFacetDatabaseUtils.HASH_ALGORITHMS);){
            this.doPutLayerContent(layerId, tempBlob, content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void putLayerContent(String layerId, Payload payload, File content) throws IOException {
        DockerFacetUtils.validateLayerId(layerId);
        this.doPutLayerContent(layerId, payload, content);
    }

    @TransactionalStoreBlob
    protected void doPutLayerContent(String layerId, TempBlob layerContent, Payload payload) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        String metadataAssetName = DockerFacetUtils.v1layerMetadataName(layerId);
        Asset metadataAsset = DockerFacetDatabaseUtils.findAsset(tx, bucket, metadataAssetName);
        AttributesMap metadataFormatAttributes = this.getMetadataAttributes(metadataAsset);
        Asset layerAsset = this.getLayerAsset(layerId, tx, bucket);
        DockerFacetDatabaseUtils.saveAsset(tx, layerAsset, layerContent, payload);
        metadataFormatAttributes.set("X-Docker-Size", (Object)layerAsset.size());
        metadataFormatAttributes.set("X-Docker-Checksum-Payload", (Object)DockerFacetDatabaseUtils.calculateChecksum(tx, metadataAsset, layerAsset).toString());
        tx.saveAsset(metadataAsset);
    }

    @TransactionalStoreBlob
    protected void doPutLayerContent(String layerId, Payload payload, File content) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        String metadataAssetName = DockerFacetUtils.v1layerMetadataName(layerId);
        Asset metadataAsset = DockerFacetDatabaseUtils.findAsset(tx, bucket, metadataAssetName);
        AttributesMap metadataFormatAttributes = this.getMetadataAttributes(metadataAsset);
        Asset layerAsset = this.getLayerAsset(layerId, tx, bucket);
        Map checksums = this.hashAlgorithmHelper.calculateChecksums(content, DockerFacetDatabaseUtils.HASH_ALGORITHMS);
        AssetBlob layerContent = this.hardLinkHelper.ingestHardLink(tx, content, checksums);
        DockerFacetDatabaseUtils.saveAsset(tx, layerAsset, layerContent, payload);
        metadataFormatAttributes.set("X-Docker-Size", (Object)layerAsset.size());
        metadataFormatAttributes.set("X-Docker-Checksum-Payload", (Object)DockerFacetDatabaseUtils.calculateChecksum(tx, metadataAsset, layerAsset).toString());
        tx.saveAsset(metadataAsset);
    }

    @Override
    @TransactionalStoreMetadata
    public void doPutLayerChecksum(String layerId, String checksum) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        String metadataAssetName = DockerFacetUtils.v1layerMetadataName(layerId);
        Asset metadataAsset = DockerFacetDatabaseUtils.findAsset(tx, tx.findBucket(this.getRepository()), metadataAssetName);
        if (metadataAsset == null) {
            throw new V1Exception.ImageNotFound();
        }
        NestedAttributesMap metadataFormatAttributes = metadataAsset.formatAttributes();
        if (!Boolean.TRUE.equals(metadataFormatAttributes.get("inProgress"))) {
            throw new V1Exception.ImageAlreadyExists("Cannot set this image checksum");
        }
        Object actualChecksum = metadataFormatAttributes.get("X-Docker-Checksum-Payload");
        if (!checksum.equals(actualChecksum)) {
            this.log.error("Wrong checksum. Actual: {}; Expected: {}", actualChecksum, (Object)checksum);
            throw new V1Exception.InvalidChecksum("Checksum mismatch");
        }
        metadataFormatAttributes.remove("inProgress");
        tx.saveAsset(metadataAsset);
    }

    @Override
    @TransactionalTouchMetadata
    public Content getLayerAncestry(String layerId) throws IOException {
        DockerFacetUtils.validateLayerId(layerId);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset metadataAsset = this.findMetadataAsset(tx, layerId);
        String where = String.format("%s IS NOT NULL AND %s.%s.%s = :layerId", "component", "attributes", this.getRepository().getFormat(), "layerId");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("layerId", layerId);
        Iterable tagAssets = tx.findAssets(where, parameters, (Iterable)ImmutableList.of((Object)this.getRepository()), null);
        for (Asset tagAsset : tagAssets) {
            this.maybeMarkDownloaded(tx, tagAsset);
        }
        String ancestry = DockerFacetUtils.mapper.writeValueAsString(metadataAsset.formatAttributes().get("ancestry"));
        return new Content((Payload)new StringPayload(ancestry, "application/json"));
    }

    @Override
    @Transactional
    public Content getTags(String name) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Iterable<Component> tagComponents = this.findComponents(tx, name);
        HashMap<String, String> tags = new HashMap<String, String>();
        for (Component tagComponent : tagComponents) {
            tags.put(tagComponent.version(), (String)tagComponent.formatAttributes().get("layerId", String.class));
        }
        if (tags.isEmpty()) {
            throw new V1Exception.RepositoryNotFound();
        }
        return new Content((Payload)new StringPayload(DockerFacetUtils.mapper.writeValueAsString(tags), "application/json"));
    }

    @Override
    @TransactionalTouchMetadata
    public Content getTag(String name, String tag) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Component tagComponent = DockerFacetDatabaseUtils.findComponent(tx, this.getRepository(), name, tag);
        if (tagComponent == null) {
            throw new V1Exception.TagNotFound();
        }
        String tagAssetName = DockerFacetUtils.v1tagName(name, tag);
        Asset tagAsset = DockerFacetDatabaseUtils.findAsset(tx, tx.findBucket(this.getRepository()), tagAssetName);
        if (tagAsset == null) {
            throw new V1Exception.TagNotFound();
        }
        String layerId = (String)tagComponent.formatAttributes().get("layerId", String.class);
        Content content = new Content((Payload)new StringPayload(DockerFacetUtils.mapper.writeValueAsString((Object)layerId), "application/json"));
        Content.extractFromAsset((Asset)tagAsset, DockerFacetDatabaseUtils.HASH_ALGORITHMS, (AttributesMap)content.getAttributes());
        return content;
    }

    @Override
    public void putTag(String name, String tag, Map<String, String> daemonMetadata, Payload content) throws IOException {
        DockerFacetUtils.validateTagName(tag);
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var7_8 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(content, DockerFacetDatabaseUtils.HASH_ALGORITHMS);){
            this.doPutTag(name, tag, daemonMetadata, tempBlob, content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @TransactionalStoreBlob
    protected void doPutTag(String name, String tag, Map<String, String> daemonMetadata, TempBlob tagContent, Payload payload) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        String imageIndexAssetName = DockerFacetUtils.v1imagesIndexName(name);
        String tagAssetName = DockerFacetUtils.v1tagName(name, tag);
        Asset imageIndexAsset = DockerFacetDatabaseUtils.findAsset(tx, bucket, imageIndexAssetName);
        if (imageIndexAsset == null) {
            throw new V1Exception.ImagesNotFound();
        }
        String layerId = DockerFacetUtils.readLayerId((InputStreamSupplier)tagContent);
        Asset metadataAsset = this.findMetadataAsset(tx, layerId);
        Component tagComponent = DockerFacetDatabaseUtils.findComponent(tx, this.getRepository(), name, tag);
        if (tagComponent == null) {
            tagComponent = ((Component)tx.createComponent(bucket, this.getRepository().getFormat()).name(name)).version(tag);
        }
        NestedAttributesMap tagComponentFormatAttributes = tagComponent.formatAttributes();
        tagComponentFormatAttributes.set("imageName", (Object)name);
        tagComponentFormatAttributes.set("imageTag", (Object)tag);
        tagComponentFormatAttributes.set("layerId", (Object)layerId);
        tagComponentFormatAttributes.set("layerAncestry", metadataAsset.formatAttributes().get("ancestry"));
        NestedAttributesMap tagDaemonMetadata = tagComponentFormatAttributes.child("daemonMetadata");
        tagDaemonMetadata.clear();
        for (Map.Entry<String, String> entry : daemonMetadata.entrySet()) {
            tagDaemonMetadata.set(entry.getKey(), (Object)entry.getValue());
        }
        tx.saveComponent(tagComponent);
        Asset tagAsset = DockerFacetDatabaseUtils.findAsset(tx, bucket, tagAssetName);
        if (tagAsset == null) {
            tagAsset = tx.createAsset(bucket, tagComponent);
            tagAsset.name(tagAssetName);
            tagAsset.formatAttributes().set("asset_kind", (Object)AssetKind.TAG.name());
        }
        tagAsset.formatAttributes().set("layerId", (Object)layerId);
        DockerFacetDatabaseUtils.saveAsset(tx, tagAsset, tagContent, payload);
    }

    private Iterable<Component> findComponents(StorageTx tx, String name) {
        return tx.findComponents(Query.builder().where("name").eq((Object)name).build(), Collections.singletonList(this.getRepository()));
    }

    @Override
    @TransactionalTouchBlob
    public Content getBlob(DockerDigest digest) {
        String blobName;
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = DockerFacetDatabaseUtils.findAsset(tx, bucket = tx.findBucket(this.getRepository()), blobName = DockerFacetUtils.blobName(digest));
        if (asset == null) {
            throw new V2Exception.BlobNotFound(digest);
        }
        return DockerFacetDatabaseUtils.toContent(asset, tx.requireBlob(asset.requireBlobRef()));
    }

    @Override
    @TransactionalDeleteBlob
    public void deleteBlob(DockerDigest digest) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        String blobName = DockerFacetUtils.blobName(digest);
        Asset asset = DockerFacetDatabaseUtils.findAsset(tx, tx.findBucket(this.getRepository()), blobName);
        if (asset == null) {
            throw new V2Exception.BlobNotFound(digest);
        }
        tx.deleteAsset(asset);
    }

    @Override
    protected UploadCompletion createUploadCompletion(String name, DockerDigest digest, Content content, Upload upload) {
        String location = null;
        if (BaseUrlHolder.isSet()) {
            String[] urlParts = BaseUrlHolder.get().split("/");
            String url = String.join((CharSequence)"/", urlParts[0], urlParts[1], urlParts[2]);
            location = String.valueOf(url) + "/v2/" + name + "/blobs/" + digest;
        }
        return new UploadCompletion(content, location, (String)content.getAttributes().get("Docker-Content-Digest", String.class), "0-" + (upload.length() - 1L));
    }

    @Override
    @TransactionalStoreBlob
    protected Content saveUploadToAsset(Upload upload, DockerDigest digest) throws IOException {
        Content content;
        block19: {
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            Bucket bucket = tx.findBucket(this.getRepository());
            String blobName = DockerFacetUtils.blobName(digest);
            Asset asset = DockerFacetDatabaseUtils.findAsset(tx, bucket, blobName);
            Throwable throwable = null;
            Object var9_9 = null;
            try (InputStream inputStream = upload.getInputStream();){
                if (asset == null) {
                    StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
                    Throwable throwable2 = null;
                    Object var13_15 = null;
                    try (TempBlob tempBlob = storageFacet.createTempBlob(inputStream, DockerFacetDatabaseUtils.HASH_ALGORITHMS);){
                        content = this.doPutBlob(blobName, digest, tempBlob);
                        break block19;
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                DockerFacetUtils.validateContentDigest(inputStream, digest);
                this.log.debug("Digest {} already exists, discarding.", (Object)digest);
                this.log.debug("UUID ALREADY exists {}", (Object)upload.getUuid());
                content = DockerFacetDatabaseUtils.toContent(asset, tx.requireBlob(asset.requireBlobRef()));
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        return content;
    }

    @Override
    @TransactionalStoreBlob
    protected Content saveUploadToAssetViaHardLink(File blobLocation, Upload upload, DockerDigest digest) throws IOException {
        Content content;
        String blobName;
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = DockerFacetDatabaseUtils.findAsset(tx, bucket = tx.findBucket(this.getRepository()), blobName = DockerFacetUtils.blobName(digest));
        if (asset == null) {
            Map checksums = this.hashAlgorithmHelper.calculateChecksums(blobLocation, DockerFacetDatabaseUtils.HASH_ALGORITHMS);
            String contentType = this.getContentType(blobLocation, blobName);
            AssetBlob assetBlob = this.hardLinkHelper.ingestHardLink(tx, blobLocation, checksums, contentType);
            content = this.doPutBlob(blobName, digest, assetBlob);
        } else {
            Throwable throwable = null;
            Object var10_12 = null;
            try (InputStream inputStream = upload.getInputStream();){
                DockerFacetUtils.validateContentDigest(inputStream, digest);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.log.debug("Digest {} already exists, discarding.", (Object)digest);
            this.log.debug("UUID ALREADY exists {}", (Object)upload.getUuid());
            content = DockerFacetDatabaseUtils.toContent(asset, tx.requireBlob(asset.requireBlobRef()));
        }
        return content;
    }

    @Override
    @Transactional
    public Content getCatalog() throws IOException {
        return super.getCatalog();
    }

    @Override
    @Transactional
    public Content getTagList(String name) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Iterable<Component> components = this.findComponents(tx, name);
        if (!components.iterator().hasNext()) {
            throw new V2Exception.NameUnknown(name);
        }
        V2TagListResult tagList = new V2TagListResult();
        tagList.setName(name);
        for (Component component : components) {
            tagList.getTags().add(component.version());
        }
        tagList.getTags().sort(null);
        return new Content((Payload)new StringPayload(DockerFacetUtils.mapper.writeValueAsString((Object)tagList), "application/json"));
    }

    @Override
    public Content putManifestByTag(String name, String tag, Payload payload, boolean verifyManifest) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var7_8 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(payload, DockerFacetDatabaseUtils.HASH_ALGORITHMS);){
            return this.doPutManifestByTag(name, tag, tempBlob, payload.getContentType(), verifyManifest);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @TransactionalStoreBlob
    protected Content doPutManifestByTag(String name, String tag, TempBlob manifestContent, @Nullable String manifestContentType, boolean verifyManifest) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        DockerDigest manifestDigest = this.v2ManifestUtil.manifestDigest((InputStreamSupplier)manifestContent);
        this.doPutManifestByDigest(name, tag, manifestDigest, manifestContent, manifestContentType, verifyManifest);
        Component tagComponent = DockerFacetDatabaseUtils.getOrCreateTagComponent(tx, bucket, this.getRepository(), name, tag);
        Asset tagAsset = DockerFacetDatabaseUtils.getOrCreateTagAsset(tx, bucket, tagComponent, name, tag, manifestDigest);
        return DockerFacetDatabaseUtils.saveAsset(tx, tagAsset, manifestContent, manifestDigest, manifestContentType, null);
    }

    @Override
    public Content putManifestByDigest(String name, DockerDigest digest, Payload payload, boolean verifyManifest) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var7_8 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(payload, DockerFacetDatabaseUtils.HASH_ALGORITHMS);){
            return this.doPutManifestByDigest(name, null, digest, tempBlob, payload.getContentType(), verifyManifest);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @TransactionalStoreBlob
    protected Content doPutManifestByDigest(String name, @Nullable String tag, DockerDigest digest, TempBlob manifestContent, @Nullable String manifestContentType, boolean verifyManifest) throws IOException {
        DockerDigest manifestDigest;
        V2Manifest manifest = this.v2ManifestUtil.readManifest((InputStreamSupplier)manifestContent, name, manifestContentType);
        Repository repository = this.getRepository();
        if (verifyManifest) {
            this.v2ManifestUtil.validateManifest(repository, name, tag, manifest);
        }
        if (!(manifestDigest = this.v2ManifestUtil.manifestDigest((InputStreamSupplier)manifestContent)).equals(digest)) {
            throw new V2Exception.DigestInvalid("digest mismatch");
        }
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(repository);
        Asset manifestAsset = DockerFacetDatabaseUtils.getOrCreateManifestAsset(tx, bucket, repository.getFormat(), name, manifestDigest);
        return DockerFacetDatabaseUtils.saveAsset(tx, manifestAsset, manifestContent, manifestDigest, manifestContentType, null);
    }

    @Override
    @TransactionalStoreBlob
    public Content importManifestByDigest(String name, DockerDigest digest, Payload payload) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var6_7 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(payload, DockerFacetDatabaseUtils.HASH_ALGORITHMS);){
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            Bucket bucket = tx.findBucket(this.getRepository());
            V2Manifest manifest = this.v2ManifestUtil.readManifest((InputStreamSupplier)tempBlob, name, "application/json");
            DockerDigest manifestDigest = this.v2ManifestUtil.manifestDigest((InputStreamSupplier)tempBlob);
            if (!manifestDigest.equals(digest)) {
                throw new V2Exception.DigestInvalid("digest mismatch");
            }
            Asset manifestAsset = DockerFacetDatabaseUtils.getOrCreateManifestAsset(tx, bucket, this.getRepository().getFormat(), name, manifestDigest);
            return DockerFacetDatabaseUtils.saveAsset(tx, manifestAsset, tempBlob, manifestDigest, manifest.getMediaType(), null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @TransactionalStoreBlob
    public Content importManifestByTag(String name, String tag, Payload payload) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var6_7 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(payload, DockerFacetDatabaseUtils.HASH_ALGORITHMS);){
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            Bucket bucket = tx.findBucket(this.getRepository());
            V2Manifest manifest = this.v2ManifestUtil.readManifest((InputStreamSupplier)tempBlob, name, "application/json");
            DockerDigest manifestDigest = this.v2ManifestUtil.manifestDigest((InputStreamSupplier)tempBlob);
            Component tagComponent = DockerFacetDatabaseUtils.getOrCreateTagComponent(tx, bucket, this.getRepository(), name, tag);
            Asset tagAsset = DockerFacetDatabaseUtils.getOrCreateTagAsset(tx, bucket, tagComponent, name, tag, manifestDigest);
            return DockerFacetDatabaseUtils.saveAsset(tx, tagAsset, tempBlob, manifestDigest, manifest.getMediaType(), null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @TransactionalStoreBlob
    public Content importV1LayerMetadata(String layerId, Payload payload) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(payload, DockerFacetDatabaseUtils.HASH_ALGORITHMS);){
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            Bucket bucket = tx.findBucket(this.getRepository());
            String metadataAssetName = DockerFacetUtils.v1layerMetadataName(layerId);
            Asset metadataAsset = DockerFacetDatabaseUtils.findAsset(tx, bucket, metadataAssetName);
            if (metadataAsset == null) {
                metadataAsset = tx.createAsset(bucket, this.getRepository().getFormat());
                metadataAsset.name(metadataAssetName);
            }
            return DockerFacetDatabaseUtils.saveAsset(tx, metadataAsset, tempBlob, payload);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @TransactionalStoreBlob
    public Content importV1LayerContent(String layerId, Payload payload) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(payload, DockerFacetDatabaseUtils.HASH_ALGORITHMS);){
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            Bucket bucket = tx.findBucket(this.getRepository());
            String layerAssetName = DockerFacetUtils.v1layerContentName(layerId);
            Asset layerAsset = DockerFacetDatabaseUtils.findAsset(tx, bucket, layerAssetName);
            if (layerAsset == null) {
                layerAsset = tx.createAsset(bucket, this.getRepository().getFormat());
                layerAsset.name(layerAssetName);
            }
            return DockerFacetDatabaseUtils.saveAsset(tx, layerAsset, tempBlob, payload);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @TransactionalStoreBlob
    public Content importV1LayerContent(String layerId, Payload payload, File content) throws IOException {
        String layerAssetName;
        Map checksums = this.hashAlgorithmHelper.calculateChecksums(content, DockerFacetDatabaseUtils.HASH_ALGORITHMS);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        AssetBlob assetBlob = this.hardLinkHelper.ingestHardLink(tx, content, checksums);
        Bucket bucket = tx.findBucket(this.getRepository());
        Asset layerAsset = DockerFacetDatabaseUtils.findAsset(tx, bucket, layerAssetName = DockerFacetUtils.v1layerContentName(layerId));
        if (layerAsset == null) {
            layerAsset = tx.createAsset(bucket, this.getRepository().getFormat());
            layerAsset.name(layerAssetName);
        }
        return DockerFacetDatabaseUtils.saveAsset(tx, layerAsset, assetBlob, payload);
    }

    @Override
    public Content importV1ImagesIndex(String name, Payload content) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(content, DockerFacetDatabaseUtils.HASH_ALGORITHMS);){
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            Bucket bucket = tx.findBucket(this.getRepository());
            String imagesIndexAssetName = DockerFacetUtils.v1imagesIndexName(name);
            Asset imagesIndexAsset = DockerFacetDatabaseUtils.findAsset(tx, bucket, imagesIndexAssetName);
            if (imagesIndexAsset == null) {
                imagesIndexAsset = tx.createAsset(bucket, this.getRepository().getFormat());
                imagesIndexAsset.name(imagesIndexAssetName);
            }
            return DockerFacetDatabaseUtils.saveAsset(tx, imagesIndexAsset, tempBlob, content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Content importV1Tag(String name, String tag, Payload content) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var6_7 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(content, DockerFacetDatabaseUtils.HASH_ALGORITHMS);){
            Asset tagAsset;
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            Bucket bucket = tx.findBucket(this.getRepository());
            String tagAssetName = DockerFacetUtils.v1tagName(name, tag);
            Component tagComponent = DockerFacetDatabaseUtils.findComponent(tx, this.getRepository(), name, tag);
            if (tagComponent == null) {
                tagComponent = ((Component)tx.createComponent(bucket, this.getRepository().getFormat()).name(name)).version(tag);
                tx.saveComponent(tagComponent);
            }
            if ((tagAsset = DockerFacetDatabaseUtils.findAsset(tx, bucket, tagAssetName)) == null) {
                tagAsset = tx.createAsset(bucket, tagComponent);
                tagAsset.name(tagAssetName);
                tagAsset.formatAttributes().set("asset_kind", (Object)AssetKind.TAG.name());
            }
            return DockerFacetDatabaseUtils.saveAsset(tx, tagAsset, tempBlob, content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected Iterable<String> getUniqueComponentNames() {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        String sql = String.format("SELECT DISTINCT(%s) AS %s FROM component WHERE %s=:bucket ORDER BY %s", "name", "name", "bucket", "name");
        ImmutableMap sqlParams = ImmutableMap.of((Object)"bucket", (Object)AttachedEntityHelper.id((Entity)bucket));
        return Iterables.transform((Iterable)tx.browse(sql, (Map)sqlParams), doc -> (String)doc.field("name", String.class));
    }

    @Override
    @TransactionalTouchBlob
    public Content getManifestByTag(String name, String tag, V2Manifest.SchemaVersion schemaVersion) throws IOException {
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset tagAsset = DockerFacetDatabaseUtils.findAsset(tx, bucket = tx.findBucket(this.getRepository()), DockerFacetUtils.tagName(name, tag));
        if (tagAsset == null) {
            throw new V2Exception.ManifestUnknownByTag(name, tag);
        }
        Blob blob = tx.requireBlob(tagAsset.requireBlobRef());
        Content manifestContent = DockerFacetDatabaseUtils.toContent(tagAsset, blob);
        Content content = this.v2ManifestUtil.mayDowngrade(manifestContent, name, tag, schemaVersion, this.getRepository());
        Content.extractFromAsset((Asset)tagAsset, DockerFacetDatabaseUtils.HASH_ALGORITHMS, (AttributesMap)content.getAttributes());
        String contentType = this.resolveMediaType(name, tagAsset, blob, content);
        return DockerFacetUtils.createDockerManifestContent(content, contentType);
    }

    @Override
    @TransactionalTouchBlob
    public Content getManifestByDigest(String name, DockerDigest digest) {
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset manifestAsset = DockerFacetDatabaseUtils.findAsset(tx, bucket = tx.findBucket(this.getRepository()), DockerFacetUtils.manifestName(name, digest));
        if (manifestAsset == null) {
            Set<String> assets = this.dockerAssetSearch.findByContentDigest(digest, name, bucket.getRepositoryName());
            Asset asset = manifestAsset = !assets.isEmpty() ? tx.findAssetWithProperty("name", (Object)assets.iterator().next(), bucket) : null;
            if (manifestAsset == null) {
                throw new V2Exception.ManifestUnknownByDigest(name, digest);
            }
        }
        Blob blob = tx.requireBlob(manifestAsset.requireBlobRef());
        Content content = DockerFacetDatabaseUtils.toContent(manifestAsset, blob);
        String contentType = this.resolveMediaType(name, manifestAsset, blob, content);
        return DockerFacetUtils.createDockerManifestContent(content, contentType);
    }

    private String resolveMediaType(String name, Asset asset, Blob blob, Content content) {
        String contentType = content.getContentType();
        if ("application/json".equalsIgnoreCase(contentType)) {
            try {
                V2Manifest v2Manifest = this.v2ManifestUtil.readManifest(() -> ((Blob)blob).getInputStream(), name, asset.contentType());
                if (v2Manifest.getMediaType() != null) {
                    contentType = v2Manifest.getMediaType();
                }
            }
            catch (IOException e) {
                this.log.warn("Error occurred negotiating content type", (Throwable)e);
            }
        }
        return contentType;
    }

    @Override
    @TransactionalDeleteBlob
    public void deleteManifest(String name, DockerDigest digest) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        boolean changed = false;
        if (this.maybeDeleteByContentDigest(tx, bucket, digest, name)) {
            changed = true;
        }
        if (this.maybeDeleteByTag(tx, bucket, digest, name)) {
            changed = true;
        }
        if (!changed) {
            throw new V2Exception.ManifestUnknownByDigest(name, digest);
        }
    }

    @TransactionalDeleteBlob
    private boolean maybeDeleteByTag(StorageTx tx, Bucket bucket, DockerDigest digest, String namespace) {
        Set<String> manifestAssets = this.dockerAssetSearch.findByContentDigest(digest, namespace, bucket.getRepositoryName());
        boolean deleted = false;
        if (!manifestAssets.isEmpty()) {
            for (String manifestAsset : manifestAssets) {
                if (manifestAsset == null) continue;
                Asset asset = tx.findAssetWithProperty("name", (Object)manifestAsset, bucket);
                if (asset != null) {
                    tx.deleteComponent(tx.findComponent(asset.componentId()));
                }
                deleted = true;
            }
        }
        return deleted;
    }

    @TransactionalDeleteBlob
    private boolean maybeDeleteByContentDigest(StorageTx tx, Bucket bucket, DockerDigest digest, String name) throws IOException {
        Asset manifestAsset = DockerFacetDatabaseUtils.findAsset(tx, bucket, DockerFacetUtils.manifestName(name, digest));
        if (manifestAsset != null) {
            BlobRef blobRef = manifestAsset.requireBlobRef();
            this.v2ManifestUtil.readManifest(() -> ((Blob)tx.requireBlob(blobRef)).getInputStream(), name, manifestAsset.contentType());
            tx.deleteAsset(manifestAsset);
            return true;
        }
        return false;
    }

    @TransactionalStoreBlob
    protected Content doPutBlob(String name, DockerDigest digest, TempBlob blobContent) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = this.getAsset(tx, name);
        return DockerFacetDatabaseUtils.saveAsset(tx, asset, blobContent, digest, "application/gzip", null);
    }

    @TransactionalStoreBlob
    protected Content doPutBlob(String name, DockerDigest digest, AssetBlob blobContent) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = this.getAsset(tx, name);
        return DockerFacetDatabaseUtils.saveAsset(tx, asset, blobContent, digest, null);
    }

    private Asset getAsset(StorageTx tx, String name) {
        Bucket bucket = tx.findBucket(this.getRepository());
        Asset asset = DockerFacetDatabaseUtils.findAsset(tx, bucket, name);
        if (asset == null) {
            asset = tx.createAsset(bucket, this.getRepository().getFormat());
            asset.name(name);
            asset.formatAttributes().set("asset_kind", (Object)AssetKind.BLOB.name());
        }
        return asset;
    }

    private Asset findMetadataAsset(StorageTx tx, String layerId) {
        Asset metadataAsset = DockerFacetDatabaseUtils.findAsset(tx, tx.findBucket(this.getRepository()), DockerFacetUtils.v1layerMetadataName(layerId));
        if (metadataAsset == null || Boolean.TRUE.equals(metadataAsset.formatAttributes().get("inProgress"))) {
            throw new V1Exception.ImageNotFound();
        }
        return metadataAsset;
    }

    private InputStreamSupplier blobStreamSupplier(StorageTx tx, Asset asset) {
        return () -> ((Blob)tx.requireBlob(asset.requireBlobRef())).getInputStream();
    }

    private void maybeMarkDownloaded(StorageTx tx, Asset asset) {
        if (this.assetManager.maybeUpdateLastDownloaded(asset)) {
            tx.saveAsset(asset);
        }
    }

    private Asset getLayerAsset(String layerId, StorageTx tx, Bucket bucket) {
        String layerAssetName = DockerFacetUtils.v1layerContentName(layerId);
        Asset layerAsset = DockerFacetDatabaseUtils.findAsset(tx, bucket, layerAssetName);
        if (layerAsset == null) {
            layerAsset = tx.createAsset(bucket, this.getRepository().getFormat());
            layerAsset.name(layerAssetName);
            NestedAttributesMap layerFormatAttributes = layerAsset.formatAttributes();
            layerFormatAttributes.set("layerId", (Object)layerId);
            layerFormatAttributes.set("asset_kind", (Object)AssetKind.LAYER_CONTENT.name());
        }
        return layerAsset;
    }

    private AttributesMap getMetadataAttributes(Asset metadataAsset) {
        if (metadataAsset == null) {
            throw new V1Exception.ImageNotFound();
        }
        NestedAttributesMap metadataFormatAttributes = metadataAsset.formatAttributes();
        if (!Boolean.TRUE.equals(metadataFormatAttributes.get("inProgress"))) {
            throw new V1Exception.ImageAlreadyExists();
        }
        return metadataFormatAttributes;
    }

    private String getContentType(File file, String contentName) throws IOException {
        ContentValidator validator = this.contentValidatorSelector.validator(this.getRepository());
        Boolean strictContentTypeValidation = (Boolean)this.getRepository().getConfiguration().attributes("storage").get("strictContentTypeValidation", Boolean.class, (Object)Boolean.FALSE);
        Objects.requireNonNull(strictContentTypeValidation);
        return validator.determineContentType(strictContentTypeValidation.booleanValue(), () -> new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0])), null, contentName, null);
    }

    protected void doConfigure(Configuration configuration) throws Exception {
        if (this.dockerWritePolicySelector != null) {
            this.dockerWritePolicySelector.setConfiguration(configuration);
        }
    }
}

