/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal.orient;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.hash.Funnels;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.common.hash.PrimitiveSink;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.docker.internal.AssetKind;
import org.sonatype.nexus.repository.docker.internal.DockerDigest;
import org.sonatype.nexus.repository.docker.internal.DockerFacetUtils;
import org.sonatype.nexus.repository.docker.internal.V2Exception;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.types.GroupType;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.BlobPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

public final class DockerFacetDatabaseUtils {
    static final List<HashAlgorithm> HASH_ALGORITHMS = Lists.newArrayList((Object[])new HashAlgorithm[]{DockerFacetUtils.DOCKER_DIGEST_ALGORITHM, HashAlgorithm.SHA1});

    static Content toContent(Asset asset, Blob blob) {
        Content content = new Content((Payload)new BlobPayload(blob, asset.requireContentType()));
        Content.extractFromAsset((Asset)asset, HASH_ALGORITHMS, (AttributesMap)content.getAttributes());
        String contentDigest = (String)asset.formatAttributes().get("content_digest", String.class);
        if (contentDigest != null) {
            content.getAttributes().set("Docker-Content-Digest", (Object)contentDigest);
        }
        return content;
    }

    @Nullable
    public static Component findComponent(StorageTx tx, Repository repository, String name, String tag) {
        Iterable components = tx.findComponents(Query.builder().where("name").eq((Object)name).and("version").eq((Object)tag).build(), Collections.singletonList(repository));
        if (components.iterator().hasNext()) {
            return (Component)components.iterator().next();
        }
        return null;
    }

    @Nullable
    static Asset findAssetByContentDigest(StorageTx tx, Bucket bucket, DockerDigest digest) {
        String digestProp = String.format("%s[%s][%s]", "attributes", "docker", "content_digest");
        return tx.findAssetWithProperty(digestProp, (Object)digest.toString(), bucket);
    }

    static Component getOrCreateTagComponent(StorageTx tx, Bucket bucket, Repository repository, String name, String tag) {
        Component tagComponent = DockerFacetDatabaseUtils.findComponent(tx, repository, name, tag);
        if (tagComponent == null) {
            tagComponent = ((Component)tx.createComponent(bucket, repository.getFormat()).name(name)).version(tag);
            NestedAttributesMap formatAttributes = tagComponent.formatAttributes();
            formatAttributes.set("imageName", (Object)name);
            formatAttributes.set("imageTag", (Object)tag);
            tx.saveComponent(tagComponent);
        }
        return tagComponent;
    }

    static Asset getOrCreateAsset(StorageTx tx, Bucket bucket, Supplier<Asset> assetCreator, String assetName, DockerDigest digest) {
        NestedAttributesMap formatAttributes;
        Asset asset = DockerFacetDatabaseUtils.findAsset(tx, bucket, assetName);
        if (asset == null) {
            asset = assetCreator.get();
            asset.name(assetName);
            formatAttributes = asset.formatAttributes();
            formatAttributes.set("asset_kind", (Object)AssetKind.MANIFEST.name());
        } else {
            formatAttributes = asset.formatAttributes();
        }
        if (digest != null) {
            formatAttributes.set("content_digest", (Object)digest.toString());
        }
        return asset;
    }

    static Asset getOrCreateTagAsset(StorageTx tx, Bucket bucket, Component tagComponent, String name, String tag, DockerDigest digest) {
        return DockerFacetDatabaseUtils.getOrCreateAsset(tx, bucket, DockerFacetDatabaseUtils.createAssetSupplier(tx, bucket, tagComponent), DockerFacetUtils.tagName(name, tag), digest);
    }

    static Asset getOrCreateManifestAsset(StorageTx tx, Bucket bucket, Format format, String name, DockerDigest digest) {
        return DockerFacetDatabaseUtils.getOrCreateAsset(tx, bucket, DockerFacetDatabaseUtils.createAssetSupplier(tx, bucket, format), DockerFacetUtils.manifestName(name, digest), digest);
    }

    static Supplier<Asset> createAssetSupplier(StorageTx tx, Bucket bucket, Format format) {
        return () -> tx.createAsset(bucket, format);
    }

    static Supplier<Asset> createAssetSupplier(StorageTx tx, Bucket bucket, Component component) {
        return () -> tx.createAsset(bucket, component);
    }

    @Nullable
    public static Asset findAsset(StorageTx tx, Bucket bucket, String assetName) {
        return tx.findAssetWithProperty("name", (Object)assetName, bucket);
    }

    @Nullable
    public static Asset findAsset(StorageTx tx, Repository repository, String assetName) {
        if (repository.getType() instanceof GroupType) {
            GroupFacet groupFacet = (GroupFacet)repository.facet(GroupFacet.class);
            for (Repository leafRepository : groupFacet.leafMembers()) {
                Bucket bucket = tx.findBucket(leafRepository);
                Asset asset = DockerFacetDatabaseUtils.findAsset(tx, bucket, assetName);
                if (asset == null) continue;
                return asset;
            }
        } else {
            Bucket bucket = tx.findBucket(repository);
            return DockerFacetDatabaseUtils.findAsset(tx, bucket, assetName);
        }
        return null;
    }

    static Content saveAsset(StorageTx tx, Asset asset, InputStreamSupplier contentSupplier, Payload payload) throws IOException {
        AttributesMap contentAttributes = null;
        DockerDigest contentDigest = null;
        String contentType = null;
        if (payload instanceof Content) {
            contentAttributes = ((Content)payload).getAttributes();
            String digestStr = (String)contentAttributes.get("Docker-Content-Digest", String.class);
            if (!Strings.isNullOrEmpty((String)digestStr)) {
                contentDigest = DockerDigest.parse(digestStr);
            }
            contentType = payload.getContentType();
        }
        return DockerFacetDatabaseUtils.saveAsset(tx, asset, contentSupplier, contentDigest, contentType, contentAttributes);
    }

    static Content saveAsset(StorageTx tx, Asset asset, TempBlob tempBlob, Payload payload) throws IOException {
        AttributesMap contentAttributes = null;
        DockerDigest contentDigest = null;
        String contentType = null;
        if (payload instanceof Content) {
            contentAttributes = ((Content)payload).getAttributes();
            String digestStr = (String)contentAttributes.get("Docker-Content-Digest", String.class);
            if (!Strings.isNullOrEmpty((String)digestStr)) {
                contentDigest = DockerDigest.parse(digestStr);
            }
            contentType = payload.getContentType();
        }
        return DockerFacetDatabaseUtils.saveAsset(tx, asset, tempBlob, contentDigest, contentType, contentAttributes);
    }

    static Content saveAsset(StorageTx tx, Asset asset, AssetBlob blob, Payload payload) {
        String digestStr;
        AttributesMap contentAttributes = null;
        DockerDigest contentDigest = null;
        if (payload instanceof Content && !Strings.isNullOrEmpty((String)(digestStr = (String)(contentAttributes = ((Content)payload).getAttributes()).get("Docker-Content-Digest", String.class)))) {
            contentDigest = DockerDigest.parse(digestStr);
        }
        return DockerFacetDatabaseUtils.saveAsset(tx, asset, blob, contentDigest, contentAttributes);
    }

    static Content saveAsset(StorageTx tx, Asset asset, InputStreamSupplier contentSupplier, @Nullable DockerDigest digest, String contentType, @Nullable AttributesMap contentAttributes) throws IOException {
        Content.applyToAsset((Asset)asset, (AttributesMap)Content.maintainLastModified((Asset)asset, (AttributesMap)contentAttributes));
        AssetBlob assetBlob = tx.setBlob(asset, asset.name(), contentSupplier, HASH_ALGORITHMS, null, contentType, false);
        return DockerFacetDatabaseUtils.getContent(tx, asset, digest, assetBlob);
    }

    static Content saveAsset(StorageTx tx, Asset asset, TempBlob tempBlob, @Nullable DockerDigest digest, String contentType, @Nullable AttributesMap contentAttributes) throws IOException {
        Content.applyToAsset((Asset)asset, (AttributesMap)Content.maintainLastModified((Asset)asset, (AttributesMap)contentAttributes));
        AssetBlob assetBlob = tx.setBlob(asset, asset.name(), tempBlob, null, contentType, false);
        return DockerFacetDatabaseUtils.getContent(tx, asset, digest, assetBlob);
    }

    static Content saveAsset(StorageTx tx, Asset asset, AssetBlob blobContent, DockerDigest digest, @Nullable AttributesMap contentAttributes) {
        Content.applyToAsset((Asset)asset, (AttributesMap)Content.maintainLastModified((Asset)asset, (AttributesMap)contentAttributes));
        tx.attachBlob(asset, blobContent);
        return DockerFacetDatabaseUtils.getContent(tx, asset, digest, blobContent);
    }

    private static Content getContent(StorageTx tx, Asset asset, @Nullable DockerDigest digest, AssetBlob assetBlob) {
        HashCode contentDigest;
        NestedAttributesMap formatAttributes = asset.formatAttributes();
        if (formatAttributes.get("content_digest") == null && (contentDigest = asset.getChecksum(DockerFacetUtils.DOCKER_DIGEST_ALGORITHM)) != null) {
            DockerDigest dockerDigest = new DockerDigest(DockerFacetUtils.DOCKER_DIGEST_ALGORITHM.name(), contentDigest.toString());
            formatAttributes.set("content_digest", (Object)dockerDigest.toString());
        }
        if (digest != null && !digest.toString().equals(formatAttributes.get("content_digest"))) {
            throw new V2Exception.DigestInvalid("digest mismatch");
        }
        tx.saveAsset(asset);
        return DockerFacetDatabaseUtils.toContent(asset, assetBlob.getBlob());
    }

    public static DockerDigest calculateChecksum(StorageTx tx, Asset metadataAsset, Asset layerAsset) throws IOException {
        InputStream in;
        Hasher hasher = DockerFacetUtils.DOCKER_DIGEST_ALGORITHM.function().newHasher();
        OutputStream output = Funnels.asOutputStream((PrimitiveSink)hasher);
        Throwable throwable = null;
        Object var6_8 = null;
        try {
            in = tx.requireBlob(metadataAsset.requireBlobRef()).getInputStream();
            try {
                ByteStreams.copy((InputStream)in, (OutputStream)output);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        hasher.putString((CharSequence)"\n", StandardCharsets.UTF_8);
        throwable = null;
        var6_8 = null;
        try {
            in = tx.requireBlob(layerAsset.requireBlobRef()).getInputStream();
            try {
                ByteStreams.copy((InputStream)in, (OutputStream)output);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        return new DockerDigest(DockerFacetUtils.DOCKER_DIGEST_ALGORITHM.name(), hasher.hash().toString());
    }

    private DockerFacetDatabaseUtils() {
    }
}

