/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal.orient;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.id.ORID;
import com.sonatype.nexus.repository.group.deploy.GroupWriteFacet;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.entity.EntityMetadata;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.WritePolicy;
import org.sonatype.nexus.repository.content.error.MissingAssetException;
import org.sonatype.nexus.repository.docker.internal.V2Manifest;
import org.sonatype.nexus.repository.docker.internal.V2ManifestUtil;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetEntityAdapter;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentDirector;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named(value="docker")
@Singleton
public class DockerComponentDirector
extends ComponentSupport
implements ComponentDirector {
    private final V2ManifestUtil v2ManifestUtil;
    private final RepositoryManager repositoryManager;
    private final AssetEntityAdapter assetEntityAdapter;
    private final BlobStoreManager blobStoreManager;
    private final NodeAccess nodeAccess;

    @Inject
    public DockerComponentDirector(V2ManifestUtil v2ManifestUtil, RepositoryManager repositoryManager, AssetEntityAdapter assetEntityAdapter, BlobStoreManager blobStoreManager, NodeAccess nodeAccess) {
        this.v2ManifestUtil = (V2ManifestUtil)Preconditions.checkNotNull((Object)v2ManifestUtil);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.assetEntityAdapter = (AssetEntityAdapter)Preconditions.checkNotNull((Object)assetEntityAdapter);
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
    }

    public boolean allowMoveTo(Repository destination) {
        return true;
    }

    public boolean allowMoveTo(Component component, Repository destination) {
        return !component.formatAttributes().contains("layerId");
    }

    public boolean allowMoveFrom(Repository source) {
        return true;
    }

    @Transactional
    public Component beforeMove(Component component, List<Asset> assets, Repository source, Repository destination) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        ORID sourceBucketId = this.assetEntityAdapter.recordIdentity(this.bucketEntityIdOf(tx, source));
        EntityId destBucketEntityId = this.bucketEntityIdOf(tx, destination);
        ORID destBucketId = this.assetEntityAdapter.recordIdentity(destBucketEntityId);
        LinkedList<Asset> queue = new LinkedList<Asset>();
        queue.add(this.componentAssetByDigest(component, assets, tx, sourceBucketId));
        while (!queue.isEmpty()) {
            Asset asset = (Asset)queue.remove();
            if ("MANIFEST".equals(asset.formatAttributes().get("asset_kind"))) {
                V2Manifest manifest = this.parseManifest(asset, tx);
                queue.addAll(this.manifestChildrenAssets(manifest, component, tx, source, sourceBucketId));
            }
            this.maybeCopyAsset(asset, source, destination, tx, destBucketId, destBucketEntityId);
        }
        return component;
    }

    public boolean redeployAllowed(Repository repository, Component component) {
        return super.redeployAllowed(repository, component) || "latest".equalsIgnoreCase(component.version()) && this.canUpdateLatest(repository);
    }

    private boolean canUpdateLatest(Repository destination) {
        NestedAttributesMap storage = destination.getConfiguration().attributes("storage");
        boolean allowOnce = WritePolicy.ALLOW_ONCE.name().equals(storage.get("writePolicy"));
        return allowOnce && (Boolean)storage.get("latestPolicy", Boolean.class, (Object)false) != false;
    }

    private Asset componentAssetByDigest(Component component, List<Asset> assets, StorageTx tx, ORID bucketId) {
        String componentName = component.toStringExternal();
        Preconditions.checkState((assets.size() == 1 ? 1 : 0) != 0, (String)"Docker component must have exactly one asset; component: %s", (Object)componentName);
        Asset manifestAsset = assets.get(0);
        String manifestDigest = (String)manifestAsset.formatAttributes().get("content_digest", String.class);
        String assetName = manifestAsset.name();
        Preconditions.checkState((manifestDigest != null ? 1 : 0) != 0, (String)"Docker component asset must reference the manifest digest; component: %s, asset: %s", (Object)componentName, (Object)assetName);
        String assetNameByDigest = String.format("v2/%s/manifests/%s", component.name(), manifestDigest);
        Asset asset = this.assetEntityAdapter.findByBucketComponentName(tx.getDb(), bucketId, null, assetNameByDigest);
        Preconditions.checkNotNull((Object)asset, (String)"Missing asset: %s", (Object)assetNameByDigest);
        return asset;
    }

    private V2Manifest parseManifest(Asset manifestAsset, StorageTx tx) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream inputStream = tx.requireBlob(manifestAsset.blobRef()).getInputStream();){
                return this.v2ManifestUtil.readManifest(() -> inputStream, manifestAsset.name(), manifestAsset.contentType());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Failed to read manifest: %s", manifestAsset.name()), e);
        }
    }

    private List<Asset> manifestChildrenAssets(V2Manifest manifest, Component component, StorageTx tx, Repository repository, ORID bucketId) {
        ArrayList<Asset> children = new ArrayList<Asset>();
        this.childrenNames(manifest, component).forEach(name -> {
            Asset asset = this.assetEntityAdapter.findByBucketComponentName(tx.getDb(), bucketId, null, name);
            if (asset == null) {
                throw new MissingAssetException(name, "docker", this.isWritableMember(repository), repository.getName(), component.name());
            }
            children.add(asset);
        });
        return children;
    }

    private boolean isWritableMember(Repository source) {
        return StreamSupport.stream(this.repositoryManager.browse().spliterator(), false).map(repo -> repo.optionalFacet(GroupWriteFacet.class)).filter(Optional::isPresent).map(Optional::get).map(GroupWriteFacet::getWritableMember).filter(Objects::nonNull).anyMatch(writableMember -> writableMember.getName().equals(source.getName()));
    }

    private void maybeCopyAsset(Asset asset, Repository source, Repository destination, StorageTx tx, ORID destBucketId, EntityId destBucketEntityId) {
        String assetName = asset.name();
        this.log.debug("Maybe copying asset: {}, from repository: {}, to repository: {}", new Object[]{assetName, source.getName(), destination.getName()});
        Asset destAsset = this.assetEntityAdapter.findByBucketComponentName(tx.getDb(), destBucketId, null, assetName);
        if (destAsset == null) {
            BlobRef blobRef = asset.blobRef();
            asset.setEntityMetadata(null);
            asset.bucketId(destBucketEntityId);
            asset.blobRef(this.copyBlob(tx, blobRef, destination));
            tx.saveAsset(asset);
        }
    }

    private List<String> childrenNames(V2Manifest manifest, Component component) {
        ArrayList<String> childrenNames = new ArrayList<String>();
        manifest.getListedManifests().forEach(digest -> {
            boolean bl = childrenNames.add(String.format("v2/%s/manifests/%s", component.name(), digest));
        });
        if (manifest.getListedManifests().isEmpty()) {
            manifest.referencedDigests().forEach(digest -> {
                boolean bl = childrenNames.add(String.format("v2/-/blobs/%s", digest));
            });
        }
        return childrenNames;
    }

    private BlobRef copyBlob(StorageTx tx, BlobRef srcBlobRef, Repository destRepo) {
        Preconditions.checkNotNull((Object)srcBlobRef);
        Preconditions.checkNotNull((Object)destRepo);
        Blob srcBlob = tx.requireBlob(srcBlobRef);
        HashMap<String, String> headers = new HashMap<String, String>(srcBlob.getHeaders());
        headers.put("Bucket.repo-name", destRepo.getName());
        BlobStore destBlobStore = this.blobStoreOf(this.blobStoreNameOf(destRepo), "destination");
        Blob destBlob = destBlobStore.create(srcBlob.getInputStream(), headers);
        return new BlobRef(this.nodeAccess.getId(), destBlobStore.getBlobStoreConfiguration().getName(), destBlob.getId().asUniqueString());
    }

    private EntityId bucketEntityIdOf(StorageTx storageTx, Repository repository) {
        return Optional.of(storageTx).map(tx -> tx.findBucket(repository)).map(Entity::getEntityMetadata).map(EntityMetadata::getId).orElseThrow(() -> new IllegalStateException("Unable to obtain bucket entity id for repository: " + repository.getConfiguration()));
    }

    private String blobStoreNameOf(Repository repository) {
        return Optional.of(repository).map(Repository::getConfiguration).map(c -> c.attributes("storage")).map(a -> (String)a.get("blobStoreName", String.class)).orElseThrow(() -> new IllegalStateException(String.format("Unable to find blob store name for destination repository: %s", repository.getName())));
    }

    private BlobStore blobStoreOf(String blobStoreName, String identifier) {
        return Optional.of(blobStoreName).map(arg_0 -> ((BlobStoreManager)this.blobStoreManager).get(arg_0)).orElseThrow(() -> new IllegalStateException(String.format("Unable to find %s blob store: %s", identifier, blobStoreName)));
    }
}

