/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal.orient;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.browse.BrowsePaths;
import org.sonatype.nexus.repository.browse.ComponentPathBrowseNodeGenerator;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Component;

@Singleton
@Named(value="docker")
public class DockerBrowseNodeGenerator
extends ComponentPathBrowseNodeGenerator {
    public List<BrowsePaths> computeAssetPaths(Asset asset, @Nullable Component component) {
        Preconditions.checkNotNull((Object)asset);
        if (component != null) {
            return this.computeComponentPaths(asset, component);
        }
        return super.computeAssetPaths(asset, null).stream().filter(browsePaths -> !"-".equals(browsePaths.getDisplayName())).collect(Collectors.toList());
    }

    public List<BrowsePaths> computeComponentPaths(Asset asset, Component component) {
        return super.computeAssetPaths(asset, component).stream().filter(browsePath -> !"-".equals(browsePath.getDisplayName())).peek(browsePath -> {
            if ("manifests".equals(browsePath.getDisplayName())) {
                browsePath.setDisplayName("tags");
            }
        }).collect(Collectors.toList());
    }
}

