/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal.orient;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.elasticsearch.search.SearchHit;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.docker.internal.DockerDigest;

public class DockerAssetSearchSupport
extends ComponentSupport {
    @Nullable
    protected Map<String, Object> getSearchAssetMatchingContentDigest(SearchHit hit, DockerDigest digest) {
        List assets = (List)hit.getSource().get("assets");
        if (assets != null) {
            String digestValue = digest.toString();
            for (Map asset : assets) {
                try {
                    Map dockerAttributes;
                    Map attributes = (Map)asset.get("attributes");
                    if (attributes == null || (dockerAttributes = (Map)attributes.get("docker")) == null || !digestValue.equals(dockerAttributes.get("content_digest"))) continue;
                    return asset;
                }
                catch (ClassCastException ignore) {
                    this.log.trace("Search result has data in an unexpected format, ignoring", (Throwable)ignore);
                }
            }
        }
        return null;
    }
}

