/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal.httpclient;

import java.net.URI;
import java.net.URISyntaxException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.http.ProtocolException;
import org.apache.http.impl.client.DefaultRedirectStrategy;

@Named(value="docker")
@Singleton
public class DockerRedirectStrategy
extends DefaultRedirectStrategy {
    private boolean normalizeUrl;

    @Inject
    public DockerRedirectStrategy(@Named(value="${nexus.docker.redirect.strategy.normalizeUrl:-false}") @Named(value="${nexus.docker.redirect.strategy.normalizeUrl:-false}") boolean normalizeUrl) {
        this.normalizeUrl = normalizeUrl;
    }

    protected URI createLocationURI(String location) throws ProtocolException {
        return this.normalizeUrl ? super.createLocationURI(location) : this.toURI(location);
    }

    private URI toURI(String location) throws ProtocolException {
        try {
            return new URI(location);
        }
        catch (URISyntaxException ex) {
            throw new ProtocolException("Invalid redirect URI: " + location, (Throwable)ex);
        }
    }
}

