/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal.httpclient;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.impl.client.TargetAuthenticationStrategy;
import org.apache.http.protocol.HttpContext;

@Named(value="docker")
@Singleton
public class DockerAuthenticationStrategy
extends TargetAuthenticationStrategy {
    private static final String REQUEST_ATTRIBUTE = "http.request";
    private static final String BEARER_SCHEME = "Bearer";

    public Map<String, Header> getChallenges(HttpHost authhost, HttpResponse response, HttpContext context) throws MalformedChallengeException {
        HttpRequest request = (HttpRequest)context.getAttribute(REQUEST_ATTRIBUTE);
        if (request != null) {
            Optional<Header> bearerTokenRequestOpt = this.getBearerHeader((HttpMessage)request, "Authorization");
            Optional<Header> bearerTokenResponseOpt = this.getBearerHeader((HttpMessage)response, "WWW-Authenticate");
            if (bearerTokenRequestOpt.isPresent() && !bearerTokenResponseOpt.isPresent()) {
                response.addHeader("WWW-Authenticate", bearerTokenRequestOpt.get().getValue());
            }
        }
        return super.getChallenges(authhost, response, context);
    }

    private Optional<Header> getBearerHeader(HttpMessage message, String headerName) {
        return Arrays.stream(message.getHeaders(headerName)).filter(header -> header.getValue().startsWith(BEARER_SCHEME)).findAny();
    }
}

