/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal.datastore.upgrade;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.lifecycle.LifecycleSupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskScheduler;

@FeatureFlag(name="nexus.datastore.enabled")
@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
@Singleton
public class FixContentTypeTaskManager
extends LifecycleSupport
implements EventAware,
EventAware.Asynchronous {
    private final TaskScheduler taskScheduler;
    private final RepositoryManager repositoryManager;
    private boolean fixOnStart = false;

    @Inject
    public FixContentTypeTaskManager(TaskScheduler taskScheduler, RepositoryManager repositoryManager) {
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)taskScheduler);
        this.repositoryManager = repositoryManager;
    }

    public void setFixOnStart(boolean fixOnStart) {
        this.fixOnStart = fixOnStart;
    }

    protected void doStart() throws Exception {
        boolean existingTask;
        if (!this.fixOnStart) {
            return;
        }
        String repositoryNames = StreamSupport.stream(this.repositoryManager.browse().spliterator(), false).filter(this::isDockerHosted).map(Repository::getName).collect(Collectors.joining(","));
        if (!Strings2.isEmpty((String)repositoryNames) && !(existingTask = this.taskScheduler.findAndSubmit("docker.fix.content.type", (Map)ImmutableMap.of((Object)"repositoryName", (Object)repositoryNames)))) {
            this.launchNewTask(repositoryNames);
        }
    }

    private boolean isDockerHosted(Repository r) {
        return r.getFormat().getValue().equals("docker") && r.getType().getValue().equals("hosted");
    }

    private void launchNewTask(String repositoryNames) {
        TaskConfiguration configuration = this.taskScheduler.createTaskConfigurationInstance("docker.fix.content.type");
        configuration.setString("repositoryName", repositoryNames);
        configuration.setName("Fix metadata content type - (" + repositoryNames + ")");
        this.taskScheduler.submit(configuration);
    }
}

