/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal.datastore.upgrade;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobAttributes;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.logging.task.TaskLogType;
import org.sonatype.nexus.logging.task.TaskLogging;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.RepositoryTaskSupport;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.facet.ContentFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.store.AssetBlobStore;
import org.sonatype.nexus.repository.docker.internal.AssetKind;
import org.sonatype.nexus.repository.docker.internal.V2Manifest;
import org.sonatype.nexus.repository.docker.internal.datastore.recipe.V2ManifestUtilImpl;
import org.sonatype.nexus.scheduling.Cancelable;

@Named
@TaskLogging(value=TaskLogType.NEXUS_LOG_ONLY)
public class FixContentTypeTask
extends RepositoryTaskSupport
implements Cancelable {
    private static final int ASSET_BROWSE_LIMIT = 100;
    private final V2ManifestUtilImpl v2ManifestUtil;
    private final BlobStoreManager blobStoreManager;

    @Inject
    public FixContentTypeTask(V2ManifestUtilImpl v2ManifestUtil, BlobStoreManager blobStoreManager) {
        this.v2ManifestUtil = v2ManifestUtil;
        this.blobStoreManager = blobStoreManager;
    }

    protected void execute(Repository repository) {
        this.log.info("Checking metadata content types for {}", (Object)repository.getName());
        ContentFacetSupport contentFacet = (ContentFacetSupport)repository.facet(ContentFacet.class);
        AssetBlobStore assetBlobStore = contentFacet.stores().assetBlobStore;
        Continuation assets = contentFacet.assets().byKind(AssetKind.MANIFEST.name()).browse(100, null);
        while (!this.isCanceled() && !assets.isEmpty()) {
            assets.forEach(asset -> this.maybeFixContentType((AssetBlobStore<?>)assetBlobStore, (FluentAsset)asset));
            assets = contentFacet.assets().byKind(AssetKind.MANIFEST.name()).browse(100, assets.nextContinuationToken());
        }
    }

    @VisibleForTesting
    void maybeFixContentType(AssetBlobStore<?> assetBlobStore, FluentAsset asset) {
        asset.blob().ifPresent(assetBlob -> {
            BlobId blobId;
            Blob blob;
            BlobRef blobRef = assetBlob.blobRef();
            BlobStore blobStore = this.blobStoreManager.get(blobRef.getStore());
            if (blobStore != null && (blob = blobStore.get(blobId = blobRef.getBlobId())) != null) {
                try {
                    V2Manifest manifest = this.v2ManifestUtil.readManifest(() -> ((Blob)blob).getInputStream(), asset.path(), "application/json");
                    String manifestType = manifest.getMediaType();
                    if (!manifestType.equals(assetBlob.contentType())) {
                        this.log.info("Fixing content type {} {} -> {}", new Object[]{asset.path(), assetBlob.contentType(), manifestType});
                        assetBlobStore.setContentType(assetBlob, manifestType);
                        BlobAttributes blobAttributes = blobStore.getBlobAttributes(blobId);
                        blobAttributes.getProperties().setProperty("BlobStore.content-type", manifestType);
                        blobStore.setBlobAttributes(blobId, blobAttributes);
                    }
                }
                catch (IOException e) {
                    this.log.error("Unable to read manifest " + asset.path(), (Throwable)e);
                }
            }
        });
    }

    protected boolean appliesTo(Repository repository) {
        return true;
    }

    public String getMessage() {
        return this.getName();
    }
}

