/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal.datastore.upgrade;

import java.sql.Connection;
import java.sql.Statement;
import java.util.Optional;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.upgrade.datastore.DatabaseMigrationStep;

@Named
@Singleton
public class DockerUpgrade_1_2
extends ComponentSupport
implements DatabaseMigrationStep {
    private static final String DOCKER_ASSET = "DOCKER_ASSET";

    public Optional<String> version() {
        return Optional.of("1.2");
    }

    public void migrate(Connection connection) throws Exception {
        if (!this.tableExists(connection, DOCKER_ASSET)) {
            this.log.debug("Table {} doesn't exists. Upgrade step will be ignored.", (Object)DOCKER_ASSET);
            return;
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (Statement stmt = connection.createStatement();){
            int updates = stmt.executeUpdate(String.format("UPDATE %s SET KIND='BLOB'  WHERE PATH LIKE '%%blobs/%s' AND KIND='MANIFEST'", DOCKER_ASSET, "sha256:a3ed95caeb02ffe68cdd9fd84406680ae93d633cb16422d00e8a7c22955b46d4"));
            this.log.info("Updated {} misconfigured docker asset(s) in all repositories: set docker asset_kind='BLOB'", (Object)updates);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

