/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal.datastore.recipe;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Preconditions;
import com.google.common.io.CharStreams;
import groovy.json.JsonOutput;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.SoftReference;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.http.ParseException;
import org.apache.http.entity.ContentType;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.joda.time.DateTime;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.docker.internal.AssetKind;
import org.sonatype.nexus.repository.docker.internal.DockerDigest;
import org.sonatype.nexus.repository.docker.internal.DockerFacetUtils;
import org.sonatype.nexus.repository.docker.internal.MediaType;
import org.sonatype.nexus.repository.docker.internal.V2ContentTypes;
import org.sonatype.nexus.repository.docker.internal.V2Error;
import org.sonatype.nexus.repository.docker.internal.V2Exception;
import org.sonatype.nexus.repository.docker.internal.V2Manifest;
import org.sonatype.nexus.repository.docker.internal.V2ManifestConfig;
import org.sonatype.nexus.repository.docker.internal.V2ManifestConfigDowngrader;
import org.sonatype.nexus.repository.docker.internal.V2ManifestSchema1;
import org.sonatype.nexus.repository.docker.internal.V2ManifestSchema2;
import org.sonatype.nexus.repository.docker.internal.V2ManifestUtil;
import org.sonatype.nexus.repository.docker.internal.datastore.DockerContentFacet;
import org.sonatype.nexus.repository.docker.internal.datastore.recipe.DockerAssetSearch;
import org.sonatype.nexus.repository.docker.internal.datastore.recipe.DockerFacetDatabaseUtils;
import org.sonatype.nexus.repository.http.HttpStatus;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.ContentTypes;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;

@Named
public class V2ManifestUtilImpl
extends ComponentSupport
implements V2ManifestUtil,
GroovyObject {
    private static final byte[] EMPTY_BLOB_BYTES;
    private static final String SIGNATURE_BLOCK = "(?s),\\s*\"signatures\".*]";
    private static final ObjectMapper MAPPER;
    @Inject
    private V2ManifestConfigDowngrader v2ManifestConfigDowngrader;
    @Inject
    private DockerAssetSearch dockerAssetSearch;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public V2ManifestUtilImpl() {
        MetaClass metaClass;
        CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    static {
        byte[] byArray = (byte[])ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{31, 139, 8, 0, 0, 9, 110, 136, 0, 255, 98, 24, 5, 163, 96, 20, 140, 88, 0, 8, 0, 0, 255, 255, 46, 175, 181, 239, 0, 4, 0, 0}), byte[].class);
        EMPTY_BLOB_BYTES = byArray;
        Object object = V2ManifestUtilImpl.$getCallSiteArray()[0].callConstructor(ObjectMapper.class);
        MAPPER = (ObjectMapper)ScriptBytecodeAdapter.castToType((Object)object, ObjectMapper.class);
        V2ManifestUtilImpl.$getCallSiteArray()[1].call((Object)MAPPER, V2ManifestUtilImpl.$getCallSiteArray()[2].callGetProperty(SerializationFeature.class));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public V2Manifest readManifest(InputStreamSupplier manifestContent, String name, @Nullable String contentType) throws IOException {
        block11: {
            block9: {
                block10: {
                    var4_4 = V2ManifestUtilImpl.$getCallSiteArray();
                    var4_4[3].callStatic(Preconditions.class, (Object)manifestContent);
                    var4_4[4].callStatic(Preconditions.class, (Object)name);
                    var5_5 = contentType;
                    var4_4[5].call(var4_4[6].callGroovyObjectGetProperty((Object)this), (Object)"Parsing manifest {} of type {}", (Object)name, (Object)(DefaultTypeTransformation.booleanUnbox((Object)var5_5) != false ? var5_5 : "unspecified"));
                    manifest = (Map)ScriptBytecodeAdapter.castToType((Object)var4_4[7].call(var4_4[8].call((Object)manifestContent), (Object)new _readManifest_closure1(this, this)), Map.class);
                    schemaVersion = var4_4[9].call((Object)manifest, (Object)"schemaVersion");
                    v2Manifest = null;
                    if (!ScriptBytecodeAdapter.compareEqual((Object)var4_4[10].callGetProperty(V2Manifest.class), (Object)schemaVersion)) break block10;
                    if (DefaultTypeTransformation.booleanUnbox((Object)var4_4[11].call((Object)manifest, (Object)"signatures"))) {
                        var9_9 = var4_4[12].callConstructor(V2Manifest.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"schemaVersion", var4_4[13].callGetProperty(V2Manifest.SchemaVersion.class), "mediaType", var4_4[14].callGetProperty(V2ContentTypes.class), "manifest", manifest}));
                        v2Manifest = (V2Manifest)ScriptBytecodeAdapter.castToType((Object)var9_9, V2Manifest.class);
                    } else {
                        var10_10 = var4_4[15].callConstructor(V2Manifest.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"schemaVersion", var4_4[16].callGetProperty(V2Manifest.SchemaVersion.class), "mediaType", var4_4[17].callGetProperty(V2ContentTypes.class), "manifest", manifest}));
                        v2Manifest = (V2Manifest)ScriptBytecodeAdapter.castToType((Object)var10_10, V2Manifest.class);
                    }
                    ** GOTO lbl49
                }
                if (!ScriptBytecodeAdapter.compareEqual((Object)var4_4[18].callGetProperty(V2Manifest.class), (Object)schemaVersion)) ** GOTO lbl48
                if (!(DefaultTypeTransformation.booleanUnbox((Object)var4_4[19].call((Object)manifest, (Object)"mediaType")) != false && DefaultTypeTransformation.booleanUnbox((Object)var4_4[20].call(var4_4[21].callGetProperty(MediaType.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)var4_4[22].call((Object)manifest, (Object)"mediaType"), String.class)), String.class))) != false)) break block9;
                mediaType = ShortTypeHandling.castToString((Object)var4_4[23].callCurrent((GroovyObject)this, (Object)contentType, (Object)manifest, var4_4[24].callGetProperty(MediaType.class)));
                var12_12 = var4_4[25].callConstructor(V2Manifest.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"schemaVersion", var4_4[26].callGetProperty(V2Manifest.SchemaVersion.class), "mediaType", mediaType, "manifest", manifest, "layers", ScriptBytecodeAdapter.createList((Object[])new Object[0])}));
                v2Manifest = (V2Manifest)ScriptBytecodeAdapter.castToType((Object)var12_12, V2Manifest.class);
                var13_13 = v2Manifest;
                return var13_13;
            }
            mediaType = ShortTypeHandling.castToString((Object)var4_4[27].callCurrent((GroovyObject)this, (Object)contentType, (Object)manifest, var4_4[28].callGetProperty(MediaType.class)));
            var15_15 = var4_4[29].callConstructor(V2Manifest.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"schemaVersion", var4_4[30].callGetProperty(V2Manifest.SchemaVersion.class), "mediaType", mediaType, "manifest", manifest}));
            v2Manifest = (V2Manifest)ScriptBytecodeAdapter.castToType((Object)var15_15, V2Manifest.class);
            break block11;
lbl48:
            // 1 sources

            throw (Throwable)var4_4[31].callConstructor(V2Exception.ManifestInvalid.class, (Object)new GStringImpl(new Object[]{name, schemaVersion}, new String[]{"Invalid manifest ", ": unknown 'schemaVersion' ", ""}));
        }
        var16_16 = var4_4[32].call((Object)V2ManifestUtilImpl.MAPPER, var4_4[33].call((Object)V2ManifestUtilImpl.MAPPER, var4_4[34].call((Object)manifest, (Object)(ScriptBytecodeAdapter.compareEqual((Object)var4_4[35].callGetProperty(V2Manifest.class), (Object)schemaVersion) != false ? "fsLayers" : "layers"))), var4_4[36].callGetProperty(DockerFacetUtils.class));
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)var16_16, V2ManifestUtilImpl.class, (GroovyObject)v2Manifest, (String)"layers");
        var17_17 = v2Manifest;
        try {
            return var17_17;
        }
        catch (JsonProcessingException e) {
            var4_4[37].call(var4_4[38].callGroovyObjectGetProperty((Object)this), (Object)"Parsing manifest {} failed, due to processing exception", (Object)name, (Object)e);
            throw (Throwable)var4_4[39].callConstructor(V2Exception.ManifestInvalid.class, (Object)new GStringImpl(new Object[]{name, var4_4[40].call((Object)e)}, new String[]{"Corrupt manifest ", ": ", ""}));
        }
    }

    private String resolveMediaType(String contentType, Map<String, Object> manifest, MediaType mediaType) {
        String type;
        block6: {
            CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
            type = contentType;
            try {
                ContentType parsedType = (ContentType)ScriptBytecodeAdapter.castToType((Object)callSiteArray[41].call(ContentType.class, (Object)contentType), ContentType.class);
                if (!ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[42].callGetProperty((Object)parsedType), (Object)callSiteArray[43].callGetProperty(ContentTypes.class))) break block6;
                Object object = callSiteArray[44].callGetPropertySafe(manifest);
                String manifestMediaType = ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : callSiteArray[45].callGetPropertySafe(callSiteArray[46].callGetProperty(manifest))));
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[47].callSafe((Object)manifestMediaType, (Object)"application/vnd.docker"))) {
                    Object object2 = callSiteArray[48].callGetProperty((Object)mediaType);
                    type = ShortTypeHandling.castToString((Object)object2);
                    break block6;
                }
                Object object3 = callSiteArray[49].callGetProperty((Object)mediaType);
                type = ShortTypeHandling.castToString((Object)object3);
            }
            catch (ParseException e) {
                callSiteArray[50].call(callSiteArray[51].callGroovyObjectGetProperty((Object)this), (Object)"Invalid contentType {}", (Object)contentType);
            }
            catch (UnsupportedCharsetException e) {
                callSiteArray[52].call(callSiteArray[53].callGroovyObjectGetProperty((Object)this), (Object)"Invalid contentType {}", (Object)contentType);
            }
        }
        return type;
    }

    @Override
    public Content mayDowngrade(Content manifestContent, String name, String tag, V2Manifest.SchemaVersion clientPreference, Repository repository) throws IOException {
        CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
        callSiteArray[54].call(callSiteArray[55].callGroovyObjectGetProperty((Object)this), (Object)"Downgrade manifest check on {}:{}", (Object)name, (Object)tag);
        V2Manifest manifest = (V2Manifest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[56].callCurrent((GroovyObject)this, (Object)manifestContent, (Object)name), V2Manifest.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[57].callStatic(V2ManifestUtilImpl.class, (Object)clientPreference, (Object)manifest))) {
            callSiteArray[58].call(callSiteArray[59].callGroovyObjectGetProperty((Object)this), (Object)"Downgrading manifest on {}:{} based on client preference", (Object)name, (Object)tag);
            V2ManifestSchema2 schemaV2 = (V2ManifestSchema2)ScriptBytecodeAdapter.castToType((Object)callSiteArray[60].callConstructor(V2ManifestSchema2.class, callSiteArray[61].callGroovyObjectGetProperty((Object)manifest)), V2ManifestSchema2.class);
            V2ManifestConfig config = (V2ManifestConfig)ScriptBytecodeAdapter.castToType((Object)callSiteArray[62].callStatic(V2ManifestUtilImpl.class, (Object)schemaV2, (Object)repository), V2ManifestConfig.class);
            callSiteArray[63].callCurrent((GroovyObject)this, (Object)config, (Object)repository);
            V2ManifestSchema1 downgradedManifest = (V2ManifestSchema1)ScriptBytecodeAdapter.castToType((Object)callSiteArray[64].call((Object)this.v2ManifestConfigDowngrader, (Object)config, (Object)schemaV2, (Object)name, (Object)tag), V2ManifestSchema1.class);
            callSiteArray[65].call(callSiteArray[66].callGroovyObjectGetProperty((Object)this), (Object)"Downgraded manifest = {}", callSiteArray[67].call(JsonOutput.class, callSiteArray[68].call(JsonOutput.class, (Object)downgradedManifest)));
            Content content = (Content)ScriptBytecodeAdapter.castToType((Object)callSiteArray[69].callConstructor(Content.class, callSiteArray[70].callConstructor(BytesPayload.class, callSiteArray[71].call((Object)MAPPER, (Object)downgradedManifest), callSiteArray[72].callGetProperty(V2ContentTypes.class))), Content.class);
            callSiteArray[73].call(callSiteArray[74].callGetProperty((Object)content), CacheInfo.class, callSiteArray[75].callConstructor(CacheInfo.class, callSiteArray[76].call(DateTime.class), null));
            return content;
        }
        callSiteArray[77].call(callSiteArray[78].callGroovyObjectGetProperty((Object)this), (Object)"Downgrade not needed on {}:{}", (Object)name, (Object)tag);
        return manifestContent;
    }

    @Override
    public DockerDigest manifestDigest(InputStreamSupplier manifestContent) throws IOException {
        CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
        public final class _manifestDigest_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _manifestDigest_closure2(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _manifestDigest_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(InputStream inputStream) {
                CallSite[] callSiteArray = _manifestDigest_closure2.$getCallSiteArray();
                String manifest = ShortTypeHandling.castToString((Object)callSiteArray[0].call(CharStreams.class, callSiteArray[1].callConstructor(InputStreamReader.class, (Object)inputStream, callSiteArray[2].callGetProperty(StandardCharsets.class))));
                Object object = callSiteArray[3].call(callSiteArray[4].call((Object)manifest, callSiteArray[5].call(ScriptBytecodeAdapter.getField(_manifestDigest_closure2.class, V2ManifestUtilImpl.class, (String)"SIGNATURE_BLOCK"), (Object)"\n\n"), (Object)"\n"), ScriptBytecodeAdapter.getField(_manifestDigest_closure2.class, V2ManifestUtilImpl.class, (String)"SIGNATURE_BLOCK"), (Object)"");
                manifest = ShortTypeHandling.castToString((Object)object);
                return callSiteArray[6].callConstructor(DockerDigest.class, callSiteArray[7].call(callSiteArray[8].callGetProperty(DockerFacetUtils.class)), callSiteArray[9].call(callSiteArray[10].call(callSiteArray[11].call(callSiteArray[12].callGetProperty(DockerFacetUtils.class)), (Object)manifest, callSiteArray[13].callGetProperty(StandardCharsets.class))));
            }

            @Generated
            public Object call(InputStream inputStream) {
                CallSite[] callSiteArray = _manifestDigest_closure2.$getCallSiteArray();
                return callSiteArray[14].callCurrent((GroovyObject)this, (Object)inputStream);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _manifestDigest_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "toString";
                stringArray[1] = "<$constructor$>";
                stringArray[2] = "UTF_8";
                stringArray[3] = "replaceAll";
                stringArray[4] = "replaceAll";
                stringArray[5] = "plus";
                stringArray[6] = "<$constructor$>";
                stringArray[7] = "name";
                stringArray[8] = "DOCKER_DIGEST_ALGORITHM";
                stringArray[9] = "toString";
                stringArray[10] = "hashString";
                stringArray[11] = "function";
                stringArray[12] = "DOCKER_DIGEST_ALGORITHM";
                stringArray[13] = "UTF_8";
                stringArray[14] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[15];
                _manifestDigest_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_manifestDigest_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _manifestDigest_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (DockerDigest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[79].call(callSiteArray[80].call((Object)manifestContent), (Object)new _manifestDigest_closure2(this, this)), DockerDigest.class);
    }

    @Override
    public Map<String, DockerDigest> multipleManifestDigest(InputStreamSupplier manifestContent) throws IOException {
        Reference manifestContent2 = new Reference((Object)manifestContent);
        CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
        public final class _multipleManifestDigest_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference manifestContent;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _multipleManifestDigest_closure3(Object _outerInstance, Object _thisObject, Reference manifestContent) {
                Reference reference;
                CallSite[] callSiteArray = _multipleManifestDigest_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.manifestContent = reference = manifestContent;
            }

            public Object doCall(InputStream inputStream) {
                CallSite[] callSiteArray = _multipleManifestDigest_closure3.$getCallSiteArray();
                String manifest = ShortTypeHandling.castToString((Object)callSiteArray[0].call(CharStreams.class, callSiteArray[1].callConstructor(InputStreamReader.class, (Object)inputStream, callSiteArray[2].callGetProperty(StandardCharsets.class))));
                Map dockerDigests = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].callConstructor(HashMap.class), Map.class);
                callSiteArray[4].call((Object)dockerDigests, callSiteArray[5].callGroovyObjectGetProperty((Object)this), callSiteArray[6].callConstructor(DockerDigest.class, callSiteArray[7].call(callSiteArray[8].callGetProperty(DockerFacetUtils.class)), callSiteArray[9].call(callSiteArray[10].call(callSiteArray[11].call(callSiteArray[12].callGetProperty(DockerFacetUtils.class)), (Object)manifest, callSiteArray[13].callGetProperty(StandardCharsets.class)))));
                callSiteArray[14].call((Object)dockerDigests, callSiteArray[15].callGroovyObjectGetProperty((Object)this), callSiteArray[16].callCurrent((GroovyObject)this, this.manifestContent.get()));
                return dockerDigests;
            }

            @Generated
            public Object call(InputStream inputStream) {
                CallSite[] callSiteArray = _multipleManifestDigest_closure3.$getCallSiteArray();
                return callSiteArray[17].callCurrent((GroovyObject)this, (Object)inputStream);
            }

            @Generated
            public InputStreamSupplier getManifestContent() {
                CallSite[] callSiteArray = _multipleManifestDigest_closure3.$getCallSiteArray();
                return (InputStreamSupplier)ScriptBytecodeAdapter.castToType((Object)this.manifestContent.get(), InputStreamSupplier.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _multipleManifestDigest_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "toString";
                stringArray[1] = "<$constructor$>";
                stringArray[2] = "UTF_8";
                stringArray[3] = "<$constructor$>";
                stringArray[4] = "put";
                stringArray[5] = "DEFAULT_DIGEST";
                stringArray[6] = "<$constructor$>";
                stringArray[7] = "name";
                stringArray[8] = "DOCKER_DIGEST_ALGORITHM";
                stringArray[9] = "toString";
                stringArray[10] = "hashString";
                stringArray[11] = "function";
                stringArray[12] = "DOCKER_DIGEST_ALGORITHM";
                stringArray[13] = "UTF_8";
                stringArray[14] = "put";
                stringArray[15] = "SIGNATURE_REPLACED_DIGEST";
                stringArray[16] = "manifestDigest";
                stringArray[17] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[18];
                _multipleManifestDigest_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_multipleManifestDigest_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _multipleManifestDigest_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[81].call(callSiteArray[82].call((Object)((InputStreamSupplier)manifestContent2.get())), (Object)new _multipleManifestDigest_closure3(this, this, manifestContent2)), Map.class);
    }

    @Override
    public boolean shouldDowngrade(Content manifestContent, String name, V2Manifest.SchemaVersion clientPreference) throws IOException {
        Reference manifestContent2 = new Reference((Object)manifestContent);
        CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
        public final class _shouldDowngrade_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference manifestContent;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _shouldDowngrade_closure4(Object _outerInstance, Object _thisObject, Reference manifestContent) {
                Reference reference;
                CallSite[] callSiteArray = _shouldDowngrade_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.manifestContent = reference = manifestContent;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _shouldDowngrade_closure4.$getCallSiteArray();
                return callSiteArray[0].call(this.manifestContent.get());
            }

            @Generated
            public Content getManifestContent() {
                CallSite[] callSiteArray = _shouldDowngrade_closure4.$getCallSiteArray();
                return (Content)ScriptBytecodeAdapter.castToType((Object)this.manifestContent.get(), Content.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _shouldDowngrade_closure4.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _shouldDowngrade_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "openInputStream";
                return new CallSiteArray(_shouldDowngrade_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _shouldDowngrade_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        InputStreamSupplier inputStreamSupplier = (InputStreamSupplier)ScriptBytecodeAdapter.castToType((Object)((Object)new _shouldDowngrade_closure4(this, this, manifestContent2)), InputStreamSupplier.class);
        V2Manifest manifest = (V2Manifest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[83].callCurrent((GroovyObject)this, (Object)inputStreamSupplier, (Object)name, callSiteArray[84].callGetProperty((Object)((Content)manifestContent2.get()))), V2Manifest.class);
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[85].callStatic(V2ManifestUtilImpl.class, (Object)clientPreference, (Object)manifest));
    }

    @Override
    public DockerDigest findConfigDigest(Content manifestContent, String name) {
        CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
        V2Manifest manifest = (V2Manifest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[86].callCurrent((GroovyObject)this, (Object)manifestContent, (Object)name), V2Manifest.class);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[87].callGroovyObjectGetProperty((Object)manifest), (Object)callSiteArray[88].callGetProperty(V2Manifest.SchemaVersion.class))) {
            throw (Throwable)callSiteArray[89].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{callSiteArray[90].callGroovyObjectGetProperty((Object)manifest)}, new String[]{"Config file is not specified in schemaVersion: ", ""}));
        }
        V2ManifestSchema2 schemaV2 = (V2ManifestSchema2)ScriptBytecodeAdapter.castToType((Object)callSiteArray[91].callConstructor(V2ManifestSchema2.class, callSiteArray[92].callGroovyObjectGetProperty((Object)manifest)), V2ManifestSchema2.class);
        return (DockerDigest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[93].call(DockerDigest.class, callSiteArray[94].callGetProperty(callSiteArray[95].callGroovyObjectGetProperty((Object)schemaV2))), DockerDigest.class);
    }

    @Override
    public void validateManifest(Repository repository, String name, @Nullable String tag, V2Manifest v2Manifest) {
        CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
        List validationErrors = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[96].callConstructor(ArrayList.class), List.class);
        callSiteArray[97].call((Object)v2Manifest, (Object)validationErrors, (Object)name, (Object)tag);
        List digests = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[98].call((Object)v2Manifest), List.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[99].call((Object)digests))) {
            DockerDigest digest = null;
            Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[100].call((Object)digests), Iterator.class);
            while (iterator.hasNext()) {
                digest = (DockerDigest)ScriptBytecodeAdapter.castToType(iterator.next(), DockerDigest.class);
                Optional layerAsset = (Optional)ScriptBytecodeAdapter.castToType((Object)callSiteArray[101].call(DockerFacetDatabaseUtils.class, (Object)repository, callSiteArray[102].callStatic(DockerFacetDatabaseUtils.class, callSiteArray[103].callStatic(DockerFacetUtils.class, (Object)digest))), Optional.class);
                Optional manifestAsset = (Optional)ScriptBytecodeAdapter.castToType((Object)callSiteArray[104].call(DockerFacetDatabaseUtils.class, (Object)repository, callSiteArray[105].callStatic(DockerFacetDatabaseUtils.class, callSiteArray[106].callStatic(DockerFacetUtils.class, (Object)name, (Object)digest))), Optional.class);
                if (!(!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[107].call((Object)layerAsset)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[108].call((Object)manifestAsset)))) continue;
                callSiteArray[109].call(callSiteArray[110].callGroovyObjectGetProperty((Object)this), ArrayUtil.createArray((Object)"Manifest refers to missing layer: {} for: {}/{} in repository {}", (Object)digest, (Object)name, (Object)tag, (Object)repository));
                callSiteArray[111].call((Object)validationErrors, callSiteArray[112].call(callSiteArray[113].callGetProperty(V2Error.class), callSiteArray[114].call((Object)digest)));
            }
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[115].call((Object)validationErrors))) {
            throw (Throwable)callSiteArray[116].callConstructor(V2Exception.class, (Object)"Invalid Manifest", callSiteArray[117].callGetProperty(HttpStatus.class), (Object)validationErrors);
        }
    }

    public void insertEmptyLayerIfNeeded(V2ManifestConfig config, Repository repository) {
        CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
        public final class _insertEmptyLayerIfNeeded_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _insertEmptyLayerIfNeeded_closure5(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _insertEmptyLayerIfNeeded_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _insertEmptyLayerIfNeeded_closure5.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(it), (Object)"empty_layer");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _insertEmptyLayerIfNeeded_closure5.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _insertEmptyLayerIfNeeded_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "contains";
                stringArray[1] = "keySet";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _insertEmptyLayerIfNeeded_closure5.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_insertEmptyLayerIfNeeded_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _insertEmptyLayerIfNeeded_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[118].call(callSiteArray[119].callGroovyObjectGetProperty((Object)config), (Object)new _insertEmptyLayerIfNeeded_closure5(this, this)))) {
            DockerContentFacet dockerContentFacet = (DockerContentFacet)ScriptBytecodeAdapter.castToType((Object)callSiteArray[120].call((Object)repository, DockerContentFacet.class), DockerContentFacet.class);
            Object emptyBlobDigest = callSiteArray[121].call(DockerDigest.class, callSiteArray[122].callGroovyObjectGetProperty((Object)this));
            Object emptyBlob = callSiteArray[123].call((Object)dockerContentFacet, callSiteArray[124].callStatic(DockerFacetDatabaseUtils.class, callSiteArray[125].callStatic(DockerFacetUtils.class, emptyBlobDigest)));
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[126].call(emptyBlob))) {
                callSiteArray[127].call((Object)dockerContentFacet, emptyBlobDigest, callSiteArray[128].callConstructor(Content.class, callSiteArray[129].callConstructor(BytesPayload.class, (Object)EMPTY_BLOB_BYTES, callSiteArray[130].callGetProperty(V2ContentTypes.class))), callSiteArray[131].callGetProperty(AssetKind.class), callSiteArray[132].callConstructor(HashMap.class));
            }
        }
    }

    public static V2ManifestConfig loadConfigurationFile(V2ManifestSchema2 schemaV2, Repository repository) {
        CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
        DockerContentFacet dockerContentFacet = (DockerContentFacet)ScriptBytecodeAdapter.castToType((Object)callSiteArray[133].call((Object)repository, DockerContentFacet.class), DockerContentFacet.class);
        DockerDigest digest = (DockerDigest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[134].call(DockerDigest.class, callSiteArray[135].callGetProperty(callSiteArray[136].callGroovyObjectGetProperty((Object)schemaV2))), DockerDigest.class);
        FluentAsset configAsset = (FluentAsset)ScriptBytecodeAdapter.castToType((Object)callSiteArray[137].call((Object)dockerContentFacet, (Object)digest), FluentAsset.class);
        if (ScriptBytecodeAdapter.compareEqual((Object)configAsset, null)) {
            throw (Throwable)callSiteArray[138].callConstructor(V2Exception.BlobNotFound.class, (Object)digest);
        }
        return (V2ManifestConfig)ScriptBytecodeAdapter.castToType((Object)callSiteArray[139].call((Object)MAPPER, callSiteArray[140].call(callSiteArray[141].call((Object)configAsset)), V2ManifestConfig.class), V2ManifestConfig.class);
    }

    private V2Manifest readManifestContent(Content manifestContent, String name) {
        Reference manifestContent2 = new Reference((Object)manifestContent);
        CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
        public final class _readManifestContent_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference manifestContent;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _readManifestContent_closure6(Object _outerInstance, Object _thisObject, Reference manifestContent) {
                Reference reference;
                CallSite[] callSiteArray = _readManifestContent_closure6.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.manifestContent = reference = manifestContent;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _readManifestContent_closure6.$getCallSiteArray();
                return callSiteArray[0].call(this.manifestContent.get());
            }

            @Generated
            public Content getManifestContent() {
                CallSite[] callSiteArray = _readManifestContent_closure6.$getCallSiteArray();
                return (Content)ScriptBytecodeAdapter.castToType((Object)this.manifestContent.get(), Content.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _readManifestContent_closure6.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _readManifestContent_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "openInputStream";
                return new CallSiteArray(_readManifestContent_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _readManifestContent_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        InputStreamSupplier inputStreamSupplier = (InputStreamSupplier)ScriptBytecodeAdapter.castToType((Object)((Object)new _readManifestContent_closure6(this, this, manifestContent2)), InputStreamSupplier.class);
        return (V2Manifest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[142].callCurrent((GroovyObject)this, (Object)inputStreamSupplier, (Object)name, callSiteArray[143].callGetProperty((Object)((Content)manifestContent2.get()))), V2Manifest.class);
    }

    private static boolean downgradeRequired(V2Manifest.SchemaVersion clientPreference, V2Manifest manifest) {
        CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[144].callGetProperty(V2Manifest.SchemaVersion.class), (Object)((Object)clientPreference)) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[145].callGetProperty(V2Manifest.SchemaVersion.class), (Object)callSiteArray[146].callGroovyObjectGetProperty((Object)manifest)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[147].call(callSiteArray[148].callGetProperty(MediaType.class), callSiteArray[149].callGroovyObjectGetProperty((Object)manifest))) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[150].call(callSiteArray[151].callGetProperty(V2ContentTypes.class), callSiteArray[152].callGroovyObjectGetProperty((Object)manifest)));
        }
        return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[153].callGetProperty(V2Manifest.SchemaVersion.class), (Object)((Object)clientPreference)) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[154].callGetProperty(V2Manifest.SchemaVersion.class), (Object)callSiteArray[155].callGroovyObjectGetProperty((Object)manifest)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[156].call(callSiteArray[157].callGetProperty(MediaType.class), callSiteArray[158].callGroovyObjectGetProperty((Object)manifest))) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[159].call(callSiteArray[160].callGetProperty(V2ContentTypes.class), callSiteArray[161].callGroovyObjectGetProperty((Object)manifest)));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != V2ManifestUtilImpl.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public static ObjectMapper getMAPPER() {
        return MAPPER;
    }

    @Generated
    public V2ManifestConfigDowngrader getV2ManifestConfigDowngrader() {
        return this.v2ManifestConfigDowngrader;
    }

    @Generated
    public void setV2ManifestConfigDowngrader(V2ManifestConfigDowngrader v2ManifestConfigDowngrader) {
        this.v2ManifestConfigDowngrader = v2ManifestConfigDowngrader;
    }

    @Generated
    public DockerAssetSearch getDockerAssetSearch() {
        return this.dockerAssetSearch;
    }

    @Generated
    public void setDockerAssetSearch(DockerAssetSearch dockerAssetSearch) {
        this.dockerAssetSearch = dockerAssetSearch;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "enable";
        stringArray[2] = "INDENT_OUTPUT";
        stringArray[3] = "checkNotNull";
        stringArray[4] = "checkNotNull";
        stringArray[5] = "debug";
        stringArray[6] = "log";
        stringArray[7] = "withStream";
        stringArray[8] = "get";
        stringArray[9] = "getAt";
        stringArray[10] = "V2_MANIFEST_SCHEMA1_VERSION";
        stringArray[11] = "containsKey";
        stringArray[12] = "<$constructor$>";
        stringArray[13] = "Schema1";
        stringArray[14] = "V2_MANIFEST_SCHEMA_1_SIGNED";
        stringArray[15] = "<$constructor$>";
        stringArray[16] = "Schema1";
        stringArray[17] = "V2_MANIFEST_SCHEMA_1";
        stringArray[18] = "V2_MANIFEST_SCHEMA2_VERSION";
        stringArray[19] = "containsKey";
        stringArray[20] = "matches";
        stringArray[21] = "IMAGE_INDEX";
        stringArray[22] = "get";
        stringArray[23] = "resolveMediaType";
        stringArray[24] = "IMAGE_INDEX";
        stringArray[25] = "<$constructor$>";
        stringArray[26] = "Schema2";
        stringArray[27] = "resolveMediaType";
        stringArray[28] = "IMAGE_MANIFEST";
        stringArray[29] = "<$constructor$>";
        stringArray[30] = "Schema2";
        stringArray[31] = "<$constructor$>";
        stringArray[32] = "readValue";
        stringArray[33] = "writeValueAsString";
        stringArray[34] = "get";
        stringArray[35] = "V2_MANIFEST_SCHEMA1_VERSION";
        stringArray[36] = "DOCKER_LAYERS_TYPE_REF";
        stringArray[37] = "debug";
        stringArray[38] = "log";
        stringArray[39] = "<$constructor$>";
        stringArray[40] = "getMessage";
        stringArray[41] = "parse";
        stringArray[42] = "mimeType";
        stringArray[43] = "APPLICATION_JSON";
        stringArray[44] = "mediaType";
        stringArray[45] = "mediaType";
        stringArray[46] = "config";
        stringArray[47] = "startsWith";
        stringArray[48] = "dockerMediaType";
        stringArray[49] = "ociMediaType";
        stringArray[50] = "warn";
        stringArray[51] = "log";
        stringArray[52] = "warn";
        stringArray[53] = "log";
        stringArray[54] = "debug";
        stringArray[55] = "log";
        stringArray[56] = "readManifestContent";
        stringArray[57] = "downgradeRequired";
        stringArray[58] = "debug";
        stringArray[59] = "log";
        stringArray[60] = "<$constructor$>";
        stringArray[61] = "manifest";
        stringArray[62] = "loadConfigurationFile";
        stringArray[63] = "insertEmptyLayerIfNeeded";
        stringArray[64] = "downgrade";
        stringArray[65] = "debug";
        stringArray[66] = "log";
        stringArray[67] = "prettyPrint";
        stringArray[68] = "toJson";
        stringArray[69] = "<$constructor$>";
        stringArray[70] = "<$constructor$>";
        stringArray[71] = "writeValueAsBytes";
        stringArray[72] = "V2_MANIFEST_SCHEMA_1";
        stringArray[73] = "set";
        stringArray[74] = "attributes";
        stringArray[75] = "<$constructor$>";
        stringArray[76] = "now";
        stringArray[77] = "debug";
        stringArray[78] = "log";
        stringArray[79] = "withCloseable";
        stringArray[80] = "get";
        stringArray[81] = "withCloseable";
        stringArray[82] = "get";
        stringArray[83] = "readManifest";
        stringArray[84] = "contentType";
        stringArray[85] = "downgradeRequired";
        stringArray[86] = "readManifestContent";
        stringArray[87] = "schemaVersion";
        stringArray[88] = "Schema2";
        stringArray[89] = "<$constructor$>";
        stringArray[90] = "schemaVersion";
        stringArray[91] = "<$constructor$>";
        stringArray[92] = "manifest";
        stringArray[93] = "parse";
        stringArray[94] = "digest";
        stringArray[95] = "config";
        stringArray[96] = "<$constructor$>";
        stringArray[97] = "validateManifest";
        stringArray[98] = "referencedDigests";
        stringArray[99] = "isEmpty";
        stringArray[100] = "iterator";
        stringArray[101] = "findAsset";
        stringArray[102] = "assetPath";
        stringArray[103] = "blobName";
        stringArray[104] = "findAsset";
        stringArray[105] = "assetPath";
        stringArray[106] = "manifestName";
        stringArray[107] = "isPresent";
        stringArray[108] = "isPresent";
        stringArray[109] = "error";
        stringArray[110] = "log";
        stringArray[111] = "add";
        stringArray[112] = "withDetail";
        stringArray[113] = "BLOB_UNKNOWN";
        stringArray[114] = "toString";
        stringArray[115] = "isEmpty";
        stringArray[116] = "<$constructor$>";
        stringArray[117] = "BAD_REQUEST";
        stringArray[118] = "any";
        stringArray[119] = "history";
        stringArray[120] = "facet";
        stringArray[121] = "parse";
        stringArray[122] = "EMPTY_BLOB_DIGEST";
        stringArray[123] = "get";
        stringArray[124] = "assetPath";
        stringArray[125] = "blobName";
        stringArray[126] = "isPresent";
        stringArray[127] = "putBlob";
        stringArray[128] = "<$constructor$>";
        stringArray[129] = "<$constructor$>";
        stringArray[130] = "V2_BLOB_IMAGE_LAYER";
        stringArray[131] = "BLOB";
        stringArray[132] = "<$constructor$>";
        stringArray[133] = "facet";
        stringArray[134] = "parse";
        stringArray[135] = "digest";
        stringArray[136] = "config";
        stringArray[137] = "findAssetByContentDigest";
        stringArray[138] = "<$constructor$>";
        stringArray[139] = "readValue";
        stringArray[140] = "openInputStream";
        stringArray[141] = "download";
        stringArray[142] = "readManifest";
        stringArray[143] = "contentType";
        stringArray[144] = "Schema1";
        stringArray[145] = "Schema2";
        stringArray[146] = "schemaVersion";
        stringArray[147] = "matches";
        stringArray[148] = "IMAGE_INDEX";
        stringArray[149] = "mediaType";
        stringArray[150] = "equals";
        stringArray[151] = "OCI_IMAGE_MANIFEST_V1";
        stringArray[152] = "mediaType";
        stringArray[153] = "Schema1";
        stringArray[154] = "Schema2";
        stringArray[155] = "schemaVersion";
        stringArray[156] = "matches";
        stringArray[157] = "IMAGE_INDEX";
        stringArray[158] = "mediaType";
        stringArray[159] = "equals";
        stringArray[160] = "OCI_IMAGE_MANIFEST_V1";
        stringArray[161] = "mediaType";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[162];
        V2ManifestUtilImpl.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(V2ManifestUtilImpl.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = V2ManifestUtilImpl.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

