/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal.datastore.recipe;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.hash.Hashes;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.docker.datastore.restore.DockerRestoreFacet;
import org.sonatype.nexus.repository.docker.internal.AssetKind;
import org.sonatype.nexus.repository.docker.internal.DockerDigest;
import org.sonatype.nexus.repository.docker.internal.DockerFacetUtils;
import org.sonatype.nexus.repository.docker.internal.V2Exception;
import org.sonatype.nexus.repository.docker.internal.V2ManifestUtil;
import org.sonatype.nexus.repository.docker.internal.datastore.DockerContentFacet;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.DetachedBlobPayload;

@Named
public class DockerRestoreFacetImpl
extends FacetSupport
implements DockerRestoreFacet {
    private final V2ManifestUtil v2ManifestUtil;
    private DockerContentFacet dockerContentFacet;

    @Inject
    public DockerRestoreFacetImpl(V2ManifestUtil v2ManifestUtil) {
        this.v2ManifestUtil = (V2ManifestUtil)Preconditions.checkNotNull((Object)v2ManifestUtil);
    }

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        this.dockerContentFacet = (DockerContentFacet)this.facet(DockerContentFacet.class);
    }

    @Override
    public void restoreV2Blob(String blobName, Blob blob) {
        this.dockerContentFacet.putBlob(DockerRestoreFacetImpl.digestFromPath(blobName, blob), DockerRestoreFacetImpl.payload(blob), AssetKind.BLOB, new HashMap<String, Object>());
    }

    @Override
    public void restoreV2Manifest(String blobName, Blob blob, String name) {
        this.dockerContentFacet.putManifestByDigest(name, DockerRestoreFacetImpl.digestFromPath(blobName, blob), DockerRestoreFacetImpl.payload(blob));
    }

    @Override
    public void restoreV2Tag(Blob blob, String name, String tag) {
        DockerDigest digest = this.getManifestDigest(name, blob);
        this.dockerContentFacet.putManifestByTag(name, tag, digest, DockerRestoreFacetImpl.payload(blob));
    }

    @Override
    public void restoreV2Catalog(String blobName, Blob blob) {
        this.dockerContentFacet.putHardLinkedBlob(blobName, DockerRestoreFacetImpl.payload(blob), AssetKind.CATALOG, new HashMap<String, Object>());
    }

    @Override
    public void restoreV2TagsList(String blobName, Blob blob) {
        this.dockerContentFacet.putHardLinkedBlob(blobName, DockerRestoreFacetImpl.payload(blob), AssetKind.TAG_LIST, new HashMap<String, Object>());
    }

    @Override
    public void restoreV1Image(String blobName, Blob blob) {
        this.dockerContentFacet.putHardLinkedBlob(blobName, DockerRestoreFacetImpl.payload(blob), AssetKind.IMAGES, new HashMap<String, Object>());
    }

    @Override
    public void restoreV1LayerMetadata(String blobName, Blob blob, String layerId, String type) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        try {
            Map<String, Object> layerMetadata = DockerFacetUtils.readLayerMetadata(() -> ((Blob)blob).getInputStream());
            attributes.put("parent", layerMetadata.get("parent"));
            attributes.put("layerId", layerId);
            this.dockerContentFacet.putHardLinkedBlob(blobName, DockerRestoreFacetImpl.payload(blob), AssetKind.LAYER_METADATA, attributes);
        }
        catch (IOException e) {
            this.log.error("Unable to restore v1 layer metadata id {} and type {}", new Object[]{layerId, type, e});
        }
    }

    @Override
    public void restoreV1LayerContent(String blobName, Blob blob, String layerId, String type) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        DockerDigest digest = DockerRestoreFacetImpl.digestFromPath(blobName, blob);
        attributes.put("content_digest", digest.toString());
        attributes.put("layerId", layerId);
        this.dockerContentFacet.putHardLinkedBlob(blobName, DockerRestoreFacetImpl.payload(blob), AssetKind.LAYER_CONTENT, attributes);
    }

    @Override
    public void restoreV1LayerAncestry(String blobName, Blob blob, String layerId, String type) {
        this.dockerContentFacet.putHardLinkedBlob(blobName, DockerRestoreFacetImpl.payload(blob), AssetKind.LAYER_ANCESTRY, new HashMap<String, Object>());
    }

    @Override
    public void restoreV1Tag(String blobName, Blob blob, String name, String tag) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        DockerDigest digest = DockerRestoreFacetImpl.digestFromPath(blobName, blob);
        attributes.put("content_digest", digest.toString());
        HashMap<String, Object> componentAttributes = new HashMap<String, Object>();
        componentAttributes.put("imageName", name);
        componentAttributes.put("imageTag", tag);
        try {
            String layerId = DockerFacetUtils.readLayerId(() -> ((Blob)blob).getInputStream());
            attributes.put("layerId", layerId);
            componentAttributes.put("layerId", layerId);
        }
        catch (IOException e) {
            this.log.error("Unable to restore v1 tag", (Throwable)e);
        }
        this.dockerContentFacet.putTag(name, tag, DockerRestoreFacetImpl.payload(blob), attributes, componentAttributes);
    }

    @Override
    public void restoreV1Tags(String blobName, Blob blob) {
        this.dockerContentFacet.putHardLinkedBlob(blobName, DockerRestoreFacetImpl.payload(blob), AssetKind.TAGS, new HashMap<String, Object>());
    }

    private DockerDigest getManifestDigest(String name, Blob blob) {
        try {
            return this.v2ManifestUtil.manifestDigest(() -> ((Blob)blob).getInputStream());
        }
        catch (IOException iOException) {
            throw new V2Exception.DigestInvalid("Unable to generate digest for " + name);
        }
    }

    private static DockerDigest digestFromPath(String path, Blob blob) {
        int lastSlashIndex = path.lastIndexOf(47);
        if (lastSlashIndex != -1) {
            path = path.substring(lastSlashIndex + 1);
        }
        try {
            return DockerDigest.parse(path);
        }
        catch (Exception exception) {
            return DockerRestoreFacetImpl.digestFromBlob(blob);
        }
    }

    private static DockerDigest digestFromBlob(Blob blob) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream in = blob.getInputStream();){
                HashAlgorithm algorithm = DockerFacetUtils.DOCKER_DIGEST_ALGORITHM;
                return new DockerDigest(algorithm.name(), Hashes.hash((HashAlgorithm)algorithm, (InputStream)in).toString());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to compute hash for blob " + blob.getId(), e);
        }
    }

    private static Payload payload(Blob blob) {
        return new DetachedBlobPayload(blob);
    }
}

