/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal.datastore.recipe;

import com.google.common.hash.Funnels;
import com.google.common.hash.Hasher;
import com.google.common.hash.PrimitiveSink;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.docker.internal.DockerDigest;
import org.sonatype.nexus.repository.docker.internal.DockerFacetUtils;
import org.sonatype.nexus.repository.docker.internal.datastore.DockerContentFacet;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.types.GroupType;
import org.sonatype.nexus.repository.view.Content;

public final class DockerFacetDatabaseUtils {
    private DockerFacetDatabaseUtils() {
    }

    public static String assetPath(String assetName) {
        return "/" + assetName;
    }

    public static DockerDigest calculateChecksum(Content metadataAsset, Content layerAsset) throws IOException {
        InputStream in;
        Hasher hasher = DockerFacetUtils.DOCKER_DIGEST_ALGORITHM.function().newHasher();
        OutputStream output = Funnels.asOutputStream((PrimitiveSink)hasher);
        Throwable throwable = null;
        Object var5_7 = null;
        try {
            in = metadataAsset.openInputStream();
            try {
                ByteStreams.copy((InputStream)in, (OutputStream)output);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        hasher.putString((CharSequence)"\n", StandardCharsets.UTF_8);
        throwable = null;
        var5_7 = null;
        try {
            in = layerAsset.openInputStream();
            try {
                ByteStreams.copy((InputStream)in, (OutputStream)output);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        return new DockerDigest(DockerFacetUtils.DOCKER_DIGEST_ALGORITHM.name(), hasher.hash().toString());
    }

    public static Optional<FluentAsset> findAsset(Repository repository, String assetPath) {
        if (repository.getType() instanceof GroupType) {
            GroupFacet groupFacet = (GroupFacet)repository.facet(GroupFacet.class);
            for (Repository leafRepository : groupFacet.leafMembers()) {
                DockerContentFacet contentFacet = (DockerContentFacet)leafRepository.facet(DockerContentFacet.class);
                Optional<FluentAsset> asset = contentFacet.findAsset(assetPath);
                if (!asset.isPresent()) continue;
                return asset;
            }
        } else {
            DockerContentFacet contentFacet = (DockerContentFacet)repository.facet(DockerContentFacet.class);
            return contentFacet.findAsset(assetPath);
        }
        return Optional.empty();
    }
}

