/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal.datastore.recipe;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.group.deploy.GroupWriteFacet;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.director.ContentDirector;
import org.sonatype.nexus.repository.content.error.MissingAssetException;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.docker.internal.DockerFacetUtils;
import org.sonatype.nexus.repository.docker.internal.V2Manifest;
import org.sonatype.nexus.repository.docker.internal.V2ManifestUtil;
import org.sonatype.nexus.repository.docker.internal.datastore.DockerContentFacet;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

@Named(value="docker")
@Singleton
public class DockerComponentDirector
implements ContentDirector {
    private final V2ManifestUtil v2ManifestUtil;
    private final RepositoryManager repositoryManager;

    @Inject
    public DockerComponentDirector(V2ManifestUtil v2ManifestUtil, RepositoryManager repositoryManager) {
        this.v2ManifestUtil = (V2ManifestUtil)Preconditions.checkNotNull((Object)v2ManifestUtil);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
    }

    public boolean allowMoveTo(Repository destination) {
        return true;
    }

    public boolean allowMoveTo(FluentComponent component, Repository destination) {
        return !component.attributes().child("docker").contains("layerId");
    }

    public boolean allowMoveFrom(Repository source) {
        return true;
    }

    public Component beforeMove(Component component, List<? extends Asset> assets, Repository source, Repository destination) {
        LinkedList<FluentAsset> queue = new LinkedList<FluentAsset>();
        queue.add(this.componentAssetByDigest(component, assets, source));
        while (!queue.isEmpty()) {
            FluentAsset asset = (FluentAsset)queue.remove();
            if ("MANIFEST".equals(asset.kind())) {
                V2Manifest manifest = this.parseManifest(asset, source);
                queue.addAll(this.manifestChildrenAssets(manifest, component, source));
            }
            this.maybeCopyAsset(asset, destination);
        }
        return component;
    }

    public boolean redeployAllowed(Repository repository, Component component) {
        return super.redeployAllowed(repository, component) || "latest".equalsIgnoreCase(component.version()) && ((DockerContentFacet)repository.facet(DockerContentFacet.class)).canUpdateLatest();
    }

    private FluentAsset componentAssetByDigest(Component component, List<? extends Asset> assets, Repository source) {
        if (assets.size() != 1) {
            throw new IllegalStateException(String.format("Docker component must have exactly one asset; component: %s", component.name()));
        }
        Asset manifestAsset = assets.get(0);
        String manifestDigest = (String)manifestAsset.attributes().child("docker").get("content_digest", String.class);
        if (manifestDigest == null) {
            throw new IllegalStateException(String.format("Docker component asset must reference the manifest digest; component: %s, asset: %s", component.name(), manifestAsset.path()));
        }
        String pathByDigest = String.format("/v2/%s/manifests/%s", component.name(), manifestDigest);
        DockerContentFacet sourceFacet = (DockerContentFacet)source.facet(DockerContentFacet.class);
        return sourceFacet.findAsset(pathByDigest).orElseThrow(() -> new IllegalStateException(String.format("Missing asset: %s", pathByDigest)));
    }

    /*
     * Loose catch block
     */
    private V2Manifest parseManifest(FluentAsset manifestAsset, Repository source) {
        String assetPath = manifestAsset.path();
        DockerContentFacet sourceFacet = (DockerContentFacet)source.facet(DockerContentFacet.class);
        Optional<Content> content = sourceFacet.get(assetPath);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try {
                V2Manifest v2Manifest;
                InputStream inputStream;
                Content manifestContent;
                block18: {
                    block17: {
                        manifestContent = content.orElseThrow(() -> new IllegalStateException(String.format("Failed to read manifest: %s", assetPath)));
                        inputStream = manifestContent.openInputStream();
                        v2Manifest = this.v2ManifestUtil.readManifest(() -> inputStream, "manifest", manifestContent.getContentType());
                        if (inputStream == null) break block17;
                        inputStream.close();
                    }
                    if (manifestContent == null) break block18;
                    manifestContent.close();
                }
                return v2Manifest;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (manifestContent != null) {
                                manifestContent.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Failed to read manifest: %s", manifestAsset.path()), e);
        }
    }

    private List<FluentAsset> manifestChildrenAssets(V2Manifest manifest, Component component, Repository source) {
        DockerContentFacet sourceFacet = (DockerContentFacet)source.facet(DockerContentFacet.class);
        ArrayList<FluentAsset> children = new ArrayList<FluentAsset>();
        this.childrenPaths(manifest, component).forEach(path -> {
            FluentAsset asset = sourceFacet.findAsset((String)path).orElseThrow(() -> new MissingAssetException(path, "docker", this.isWritableMember(source), source.getName(), component.name()));
            children.add(asset);
        });
        return children;
    }

    private boolean isWritableMember(Repository source) {
        return StreamSupport.stream(this.repositoryManager.browse().spliterator(), false).map(repo -> repo.optionalFacet(GroupWriteFacet.class)).filter(Optional::isPresent).map(Optional::get).map(GroupWriteFacet::getWritableMember).filter(Objects::nonNull).anyMatch(writableMember -> writableMember.getName().equals(source.getName()));
    }

    private void maybeCopyAsset(FluentAsset asset, Repository destination) {
        DockerContentFacet destinationFacet = (DockerContentFacet)destination.facet(DockerContentFacet.class);
        TempBlob blob = destinationFacet.blobs().ingest((Payload)asset.download(), DockerFacetUtils.HASH_ALGORITHMS);
        Optional<FluentAsset> destinationAsset = destinationFacet.findAsset(asset.path());
        if (!destinationAsset.isPresent()) {
            destinationFacet.assets().path(asset.path()).kind(asset.kind()).blob(blob).save().withAttribute("docker", (Object)asset.attributes().child("docker").backing());
        }
    }

    private List<String> childrenPaths(V2Manifest manifest, Component component) {
        ArrayList<String> childrenNames = new ArrayList<String>();
        manifest.getListedManifests().forEach(digest -> {
            boolean bl = childrenNames.add(String.format("/v2/%s/manifests/%s", component.name(), digest));
        });
        if (manifest.getListedManifests().isEmpty()) {
            manifest.referencedDigests().forEach(digest -> {
                boolean bl = childrenNames.add(String.format("/v2/-/blobs/%s", digest));
            });
        }
        return childrenNames;
    }
}

