/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal.datastore.browse;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.browse.node.BrowsePath;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.browse.ComponentPathBrowseNodeGenerator;

@Singleton
@Named(value="docker")
public class DockerBrowseNodeGenerator
extends ComponentPathBrowseNodeGenerator {
    private static final String DASH = "-";
    private static final String DIGEST_MANIFESTS_FOLDER = "manifests";
    private static final String TAG_MANIFESTS_FOLDER = "tags";

    public List<BrowsePath> computeAssetPaths(Asset asset) {
        Preconditions.checkNotNull((Object)asset);
        if (asset.component().isPresent()) {
            return this.computeComponentPaths(asset);
        }
        return super.computeAssetPaths(asset).stream().filter(browsePaths -> !DASH.equals(browsePaths.getDisplayName())).collect(Collectors.toList());
    }

    public List<BrowsePath> computeComponentPaths(Asset asset) {
        return super.computeAssetPaths(asset).stream().filter(browsePath -> !DASH.equals(browsePath.getDisplayName())).peek(browsePath -> {
            if (DIGEST_MANIFESTS_FOLDER.equals(browsePath.getDisplayName())) {
                browsePath.setDisplayName(TAG_MANIFESTS_FOLDER);
                browsePath.setRequestPath(browsePath.getRequestPath().replace(DIGEST_MANIFESTS_FOLDER, TAG_MANIFESTS_FOLDER));
            }
        }).collect(Collectors.toList());
    }
}

