/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal.datastore;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.docker.internal.DockerV1Utility;
import org.sonatype.nexus.repository.docker.internal.V1HandlersSupport;
import org.sonatype.nexus.repository.docker.internal.V1SearchResult;
import org.sonatype.nexus.repository.docker.internal.V1SearchResults;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.search.SearchRequest;
import org.sonatype.nexus.repository.search.SearchResponse;
import org.sonatype.nexus.repository.search.SearchService;
import org.sonatype.nexus.repository.search.SortDirection;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

@Named
@Singleton
public class V1Handlers
extends V1HandlersSupport {
    private static final ObjectMapper mapper = new ObjectMapper();
    private final SearchService searchService;

    @Inject
    public V1Handlers(SearchService searchService) {
        this.searchService = (SearchService)Preconditions.checkNotNull((Object)searchService);
    }

    public Response search(Context context) throws JsonProcessingException {
        DockerV1Utility.SearchParams params = DockerV1Utility.parseSearchParameters(context.getRequest().getParameters());
        this.log.debug("[search] query: {} page_size: {} page: {}", new Object[]{params.getQuery(), params.getPageSize(), params.getPage()});
        V1SearchResults searchResults = this.doSearch(params.getQuery(), params.getPageSize(), params.getPage(), context.getRequest().getHeaders().get("Host"), context.getRepository().getName());
        return HttpResponses.ok((Payload)new StringPayload(mapper.writeValueAsString((Object)searchResults), "application/json"));
    }

    @VisibleForTesting
    V1SearchResults doSearch(String query, int page_size, int page, String host, String repository) {
        V1SearchResults searchResults = new V1SearchResults();
        searchResults.setQuery(query);
        searchResults.setPage_size(page_size);
        if (query != null) {
            SearchRequest request = SearchRequest.builder().repository(repository).searchFilter("attributes.docker.imageName", query).sortField("name").sortDirection(SortDirection.ASC).build();
            long countResponse = this.searchService.count(request);
            searchResults.setNum_results((int)countResponse);
            int numPages = (int)Math.ceil((double)searchResults.getNum_results() / (double)page_size);
            numPages = Math.max(numPages, 1);
            searchResults.setNum_pages(numPages);
            searchResults.setPage(Math.min(page, numPages));
            int from = (searchResults.getPage() - 1) * page_size;
            SearchRequest searchRequest = SearchRequest.builder().repository(repository).searchFilter("attributes.docker.imageName", query).offset(Integer.valueOf(from)).limit(Integer.valueOf(page_size)).sortField("name").sortDirection(SortDirection.ASC).build();
            SearchResponse searchResponse = this.searchService.search(searchRequest);
            if (searchResponse.getSearchResults() != null) {
                searchResults.setResults(searchResponse.getSearchResults().stream().map(hit -> {
                    V1SearchResult result = new V1SearchResult();
                    result.setName(String.format("%s/%s:%s", host, hit.getName(), hit.getVersion()));
                    return result;
                }).collect(Collectors.toList()));
            }
        }
        return searchResults;
    }
}

