/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal.datastore;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.docker.internal.DockerDigest;
import org.sonatype.nexus.repository.search.AssetSearchResult;
import org.sonatype.nexus.repository.search.ComponentSearchResult;

public class DockerAssetSearchSupport
extends ComponentSupport {
    @Nullable
    protected AssetSearchResult getSearchAssetMatchingContentDigest(ComponentSearchResult hit, DockerDigest digest) {
        List assets = hit.getAssets();
        if (assets != null) {
            String digestValue = digest.toString();
            for (AssetSearchResult asset : assets) {
                try {
                    Map dockerAttributes;
                    Map attributes = asset.getAttributes();
                    if (attributes == null || (dockerAttributes = (Map)attributes.get("docker")) == null || !digestValue.equals(dockerAttributes.get("content_digest"))) continue;
                    return asset;
                }
                catch (ClassCastException ignore) {
                    this.log.trace("Search result has data in an unexpected format, ignoring", (Throwable)ignore);
                }
            }
        }
        return null;
    }
}

