/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal.auth;

import java.util.Arrays;
import java.util.Base64;
import java.util.stream.Collectors;
import org.sonatype.nexus.common.text.Strings2;

public class DockerTokenDecoder {
    private DockerTokenDecoder() {
    }

    public static String decodeToLoggable(String token) {
        if (Strings2.isBlank((String)token)) {
            return token;
        }
        return Arrays.stream(token.split("\\.")).limit(2L).map(DockerTokenDecoder::decode).map(String::new).collect(Collectors.joining(" + "));
    }

    private static byte[] decode(String part) {
        try {
            return Base64.getDecoder().decode(part);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return part.getBytes();
        }
    }
}

