/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.licensing.ext.LicenseChangedEvent;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.licensing.feature.Feature;
import org.sonatype.licensing.feature.LicenseFeatureVerifier;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.rapture.StateContributor;
import org.sonatype.nexus.repository.docker.internal.DockerSubdomainFeature;

@Named
@Singleton
public class DockerSubdomainFeatureControlService
implements StateContributor,
EventAware {
    private static final String DOCKER_SUBDOMAIN_ENABLED = "dockerSubdomainEnabled";
    private final AtomicBoolean isFeatureAllowed = new AtomicBoolean();
    private final LicenseFeatureVerifier licenseFeatureVerifier;
    private final DockerSubdomainFeature dockerSubdomainFeature;

    @Inject
    public DockerSubdomainFeatureControlService(LicenseFeatureVerifier licenseFeatureVerifier, DockerSubdomainFeature dockerSubdomainFeature) {
        this.licenseFeatureVerifier = licenseFeatureVerifier;
        this.dockerSubdomainFeature = dockerSubdomainFeature;
        this.setIsFeatureAllowed();
    }

    public boolean isFeatureAllowed() {
        return this.isFeatureAllowed.get();
    }

    @Nullable
    public Map<String, Object> getState() {
        return ImmutableMap.of((Object)DOCKER_SUBDOMAIN_ENABLED, (Object)this.isFeatureAllowed());
    }

    @Subscribe
    public void on(LicenseChangedEvent event) {
        this.setIsFeatureAllowed();
    }

    private void setIsFeatureAllowed() {
        this.isFeatureAllowed.set(this.licenseFeatureVerifier.verify((Feature)this.dockerSubdomainFeature));
    }
}

