/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal;

import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentAssets;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.fluent.FluentComponents;
import org.sonatype.nexus.repository.content.replication.ReplicationFacetSupport;
import org.sonatype.nexus.repository.content.replication.ReplicationIngestionService;
import org.sonatype.nexus.repository.docker.internal.AssetKind;
import org.sonatype.nexus.repository.view.matchers.token.TokenParser;

@Named(value="docker")
public class DockerReplicationFacet
extends ReplicationFacetSupport {
    private static final String NAME = "name";
    private static final String TAG = "tag";
    private static final TokenParser manifestPathParser = new TokenParser("/v2/{name:.+}/manifests/{tag}");
    private final ReplicationIngestionService ingestionService;

    @Inject
    public DockerReplicationFacet(ReplicationIngestionService ingestionService) {
        this.ingestionService = Objects.requireNonNull(ingestionService);
    }

    public void doReplicate(String path, Blob blob, Map<String, Object> assetAttributes, Map<String, Object> componentAttributes) {
        ContentFacet contentFacet = (ContentFacet)this.facet(ContentFacet.class);
        FluentAssets fluentAssets = contentFacet.assets();
        FluentComponents fluentComponents = contentFacet.components();
        Map parsedPath = manifestPathParser.parse(path);
        if (parsedPath != null) {
            String name = (String)parsedPath.get(NAME);
            String tag = (String)parsedPath.get(TAG);
            if (tag.contains(":")) {
                this.ingestionService.replicateAsset(fluentAssets, path, blob, assetAttributes, AssetKind.MANIFEST.toString());
            } else {
                FluentComponent component = this.ingestionService.replicateComponent(fluentComponents, componentAttributes, name, tag);
                this.ingestionService.replicateAsset(fluentAssets, path, blob, assetAttributes, AssetKind.MANIFEST.toString(), component);
            }
        } else {
            this.ingestionService.replicateAsset(fluentAssets, path, blob, assetAttributes, AssetKind.BLOB.toString());
        }
    }
}

